/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.scripting;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.interfaces.IVerrechenbar;
import ch.elexis.data.Artikel;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Query;
import ch.elexis.data.Rechnung;
import ch.elexis.data.Verrechnet;
import ch.elexis.data.Zahlung;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CountArticles {
    HashMap<IVerrechenbar, Integer> paid = new HashMap();
    HashMap<IVerrechenbar, Integer> unpaid = new HashMap();
    Money mPaid = new Money();
    Money mUnpaid = new Money();

    public String run(String fromDate, String untilDate, String referenceDate, String outputFile) {
        try {
            Query qbe = new Query(Konsultation.class);
            qbe.add("Datum", ">=", new TimeTool(fromDate).toString(9));
            qbe.add("Datum", "<=", new TimeTool(untilDate).toString(9));
            qbe.add("MandantID", "=", CoreHub.actMandant.getId());
            TimeTool refDate = new TimeTool(referenceDate);
            for (Konsultation k : qbe.execute()) {
                boolean bPaid = false;
                Rechnung r = k.getRechnung();
                if (r != null && r.getOffenerBetrag().isNeglectable()) {
                    List payments = r.getZahlungen();
                    for (Zahlung z : payments) {
                        if (!new TimeTool(z.getDatum()).isBeforeOrEqual(refDate)) continue;
                        bPaid = true;
                        break;
                    }
                }
                List vv = k.getLeistungen();
                for (Verrechnet v : vv) {
                    Integer sum;
                    IVerrechenbar iv = v.getVerrechenbar();
                    if (!(iv instanceof Artikel)) continue;
                    Money price = v.getNettoPreis();
                    int count = v.getZahl();
                    price.multiply((double)count);
                    if (bPaid) {
                        this.mPaid.addMoney(price);
                        sum = this.paid.get(iv);
                        if (sum == null) {
                            sum = new Integer(count);
                            this.paid.put(iv, sum);
                            continue;
                        }
                        sum = sum + count;
                        continue;
                    }
                    this.mUnpaid.addMoney(price);
                    sum = this.unpaid.get(iv);
                    if (sum == null) {
                        sum = new Integer(count);
                        this.unpaid.put(iv, sum);
                        continue;
                    }
                    sum = sum + count;
                }
            }
            if (outputFile != null) {
                Integer sum;
                IVerrechenbar iv;
                File file = new File(outputFile);
                FileWriter fw = new FileWriter(file);
                CSVWriter cs = new CSVWriter(fw);
                cs.writeNext(new String[]{"Artikelstatistik per", refDate.toString(4)});
                cs.writeNext(new String[]{"Bezahlte Artikel", "Anzahl"});
                for (Map.Entry<IVerrechenbar, Integer> entry : this.paid.entrySet()) {
                    iv = entry.getKey();
                    sum = entry.getValue();
                    cs.writeNext(new String[]{iv.getText(), sum.toString()});
                }
                cs.writeNext(new String[]{"Gesamtbetrag:", this.mPaid.getAmountAsString()});
                cs.writeNext(new String[0]);
                cs.writeNext(new String[]{"Unbezahlte Artikel", "Anzahl"});
                for (Map.Entry<IVerrechenbar, Integer> entry : this.unpaid.entrySet()) {
                    iv = entry.getKey();
                    sum = entry.getValue();
                    cs.writeNext(new String[]{iv.getText(), sum.toString()});
                }
                cs.writeNext(new String[]{"Gesamtbetrag:", this.mUnpaid.getAmountAsString()});
                cs.close();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Artikelabgabe von (einschliesslich) ").append(new TimeTool(fromDate).toString(4)).append(" bis (einschliesslich) ").append(new TimeTool(untilDate).toString(4)).append(":\n").append("Bezahlte Artikel: ").append(this.mPaid.getAmountAsString()).append("\n").append("Unbezahlte Artikel: ").append(this.mUnpaid.getAmountAsString()).append("\n").append("(Jeweils per Stichtag " + new TimeTool(referenceDate).toString(4)).append(")\n");
            return sb.toString();
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            return "Error executing Script: " + ex.getMessage();
        }
    }
}

