/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.RnActions;
import ch.elexis.core.ui.views.rechnung.RnContentProvider;
import ch.elexis.core.ui.views.rechnung.RnControlFieldProvider;
import ch.elexis.core.ui.views.rechnung.RnMenuListener;
import ch.elexis.core.ui.views.rechnung.invoice.InvoiceListBottomComposite;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Rechnung;
import ch.rgw.io.Settings;
import ch.rgw.tools.Tree;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class RechnungsListeView
extends ViewPart
implements ElexisEventListener {
    public static final String ID = "ch.elexis.RechnungsListeView";
    CommonViewer cv;
    ViewerConfigurer vc;
    RnActions actions;
    RnContentProvider cntp;
    RnControlFieldProvider cfp;
    private Settings rnStellerSettings;
    private InvoiceListBottomComposite invoiceListeBottomComposite;
    private ElexisEventListener eeli_mandant = new ElexisUiEventListenerImpl(Mandant.class, 128){

        @Override
        public void runInUi(ElexisEvent ev) {
            Mandant m = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
            if (m != null) {
                RechnungsListeView.this.rnStellerSettings = CoreHub.getUserSetting((Kontakt)m.getRechnungssteller());
                RechnungsListeView.this.checkRnStellerSettingsValidity(m);
                if (RechnungsListeView.this.invoiceListeBottomComposite != null) {
                    RechnungsListeView.this.invoiceListeBottomComposite.updateMahnAutomatic();
                }
            }
        }
    };
    private final ElexisEvent eetmpl = new ElexisEvent(null, Rechnung.class, 8);

    public RechnungsListeView() {
        Mandant currMandant = (Mandant)ElexisEventDispatcher.getSelected(Mandant.class);
        this.rnStellerSettings = CoreHub.getUserSetting((Kontakt)currMandant.getRechnungssteller());
        this.checkRnStellerSettingsValidity(currMandant);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_mandant});
    }

    private void checkRnStellerSettingsValidity(Mandant mandant) {
        if (this.rnStellerSettings == null) {
            Kontakt k = null;
            KontaktSelektor ksDialog = new KontaktSelektor(UiDesk.getTopShell(), Anwender.class, Messages.RechnungsListeView_selectRnSteller, Messages.RechnungsListeView_selectRnStellerMsg, new String[]{"Bezeichnung1", "Bezeichnung2"});
            if (ksDialog.open() == 0 && ksDialog.getSelection() != null && (k = (Kontakt)ksDialog.getSelection()) != null) {
                mandant.setRechnungssteller(k);
                this.rnStellerSettings = CoreHub.getUserSetting((Kontakt)k);
            }
        }
        if (this.rnStellerSettings == null) {
            MessageDialog.openError((Shell)UiDesk.getTopShell(), (String)Messages.RechnungsListeView_error, (String)Messages.RechnungsListeView_errorNoRnStellerSelected);
        }
    }

    public void createPartControl(Composite p) {
        p.setLayout((Layout)new GridLayout());
        Composite comp = new Composite(p, 0);
        comp.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        comp.setLayout((Layout)new GridLayout());
        this.cv = new CommonViewer();
        this.cntp = new RnContentProvider(this, this.cv);
        this.cfp = new RnControlFieldProvider();
        this.vc = new ViewerConfigurer(this.cntp, new ViewerConfigurer.TreeLabelProvider(), this.cfp, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(0, 514, this.cv));
        this.cv.create(this.vc, comp, 2048, this.getViewSite());
        this.cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                if (obj instanceof Patient) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Patient)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.PatDetail_v2");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                } else if (obj instanceof Fall) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Fall)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.FallDetailView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                } else if (obj instanceof Rechnung) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Rechnung)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.RechnungsDetailView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.invoiceListeBottomComposite = new InvoiceListBottomComposite(comp, 0, this.rnStellerSettings);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this});
        this.cv.getViewerWidget().getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ViewMenus menu = new ViewMenus(this.getViewSite());
        this.actions = new RnActions(this);
        menu.createToolbar(new IAction[]{this.actions.reloadAction, this.actions.mahnWizardAction, this.actions.rnFilterAction, null, this.actions.rnExportAction});
        menu.createMenu(new IAction[]{this.actions.expandAllAction, this.actions.collapseAllAction, this.actions.printListeAction, this.actions.exportListAction, this.actions.addAccountExcessAction});
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener((IMenuListener)new RnMenuListener(this));
        this.cv.setContextMenu(mgr);
        this.cntp.startListening();
    }

    public InvoiceListBottomComposite getInvoiceListeBottomComposite() {
        return this.invoiceListeBottomComposite;
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this});
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_mandant});
        this.cntp.stopListening();
        super.dispose();
    }

    public void setFocus() {
    }

    List<Rechnung> createList() {
        IStructuredSelection sel = (IStructuredSelection)this.cv.getViewerWidget().getSelection();
        List at = sel.toList();
        LinkedList<Rechnung> ret = new LinkedList<Rechnung>();
        for (Tree t : at) {
            Rechnung rn;
            if (t.contents instanceof Patient) {
                for (Tree tp : t.getChildren()) {
                    for (Tree tf : tp.getChildren()) {
                        Rechnung rn2 = (Rechnung)tf.contents;
                        if (ret.contains(rn2)) continue;
                        ret.add(rn2);
                    }
                }
                continue;
            }
            if (t.contents instanceof Fall) {
                for (Tree tr : t.getChildren()) {
                    Rechnung rn3 = (Rechnung)tr.contents;
                    if (ret.contains(rn3)) continue;
                    ret.add(rn3);
                }
                continue;
            }
            if (!(t.contents instanceof Rechnung) || ret.contains(rn = (Rechnung)t.contents)) continue;
            ret.add(rn);
        }
        return ret;
    }

    public void catchElexisEvent(ElexisEvent ev) {
        this.cv.notify(CommonViewer.Message.update);
    }

    public ElexisEvent getElexisEventFilter() {
        return this.eetmpl;
    }
}

