/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.rechnung;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.ui.Hub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.commands.ErstelleRnnCommand;
import ch.elexis.core.ui.dialogs.KonsZumVerrechnenWizardDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.viewers.BasicTreeContentProvider;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.rechnung.KonsZumVerrechnenViewViewerComparator;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.core.ui.views.rechnung.Rechnungslauf;
import ch.elexis.core.ui.views.rechnung.VerrDetailDialog;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.LazyTree;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.Tree;
import com.tiff.common.ui.datepicker.DatePickerCombo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IProgressService;

public class KonsZumVerrechnenView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "ch.elexis.BehandlungenVerrechnenView";
    CommonViewer cv;
    ViewerConfigurer vc;
    FormToolkit tk = UiDesk.getToolkit();
    Form left;
    Form right;
    LazyTree tAll;
    Tree tSelection;
    TreeViewer tvSel;
    LazyTree.LazyTreeListener ltl;
    ViewMenus menu;
    private IAction billAction;
    private IAction printAction;
    private IAction clearAction;
    private IAction wizardAction;
    private IAction refreshAction;
    private IAction detailAction;
    private IAction removeAction;
    private IAction expandSelAction;
    private IAction expandSelAllAction;
    private IAction selectByDateAction;
    KonsZumVerrechnenView self;

    public KonsZumVerrechnenView() {
        this.cv = new CommonViewer();
        this.ltl = new RLazyTreeListener();
        this.tSelection = new Tree(null, null);
        this.tAll = new LazyTree(null, null, this.ltl);
        this.self = this;
    }

    public void dispose() {
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.vc = new ViewerConfigurer(new BasicTreeContentProvider(), new ViewerConfigurer.TreeLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Tree) {
                    Tree tree = (Tree)element;
                    PersistentObject po = (PersistentObject)tree.contents;
                    if (po instanceof Fall) {
                        if (po.isValid()) {
                            return Images.IMG_OK.getImage();
                        }
                        return Images.IMG_FEHLER.getImage();
                    }
                }
                return null;
            }
        }, null, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(0, 514, this.cv));
        SashForm sash = new SashForm(parent, 0);
        this.left = this.tk.createForm((Composite)sash);
        Composite cLeft = this.left.getBody();
        this.left.setText(Messages.KonsZumVerrechnenView_allOpenCons);
        cLeft.setLayout((Layout)new GridLayout());
        this.cv.create(this.vc, cLeft, 0, this.tAll);
        this.cv.getViewerWidget().setComparator((ViewerComparator)new KonsZumVerrechnenViewViewerComparator());
        this.cv.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                if (obj instanceof Patient) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Patient)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.PatDetail_v2");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                } else if (obj instanceof Fall) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Fall)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.FallDetailView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                } else if (obj instanceof Konsultation) {
                    try {
                        ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((Konsultation)obj));
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.Konsdetail");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.right = this.tk.createForm((Composite)sash);
        Composite cRight = this.right.getBody();
        this.right.setText(Messages.KonsZumVerrechnenView_selected);
        cRight.setLayout((Layout)new GridLayout());
        this.tvSel = new TreeViewer(cRight, 514);
        this.tvSel.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tvSel.setContentProvider((IContentProvider)new BasicTreeContentProvider());
        this.tvSel.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((PersistentObject)((Tree)element).contents).getLabel();
            }
        });
        this.tvSel.setComparator((ViewerComparator)new KonsZumVerrechnenViewViewerComparator());
        this.tvSel.addDropSupport(3, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 1;
            }

            public void drop(DropTargetEvent event) {
                String[] dl;
                String drp = (String)event.data;
                String[] stringArray = dl = drp.split(",");
                int n = dl.length;
                int n2 = 0;
                while (n2 < n) {
                    String obj = stringArray[n2];
                    PersistentObject dropped = CoreHub.poFactory.createFromString(obj);
                    if (dropped instanceof Patient) {
                        KonsZumVerrechnenView.this.selectPatient((Patient)dropped, (Tree)KonsZumVerrechnenView.this.tAll, KonsZumVerrechnenView.this.tSelection);
                    } else if (dropped instanceof Fall) {
                        KonsZumVerrechnenView.this.selectFall((Fall)dropped, (Tree)KonsZumVerrechnenView.this.tAll, KonsZumVerrechnenView.this.tSelection);
                    } else if (dropped instanceof Konsultation) {
                        KonsZumVerrechnenView.this.selectBehandlung((Konsultation)dropped, (Tree)KonsZumVerrechnenView.this.tAll, KonsZumVerrechnenView.this.tSelection);
                    }
                    ++n2;
                }
                KonsZumVerrechnenView.this.tvSel.refresh(true);
            }
        });
        this.tvSel.addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        this.tvSel.setInput((Object)this.tSelection);
        sash.setWeights(new int[]{60, 40});
        this.makeActions();
        MenuManager selMenu = new MenuManager();
        selMenu.setRemoveAllWhenShown(true);
        selMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(KonsZumVerrechnenView.this.removeAction);
                manager.add(KonsZumVerrechnenView.this.expandSelAction);
                manager.add(KonsZumVerrechnenView.this.expandSelAllAction);
            }
        });
        this.tvSel.getControl().setMenu(selMenu.createContextMenu(this.tvSel.getControl()));
        this.tvSel.getControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                TreeItem grandpa;
                org.eclipse.swt.widgets.Tree theWidget = (org.eclipse.swt.widgets.Tree)event.widget;
                TreeItem obj = theWidget.getSelection()[0];
                TreeItem parent = obj.getParentItem();
                String viewID = "";
                viewID = parent == null ? "ch.elexis.PatDetail_v2" : ((grandpa = parent.getParentItem()) == null ? "ch.elexis.FallDetailView" : "ch.elexis.Konsdetail");
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        this.menu = new ViewMenus(this.getViewSite());
        this.menu.createToolbar(this.refreshAction, this.wizardAction, this.printAction, this.clearAction, null, this.billAction);
        this.menu.createMenu(this.wizardAction, this.selectByDateAction);
        this.menu.createViewerContextMenu(this.cv.getViewerWidget(), this.detailAction);
        this.addPartActivationListener();
    }

    public void setFocus() {
    }

    public void selectKonsultation(Konsultation k) {
        this.selectBehandlung(k, (Tree)this.tAll, this.tSelection);
    }

    private Tree selectPatient(Patient pat, Tree tSource, Tree tDest) {
        Tree pSource = tSource.find((Object)pat, false);
        Tree pDest = tDest.find((Object)pat, false);
        if (pDest == null) {
            pDest = pSource == null ? tDest.add((Object)pat) : pSource.move(tDest);
        } else if (pSource != null) {
            List fs = (List)pSource.getChildren();
            for (Tree t : fs) {
                this.selectFall((Fall)t.contents, tSource, tDest);
            }
        }
        this.cv.getViewerWidget().refresh((Object)tSource);
        return pDest;
    }

    private Tree selectFall(Fall f, Tree tSource, Tree tDest) {
        Tree tFall;
        Patient pat = f.getPatient();
        Tree tPat = tDest.find((Object)pat, false);
        if (tPat == null) {
            tPat = tDest.add((Object)pat);
        }
        if ((tFall = tSource.find((Object)f, true)) == null) {
            tFall = tPat.add((Object)f);
        } else {
            Tree tOld = tFall.getParent();
            tPat.merge(tFall);
            if (tOld.getFirstChild() == null) {
                tSource.remove(tOld);
            }
            this.cv.getViewerWidget().refresh((Object)tOld);
        }
        return tFall;
    }

    private Tree selectBehandlung(Konsultation bh, Tree tSource, Tree tDest) {
        Tree tps;
        Tree tBeh;
        Tree tFall;
        Fall f = bh.getFall();
        Patient pat = f.getPatient();
        Tree tPat = tDest.find((Object)pat, false);
        if (tPat == null) {
            tPat = tDest.add((Object)pat);
        }
        if ((tFall = tPat.find((Object)f, false)) == null) {
            tFall = tPat.add((Object)f);
        }
        if ((tBeh = tFall.find((Object)bh, false)) == null) {
            tBeh = tFall.add((Object)bh);
        }
        if ((tps = tSource.find((Object)pat, false)) != null) {
            Tree tfs = tps.find((Object)f, false);
            if (tfs != null) {
                Tree tbs = tfs.find((Object)bh, false);
                if (tbs != null) {
                    tfs.remove(tbs);
                    this.cv.getViewerWidget().refresh((Object)tfs);
                }
                if (!tfs.hasChildren()) {
                    tps.remove(tfs);
                    this.cv.getViewerWidget().refresh((Object)tps);
                }
            }
            if (!tps.hasChildren()) {
                tSource.remove(tps);
                this.cv.getViewerWidget().refresh((Object)tSource);
            }
        }
        return tBeh;
    }

    private void makeActions() {
        this.billAction = new Action(Messages.KonsZumVerrechnenView_createInvoices){
            {
                this.setImageDescriptor(Images.IMG_BILL.getImageDescriptor());
                this.setToolTipText(Messages.KonsZumVerrechnenView_createInvoices);
            }

            public void run() {
                if (((StructuredSelection)KonsZumVerrechnenView.this.tvSel.getSelection()).size() > 0 && !SWTHelper.askYesNo(Messages.KonsZumVerrechnenView_RealleCreateBillsCaption, Messages.KonsZumVerrechnenView_ReallyCreateBillsBody)) {
                    return;
                }
                ErstelleRnnCommand.ExecuteWithParams(KonsZumVerrechnenView.this.getViewSite(), KonsZumVerrechnenView.this.tSelection);
                KonsZumVerrechnenView.this.tvSel.refresh();
            }
        };
        this.clearAction = new Action(Messages.KonsZumVerrechnenView_clearSelection){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
                this.setToolTipText(Messages.KonsZumVerrechnenView_deleteList);
            }

            public void run() {
                KonsZumVerrechnenView.this.tSelection.clear();
                KonsZumVerrechnenView.this.tvSel.refresh();
            }
        };
        this.refreshAction = new Action(Messages.KonsZumVerrechnenView_reloadAction){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
                this.setToolTipText(Messages.KonsZumVerrechnenView_reloadToolTip);
            }

            public void run() {
                KonsZumVerrechnenView.this.tAll.clear();
                KonsZumVerrechnenView.this.cv.notify(CommonViewer.Message.update);
                KonsZumVerrechnenView.this.tvSel.refresh(true);
            }
        };
        this.wizardAction = new Action(Messages.KonsZumVerrechnenView_autoAction){
            {
                this.setImageDescriptor(Images.IMG_WIZARD.getImageDescriptor());
                this.setToolTipText(Messages.KonsZumVerrechnenView_autoToolTip);
            }

            public void run() {
                KonsZumVerrechnenWizardDialog kzvd = new KonsZumVerrechnenWizardDialog(KonsZumVerrechnenView.this.getViewSite().getShell());
                if (kzvd.open() == 0) {
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    try {
                        progressService.runInUI((IRunnableContext)progressService, (IRunnableWithProgress)new Rechnungslauf(KonsZumVerrechnenView.this.self, kzvd.bMarked, kzvd.ttFirstBefore, kzvd.ttLastBefore, kzvd.mAmount, kzvd.bQuartal, kzvd.bSkip, kzvd.ttFrom, kzvd.ttTo, kzvd.accountSys), null);
                    }
                    catch (Throwable ex) {
                        ExHandler.handle((Throwable)ex);
                    }
                    KonsZumVerrechnenView.this.tvSel.refresh();
                    KonsZumVerrechnenView.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
        this.printAction = new Action(Messages.KonsZumVerrechnenView_printSelection){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText(Messages.KonsZumVerrechnenView_printToolTip);
            }

            public void run() {
                new SelectionPrintDialog(KonsZumVerrechnenView.this.getViewSite().getShell()).open();
            }
        };
        this.removeAction = new Action(Messages.KonsZumVerrechnenView_removeFromSelection){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)KonsZumVerrechnenView.this.tvSel.getSelection();
                if (!sel.isEmpty()) {
                    for (Object o : sel.toList()) {
                        if (!(o instanceof Tree)) continue;
                        Tree t = (Tree)o;
                        if (t.contents instanceof Patient) {
                            KonsZumVerrechnenView.this.selectPatient((Patient)t.contents, KonsZumVerrechnenView.this.tSelection, (Tree)KonsZumVerrechnenView.this.tAll);
                            continue;
                        }
                        if (t.contents instanceof Fall) {
                            KonsZumVerrechnenView.this.selectFall((Fall)t.contents, KonsZumVerrechnenView.this.tSelection, (Tree)KonsZumVerrechnenView.this.tAll);
                            continue;
                        }
                        if (!(t.contents instanceof Konsultation)) continue;
                        KonsZumVerrechnenView.this.selectBehandlung((Konsultation)t.contents, KonsZumVerrechnenView.this.tSelection, (Tree)KonsZumVerrechnenView.this.tAll);
                    }
                    KonsZumVerrechnenView.this.tvSel.refresh();
                    KonsZumVerrechnenView.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
        this.expandSelAction = new Action(Messages.KonsZumVerrechnenView_expand){

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)KonsZumVerrechnenView.this.tvSel.getSelection();
                if (!sel.isEmpty()) {
                    for (Object o : sel.toList()) {
                        if (!(o instanceof Tree)) continue;
                        Tree t = (Tree)o;
                        KonsZumVerrechnenView.this.tvSel.expandToLevel((Object)t, -1);
                    }
                }
            }
        };
        this.expandSelAllAction = new Action(Messages.KonsZumVerrechnenView_expandAll){

            public void run() {
                KonsZumVerrechnenView.this.tvSel.expandAll();
            }
        };
        this.selectByDateAction = new Action(Messages.KonsZumVerrechnenView_selectByDateAction){
            TimeTool fromDate;
            TimeTool toDate;
            {
                this.setImageDescriptor(Images.IMG_WIZARD.getImageDescriptor());
                this.setToolTipText(Messages.KonsZumVerrechnenView_selectByDateActionToolTip);
            }

            public void run() {
                SelectDateDialog dialog = new SelectDateDialog(KonsZumVerrechnenView.this.getViewSite().getShell());
                if (dialog.open() == 0) {
                    this.fromDate = dialog.getFromDate();
                    this.toDate = dialog.getToDate();
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    try {
                        progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) {
                                KonsZumVerrechnenView.this.doSelectByDate(monitor, fromDate, toDate);
                            }
                        }, null);
                    }
                    catch (Throwable ex) {
                        ExHandler.handle((Throwable)ex);
                    }
                    KonsZumVerrechnenView.this.tvSel.refresh();
                    KonsZumVerrechnenView.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
        this.detailAction = new RestrictedAction(AccessControlDefaults.LSTG_VERRECHNEN, Messages.KonsZumVerrechnenView_billingDetails){

            @Override
            public void doRun() {
                Object[] sel = KonsZumVerrechnenView.this.cv.getSelection();
                if (sel != null && sel.length > 0) {
                    new VerrDetailDialog(KonsZumVerrechnenView.this.getViewSite().getShell(), (Tree)sel[0]).open();
                }
            }
        };
    }

    private void doSelectByDate(IProgressMonitor monitor, TimeTool fromDate, TimeTool toDate) {
        TimeTool actDate = new TimeTool();
        TimeTool date1 = new TimeTool(fromDate);
        TimeTool date2 = new TimeTool(toDate);
        date1.chop(3);
        date2.add(5, 1);
        date2.chop(3);
        List lAll = (List)this.tAll.getChildren();
        monitor.beginTask(Messages.KonsZumVerrechnenView_selectByDateTask, lAll.size() + 1);
        for (Tree tP : lAll) {
            monitor.worked(1);
            for (Tree tF : (List)tP.getChildren()) {
                List tK = (List)tF.getChildren();
                for (Tree tk : tK) {
                    Konsultation k = (Konsultation)tk.contents;
                    actDate.set(k.getDatum());
                    if (!actDate.isAfterOrEqual(date1) || !actDate.isBefore(date2)) continue;
                    this.selectBehandlung((Konsultation)tk.contents, (Tree)this.tAll, this.tSelection);
                }
                if (!monitor.isCanceled()) continue;
                monitor.done();
                return;
            }
        }
        monitor.done();
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public CommonViewer getLeftSide() {
        return this.cv;
    }

    public TreeViewer getRightSide() {
        return this.tvSel;
    }

    private void addPartActivationListener() {
        this.getViewSite().getPage().addPartListener(new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                Command command = commandService.getCommand("ch.elexis.core.command.linkViews");
                boolean state = (Boolean)command.getState("org.eclipse.ui.commands.toggleState").getValue();
                if (state) {
                    try {
                        command.getState("org.eclipse.ui.commands.toggleState").setValue((Object)Boolean.FALSE);
                        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
                        handlerService.executeCommand("ch.elexis.core.command.linkViews", null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                KonsZumVerrechnenView.this.getViewSite().getPage().removePartListener((IPartListener)this);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        });
    }

    class RLazyTreeListener
    implements LazyTree.LazyTreeListener {
        final LazyTree.LazyTreeListener self = this;

        RLazyTreeListener() {
        }

        public boolean fetchChildren(final LazyTree l) {
            PersistentObject cont = (PersistentObject)l.contents;
            final JdbcLink.Stm stm = PersistentObject.getConnection().getStatement();
            if (cont == null) {
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            monitor.beginTask(Messages.KonsZumVerrechnenView_findCons, 100);
                            monitor.subTask(Messages.KonsZumVerrechnenView_databaseRequest);
                            String sql = "SELECT distinct PATIENTID FROM FAELLE JOIN BEHANDLUNGEN ON BEHANDLUNGEN.FALLID=FAELLE.ID WHERE BEHANDLUNGEN.deleted='0' AND BEHANDLUNGEN.billable='1' AND BEHANDLUNGEN.RECHNUNGSID is null ";
                            if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_GLOBAL)) {
                                sql = String.valueOf(sql) + "AND BEHANDLUNGEN.MANDANTID=" + CoreHub.actMandant.getWrappedId();
                            }
                            ResultSet rs = stm.query(sql);
                            monitor.worked(10);
                            monitor.subTask(Messages.KonsZumVerrechnenView_readIn);
                            try {
                                while (rs != null && rs.next()) {
                                    String s = rs.getString(1);
                                    Patient p = Patient.load((String)s);
                                    if (p.exists() && ((RLazyTreeListener)RLazyTreeListener.this).KonsZumVerrechnenView.this.tSelection.find((Object)p, false) == null) {
                                        new LazyTree((Tree)l, (Object)p, RLazyTreeListener.this.self);
                                    }
                                    monitor.worked(1);
                                }
                                monitor.done();
                            }
                            catch (SQLException e) {
                                ExHandler.handle((Throwable)e);
                            }
                        }
                    }, null);
                }
                catch (Throwable ex) {
                    ExHandler.handle((Throwable)ex);
                }
            } else {
                ResultSet rs = null;
                try {
                    try {
                        if (cont instanceof Patient) {
                            String sql = "SELECT distinct FAELLE.ID FROM FAELLE join BEHANDLUNGEN ON BEHANDLUNGEN.FALLID=FAELLE.ID WHERE BEHANDLUNGEN.RECHNUNGSID is null AND BEHANDLUNGEN.DELETED='0' AND BEHANDLUNGEN.billable='1' AND FAELLE.PATIENTID=" + cont.getWrappedId();
                            if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_GLOBAL)) {
                                sql = String.valueOf(sql) + " AND BEHANDLUNGEN.MANDANTID=" + CoreHub.actMandant.getWrappedId();
                            }
                            rs = stm.query(sql);
                            while (rs != null && rs.next()) {
                                String s = rs.getString(1);
                                Fall f = Fall.load((String)s);
                                if (f == null || !f.exists() || KonsZumVerrechnenView.this.tSelection.find((Object)f, true) != null) continue;
                                new LazyTree((Tree)l, (Object)f, (LazyTree.LazyTreeListener)this);
                            }
                        } else if (cont instanceof Fall) {
                            String sql = "SELECT ID FROM BEHANDLUNGEN WHERE RECHNUNGSID is null AND deleted='0' AND billable='1' AND FALLID=" + cont.getWrappedId();
                            if (!CoreHub.acl.request(AccessControlDefaults.ACCOUNTING_GLOBAL)) {
                                sql = String.valueOf(sql) + " AND MANDANTID=" + CoreHub.actMandant.getWrappedId();
                            }
                            rs = stm.query(sql);
                            while (rs != null && rs.next()) {
                                String s = rs.getString(1);
                                Konsultation b = Konsultation.load((String)s);
                                if (!b.exists() || KonsZumVerrechnenView.this.tSelection.find((Object)b, true) != null) continue;
                                new LazyTree((Tree)l, (Object)b, (LazyTree.LazyTreeListener)this);
                            }
                        }
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        ExHandler.handle((Throwable)e);
                        PersistentObject.getConnection().releaseStatement(stm);
                    }
                }
                finally {
                    PersistentObject.getConnection().releaseStatement(stm);
                }
            }
            return false;
        }

        public boolean hasChildren(LazyTree l) {
            Object po = l.contents;
            return !(po instanceof Konsultation);
        }
    }

    public class SelectDateDialog
    extends TitleAreaDialog {
        DatePickerCombo dpFromDate;
        DatePickerCombo dpToDate;
        TimeTool fromDate;
        TimeTool toDate;

        public SelectDateDialog(Shell parentShell) {
            super(parentShell);
            this.fromDate = null;
            this.toDate = null;
        }

        public void create() {
            super.create();
            this.setTitle(Messages.SelectDateDialog_choosePeriodTitle);
            this.setMessage(Messages.SelectDateDialog_choosePeriodMessage);
            this.getShell().setText(Messages.SelectDateDialog_description);
        }

        protected Control createDialogArea(Composite parent) {
            Composite com = new Composite(parent, 0);
            com.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            com.setLayout((Layout)new GridLayout(2, false));
            new Label(com, 0).setText(Messages.SelectDateDialog_from);
            new Label(com, 0).setText(Messages.SelectDateDialog_to);
            this.dpFromDate = new DatePickerCombo(com, 0);
            this.dpToDate = new DatePickerCombo(com, 0);
            return com;
        }

        protected void okPressed() {
            Date date = this.dpFromDate.getDate();
            this.fromDate = date == null ? new TimeTool("19700101") : new TimeTool(date.getTime());
            date = this.dpToDate.getDate();
            this.toDate = date == null ? new TimeTool("20380118") : new TimeTool(date.getTime());
            super.okPressed();
        }

        public TimeTool getFromDate() {
            return this.fromDate;
        }

        public TimeTool getToDate() {
            return this.toDate;
        }
    }

    class SelectionPrintDialog
    extends TitleAreaDialog
    implements ITextPlugin.ICallback {
        private TextContainer text;

        public SelectionPrintDialog(Shell shell) {
            super(shell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite ret = new Composite(parent, 0);
            this.text = new TextContainer(this.getShell());
            ret.setLayout((Layout)new FillLayout());
            ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
            this.text.getPlugin().createContainer(ret, this);
            this.text.getPlugin().showMenu(false);
            this.text.getPlugin().showToolbar(false);
            this.text.createFromTemplateName(null, "Liste", "Allg.", (Kontakt)CoreHub.actUser, Messages.KonsZumVerrechnenView_billsTitle);
            Tree[] all = KonsZumVerrechnenView.this.tSelection.getChildren().toArray(new Tree[0]);
            String[][] table = new String[all.length][];
            int i = 0;
            while (i < all.length) {
                table[i] = new String[2];
                Tree tr = all[i];
                if (tr.contents instanceof Konsultation) {
                    tr = tr.getParent();
                }
                if (tr.contents instanceof Fall) {
                    tr = tr.getParent();
                }
                Patient p = (Patient)tr.contents;
                StringBuilder sb = new StringBuilder();
                sb.append(p.getLabel());
                Tree[] treeArray = tr.getChildren().toArray(new Tree[0]);
                int n = treeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Tree tFall = treeArray[n2];
                    Fall fall = (Fall)tFall.contents;
                    sb.append(Messages.KonsZumVerrechnenView_case).append(fall.getLabel());
                    Tree[] treeArray2 = tFall.getChildren().toArray(new Tree[0]);
                    int n3 = treeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Tree tRn = treeArray2[n4];
                        Konsultation k = (Konsultation)tRn.contents;
                        sb.append(Messages.KonsZumVerrechnenView_kons).append(k.getLabel());
                        ++n4;
                    }
                    ++n2;
                }
                table[i][0] = sb.toString();
                ++i;
            }
            this.text.getPlugin().setFont("Helvetica", 0, 9.0f);
            this.text.getPlugin().insertTable("[Liste]", 0, table, new int[]{90, 10});
            return ret;
        }

        public void create() {
            super.create();
            this.getShell().setText(Messages.KonsZumVerrechnenView_billsList);
            this.setTitle(Messages.KonsZumVerrechnenView_printListCaption);
            this.setMessage(Messages.KonsZumVerrechnenView_printListMessage);
            this.getShell().setSize(900, 700);
            SWTHelper.center(Hub.plugin.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getShell());
        }

        protected void okPressed() {
            super.okPressed();
        }

        @Override
        public void save() {
        }

        @Override
        public boolean saveAs() {
            return false;
        }
    }
}

