/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.provider;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.StockService;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.data.Artikel;
import ch.elexis.data.Mandant;
import ch.elexis.data.StockEntry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class StockEntryLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof StockEntry && columnIndex == 0) {
            StockEntry se = (StockEntry)element;
            IOrderEntry order = CoreHub.getOrderService().findOpenOrderEntryForStockEntry((IStockEntry)se);
            if (order != null) {
                return Images.IMG_BAGGAGE_CART_BOX.getImage();
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof StockEntry) {
            StockEntry se = (StockEntry)element;
            Artikel article = se.getArticle();
            switch (columnIndex) {
                case 0: {
                    return se.getStock().getCode();
                }
                case 1: {
                    return article != null ? article.getPharmaCode() : "";
                }
                case 2: {
                    return article != null ? article.getEAN() : "";
                }
                case 3: {
                    return article != null ? article.getLabel() : "";
                }
                case 4: {
                    return article != null && article.getVKPreis() != null ? article.getVKPreis().toString() : "";
                }
                case 5: {
                    return Integer.toString(se.getMinimumStock());
                }
                case 6: {
                    return Integer.toString(se.getCurrentStock());
                }
                case 7: {
                    return Integer.toString(se.getMaximumStock());
                }
                case 8: {
                    return se.getProvider() != null ? se.getProvider().getLabel() : "";
                }
            }
            return "";
        }
        if (element instanceof String && columnIndex == 3) {
            return (String)element;
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        StockEntry se;
        IStockService.Availability availability;
        if (element instanceof StockEntry && (availability = StockService.determineAvailability((IStockEntry)(se = (StockEntry)element))) != null) {
            switch (availability) {
                case CRITICAL_STOCK: 
                case OUT_OF_STOCK: {
                    return UiDesk.getColor("rot");
                }
            }
            return UiDesk.getColor("blau");
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        StockEntry se;
        Mandant owner;
        if (element instanceof StockEntry && (owner = (se = (StockEntry)element).getStock().getOwner()) != null) {
            return UiMandant.getColorForMandator(owner);
        }
        return null;
    }

    public static class ColumnStockEntryLabelProvider
    extends ColumnLabelProvider {
        private int index;
        private StockEntryLabelProvider labelProvider;

        public ColumnStockEntryLabelProvider(int index, StockEntryLabelProvider labelProvider) {
            this.labelProvider = labelProvider;
            this.index = index;
        }

        public String getText(Object element) {
            return this.labelProvider.getColumnText(element, this.index);
        }

        public Image getImage(Object element) {
            return this.labelProvider.getColumnImage(element, this.index);
        }

        public Color getForeground(Object element) {
            return this.labelProvider.getForeground(element, this.index);
        }

        public Color getBackground(Object element) {
            return this.labelProvider.getBackground(element, this.index);
        }
    }
}

