/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.controls;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.StockService;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.ui.editors.KontaktSelektorDialogCellEditor;
import ch.elexis.data.Artikel;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Stock;
import ch.elexis.data.StockEntry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockDetailComposite
extends Composite {
    private WritableValue wvArtikel = new WritableValue(null, Artikel.class);
    private Logger log = LoggerFactory.getLogger(StockDetailComposite.class);
    private Table table;
    private Map<Stock, IStockEntry> stockEntries = new HashMap<Stock, IStockEntry>();
    private CheckboxTableViewer checkboxTableViewer;
    private StockService stockService = CoreHub.getStockService();

    public StockDetailComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        Composite composite = new Composite((Composite)this, 0);
        TableColumnLayout tcl_composite = new TableColumnLayout();
        composite.setLayout((Layout)tcl_composite);
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)67584);
        this.checkboxTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.table = this.checkboxTableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setEnabled(false);
        TableViewerColumn tableViewerColumn = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Stock stock = (Stock)element;
                if (stock == null) {
                    return null;
                }
                return stock.getCode();
            }
        });
        TableColumn tblclmnStock = tableViewerColumn.getColumn();
        tblclmnStock.setResizable(true);
        tblclmnStock.setAlignment(0x1000000);
        tcl_composite.setColumnData((Widget)tblclmnStock, (ColumnLayoutData)new ColumnPixelData(100, false, false));
        tblclmnStock.setText("Verf\u00fcgbar in Lager");
        TableViewerColumn tvcMin = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport sees = new StockEntryEditingSupport(this.checkboxTableViewer, 0);
        tvcMin.setEditingSupport((EditingSupport)sees);
        tvcMin.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getMinimumStock());
                }
                return null;
            }
        });
        TableColumn tblclmnMin = tvcMin.getColumn();
        tblclmnMin.setResizable(true);
        tblclmnMin.setAlignment(0x1000000);
        tcl_composite.setColumnData((Widget)tblclmnMin, (ColumnLayoutData)new ColumnPixelData(30, false, true));
        tblclmnMin.setText("Min");
        TableViewerColumn tvcIst = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport seesIst = new StockEntryEditingSupport(this.checkboxTableViewer, 1);
        tvcIst.setEditingSupport((EditingSupport)seesIst);
        tvcIst.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getCurrentStock());
                }
                return null;
            }
        });
        TableColumn tblclmnNewColumn = tvcIst.getColumn();
        tblclmnNewColumn.setResizable(true);
        tcl_composite.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnPixelData(30, false, true));
        tblclmnNewColumn.setText("Ist");
        TableViewerColumn tvcMax = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport seesMax = new StockEntryEditingSupport(this.checkboxTableViewer, 2);
        tvcMax.setEditingSupport((EditingSupport)seesMax);
        tvcMax.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getMaximumStock());
                }
                return null;
            }
        });
        TableColumn tblclmnMax = tvcMax.getColumn();
        tblclmnMax.setResizable(true);
        tcl_composite.setColumnData((Widget)tblclmnMax, (ColumnLayoutData)new ColumnPixelData(30, true, true));
        tblclmnMax.setText("Max");
        TableViewerColumn tvcFraction = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        StockEntryEditingSupport seesFrac = new StockEntryEditingSupport(this.checkboxTableViewer, 3);
        tvcFraction.setEditingSupport((EditingSupport)seesFrac);
        tvcFraction.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
                if (se != null) {
                    return Integer.toString(se.getFractionUnits());
                }
                return null;
            }
        });
        TableColumn tblclmnFraction = tvcFraction.getColumn();
        tblclmnFraction.setResizable(true);
        tcl_composite.setColumnData((Widget)tblclmnFraction, (ColumnLayoutData)new ColumnPixelData(30, false, true));
        tblclmnFraction.setText("Anbruch");
        TableViewerColumn tvcProvider = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 0);
        tvcProvider.setEditingSupport(new EditingSupport((ColumnViewer)this.checkboxTableViewer){

            protected void setValue(Object element, Object value) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return;
                }
                IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
                if (se == null) {
                    return;
                }
                se.setProvider((Object)((Kontakt)value));
                this.getViewer().refresh();
            }

            protected Object getValue(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
                if (se == null) {
                    return null;
                }
                return (Kontakt)se.getProvider();
            }

            protected CellEditor getCellEditor(Object element) {
                return new KontaktSelektorDialogCellEditor((Composite)((CheckboxTableViewer)this.getViewer()).getTable(), "Lieferant ausw\u00e4hlen", "Bitte selektieren Sie den Lieferant");
            }

            protected boolean canEdit(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return false;
                }
                return StockDetailComposite.this.stockEntries.get(stock) != null;
            }
        });
        tvcProvider.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return null;
                }
                IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
                if (se == null) {
                    return null;
                }
                Kontakt provider = (Kontakt)se.getProvider();
                if (provider == null) {
                    return null;
                }
                return provider.getLabel();
            }
        });
        TableColumn tblclmnProvider = tvcProvider.getColumn();
        tcl_composite.setColumnData((Widget)tblclmnProvider, (ColumnLayoutData)new ColumnPixelData(200, true, true));
        tblclmnProvider.setText("Lieferant");
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Stock stock = (Stock)event.getElement();
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock != null && art != null && stock.getDriverUuid().length() == 0) {
                    if (event.getChecked()) {
                        StockDetailComposite.this.stockService.storeArticleInStock((IStock)stock, art.storeToString());
                    } else {
                        StockDetailComposite.this.stockService.unstoreArticleFromStock((IStock)stock, art.storeToString());
                    }
                }
                StockDetailComposite.this.refreshData();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                Stock stock = (Stock)element;
                Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
                if (stock == null || art == null) {
                    return false;
                }
                return StockDetailComposite.this.stockEntries.get(stock) != null;
            }
        });
        List stocks = this.stockService.getAllStocks(true);
        for (Stock stock : stocks) {
            this.stockEntries.put(stock, null);
        }
        this.checkboxTableViewer.setInput((Object)stocks);
        TableViewer ret = new TableViewer(this.table);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(ret, new FocusCellHighlighter((ColumnViewer)ret){});
        ColumnViewerEditorActivationStrategy editorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)ret){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = (ViewerCell)event.getSource();
                return cell.getColumnIndex() > 0 && cell.getColumnIndex() < 5;
            }
        };
        TableViewerEditor.create((TableViewer)ret, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)16);
    }

    private void refreshData() {
        Artikel article = (Artikel)this.wvArtikel.getValue();
        boolean enabled = article != null && !article.isProduct();
        this.table.setEnabled(enabled);
        this.stockEntries.replaceAll((k, v) -> null);
        if (article != null) {
            this.stockEntries.keySet().forEach(k -> this.stockEntries.put((Stock)k, this.stockService.findStockEntryForArticleInStock((IStock)k, article.storeToString())));
        }
        this.checkboxTableViewer.refresh(true);
    }

    protected void checkSubclass() {
    }

    public void setArticle(Artikel article) {
        this.wvArtikel.setValue((Object)article);
        this.refreshData();
    }

    public class StockEntryEditingSupport
    extends EditingSupport {
        public static final int MIN = 0;
        public static final int CURR = 1;
        public static final int MAX = 2;
        public static final int FRAC = 3;
        private final int editorFor;
        private final CellEditor editor;

        public StockEntryEditingSupport(CheckboxTableViewer columnViewer, int editorFor) {
            super((ColumnViewer)columnViewer);
            this.editorFor = editorFor;
            this.editor = new TextCellEditor((Composite)columnViewer.getTable());
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            Stock stock = (Stock)element;
            Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
            if (stock == null || art == null || StockDetailComposite.this.stockEntries.get(stock) == null) {
                return false;
            }
            return 1 != this.editorFor && 3 != this.editorFor || stock.getDriverUuid().length() <= 0;
        }

        protected Object getValue(Object element) {
            Stock stock = (Stock)element;
            Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
            if (stock == null || art == null) {
                return "";
            }
            IStockEntry se = (IStockEntry)StockDetailComposite.this.stockEntries.get(stock);
            if (se == null) {
                return "";
            }
            int value = 0;
            switch (this.editorFor) {
                case 0: {
                    value = se.getMinimumStock();
                    break;
                }
                case 1: {
                    value = se.getCurrentStock();
                    break;
                }
                case 2: {
                    value = se.getMaximumStock();
                    break;
                }
                case 3: {
                    value = se.getFractionUnits();
                }
            }
            return Integer.toString(value);
        }

        protected void setValue(Object element, Object value) {
            Stock stock = (Stock)element;
            Artikel art = (Artikel)StockDetailComposite.this.wvArtikel.getValue();
            if (stock == null || art == null) {
                return;
            }
            StockEntry se = (StockEntry)StockDetailComposite.this.stockEntries.get(stock);
            if (se == null) {
                return;
            }
            LockResponse lr = CoreHub.getLocalLockService().acquireLock((IPersistentObject)se);
            if (!lr.isOk()) {
                return;
            }
            int val = 0;
            try {
                val = Integer.valueOf((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            switch (this.editorFor) {
                case 0: {
                    se.setMinimumStock(val);
                    break;
                }
                case 2: {
                    se.setMaximumStock(val);
                    break;
                }
                case 1: {
                    se.setCurrentStock(val);
                    break;
                }
                case 3: {
                    se.setFractionUnits(val);
                }
            }
            lr = CoreHub.getLocalLockService().releaseLock((IPersistentObject)se);
            if (!lr.isOk()) {
                StockDetailComposite.this.log.warn("Error releasing lock for [{}]: {}", (Object)se.getId(), (Object)lr.getStatus());
            }
            this.getViewer().refresh();
        }
    }
}

