/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views.codesystems;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.events.ElexisEventListenerImpl;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.commands.ExportiereBloeckeCommand;
import ch.elexis.core.ui.dialogs.BlockSelektor;
import ch.elexis.core.ui.dialogs.base.InputDialog;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.codesystems.BlockElementViewerItem;
import ch.elexis.core.ui.views.codesystems.BlockTreeViewerItem;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import ch.elexis.data.Leistungsblock;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.slf4j.LoggerFactory;

public class BlockSelector
extends CodeSelectorFactory {
    protected static final String BLOCK_ONLY_FILTER_ENABLED = "blockselector/blockonlyfilter";
    protected static final String BLOCK_FILTER_ONLY_MANDATOR = "blockselector/blockfilteronlymandator";
    private IAction deleteAction;
    private IAction createAction;
    private IAction exportAction;
    private IAction copyAction;
    private IAction searchBlocksOnly;
    private IAction searchFilterMandator;
    private CommonViewer cv;
    private MenuManager mgr;
    static SelectorPanelProvider slp;
    int eventType = 1;
    ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    ISelectionChangedListener selChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object firstElement;
            TreeViewer tv = (TreeViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            Leistungsblock selectedPo = null;
            Object object = firstElement = ss.isEmpty() ? null : ss.getFirstElement();
            if (firstElement instanceof BlockTreeViewerItem) {
                selectedPo = ((BlockTreeViewerItem)firstElement).getBlock();
            }
            BlockSelector.this.tvfa.updateSelection(selectedPo);
            ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)selectedPo));
        }
    };

    @Override
    public ViewerConfigurer createViewerConfigurer(final CommonViewer cv) {
        this.cv = cv;
        cv.setSelectionChangedListener(this.selChangeListener);
        this.makeActions();
        this.mgr = new MenuManager();
        this.mgr.setRemoveAllWhenShown(true);
        this.mgr.add((IContributionItem)new Separator("additions"));
        this.mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)BlockSelector.this.tvfa);
                manager.add(BlockSelector.this.deleteAction);
                manager.add(BlockSelector.this.copyAction);
                BlockSelector.this.addPopupCommandContributions(manager, cv.getSelection());
            }
        });
        cv.setContextMenu(this.mgr);
        FieldDescriptor[] lbName = new FieldDescriptor[]{new FieldDescriptor("Name")};
        Listener keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == BlockSelector.this.eventType && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    slp.fireChangedEvent();
                }
            }
        };
        FieldDescriptor[] fieldDescriptorArray = lbName;
        int n = lbName.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor lbn = fieldDescriptorArray[n2];
            lbn.setAssignedListener(this.eventType, keyListener);
            ++n2;
        }
        slp = new SelectorPanelProvider(lbName, true);
        slp.addActions(this.createAction, this.exportAction, this.searchBlocksOnly, this.searchFilterMandator);
        ViewerConfigurer vc = new ViewerConfigurer(new BlockContentProvider(this, cv), new BlockTreeViewerItem.ColorizedLabelProvider(), slp, new ViewerConfigurer.DefaultButtonProvider(), new SimpleWidgetProvider(0, 0, null));
        vc.addDragSourceSelectionRenderer(new PersistentObjectDragSource.ISelectionRenderer(){

            @Override
            public List<PersistentObject> getSelection() {
                IStructuredSelection selection = cv.getViewerWidget().getStructuredSelection();
                if (!selection.isEmpty()) {
                    ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>();
                    for (Object selected : selection.toList()) {
                        if (selected instanceof BlockTreeViewerItem) {
                            ret.add((PersistentObject)((BlockTreeViewerItem)selected).getBlock());
                            continue;
                        }
                        if (!(selected instanceof BlockElementViewerItem) || !(((BlockElementViewerItem)selected).getFirstElement() instanceof PersistentObject)) continue;
                        ret.add((PersistentObject)((BlockElementViewerItem)selected).getFirstElement());
                    }
                    return ret;
                }
                return Collections.emptyList();
            }
        });
        return vc;
    }

    @Override
    public Class<? extends PersistentObject> getElementClass() {
        return Leistungsblock.class;
    }

    @Override
    public void dispose() {
    }

    private void makeActions() {
        this.deleteAction = new Action("Block l\u00f6schen"){

            public void run() {
                BlockTreeViewerItem o = (BlockTreeViewerItem)BlockSelector.this.cv.getSelection()[0];
                if (o != null && o.getBlock() != null) {
                    o.getBlock().delete();
                    BlockSelector.this.cv.notify(CommonViewer.Message.update);
                }
            }
        };
        this.createAction = new Action("neu erstellen"){
            {
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setToolTipText("Neuen Block erstellen");
            }

            public void run() {
                String[] v = BlockSelector.this.cv.getConfigurer().getControlFieldProvider().getValues();
                if (v != null && v.length > 0 && v[0] != null && v[0].length() > 0) {
                    new Leistungsblock(v[0], ElexisEventDispatcher.getSelectedMandator());
                    BlockSelector.this.cv.notify(CommonViewer.Message.update_keeplabels);
                }
            }
        };
        this.exportAction = new Action("Bl\u00f6cke exportieren"){
            {
                this.setImageDescriptor(Images.IMG_EXPORT.getImageDescriptor());
                this.setToolTipText("Exportiert alle Bl\u00f6cke in eine XML-Datei");
            }

            public void run() {
                try {
                    new ExportiereBloeckeCommand().execute(null);
                }
                catch (ExecutionException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error exporting block", (Throwable)e);
                }
            }
        };
        this.copyAction = new Action("Block kopieren"){
            {
                this.setImageDescriptor(Images.IMG_COPY.getImageDescriptor());
                this.setToolTipText("Den Block umbenennen und kopieren");
            }

            public void run() {
                BlockTreeViewerItem o = (BlockTreeViewerItem)BlockSelector.this.cv.getSelection()[0];
                if (o != null && o.getBlock() != null) {
                    Leistungsblock sourceBlock = o.getBlock();
                    InputDialog inputDlg = new InputDialog(Display.getDefault().getActiveShell(), "Block kopieren", "Bitte den Namen der Kopie eingeben bzw. best\u00e4tigen", String.valueOf(sourceBlock.getName()) + " Kopie", new IInputValidator(){

                        public String isValid(String newText) {
                            return newText != null && !newText.isEmpty() ? null : "Fehler, kein Name.";
                        }
                    }, 2048);
                    if (inputDlg.open() == 0) {
                        String newName = inputDlg.getValue();
                        Leistungsblock newBlock = new Leistungsblock(newName, Mandant.load((String)sourceBlock.get("MandantID")));
                        sourceBlock.getElements().forEach(e -> newBlock.addElement(e));
                        BlockSelector.this.cv.notify(CommonViewer.Message.update);
                    }
                }
            }
        };
        this.searchBlocksOnly = new Action("Blockinhalt nicht durchsuchen", 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText("Blockinhalt nicht durchsuchen");
                this.setChecked(CoreHub.userCfg.get(BlockSelector.BLOCK_ONLY_FILTER_ENABLED, false));
            }

            public void run() {
                CoreHub.userCfg.set(BlockSelector.BLOCK_ONLY_FILTER_ENABLED, this.isChecked());
            }
        };
        this.searchFilterMandator = new Action("Nur Bl\u00f6cke des aktiven Mandanten", 2){
            {
                this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
                this.setToolTipText("Nur Bl\u00f6cke des aktiven Mandanten");
                this.setChecked(CoreHub.userCfg.get(BlockSelector.BLOCK_FILTER_ONLY_MANDATOR, false));
            }

            public void run() {
                CoreHub.userCfg.set(BlockSelector.BLOCK_FILTER_ONLY_MANDATOR, this.isChecked());
                if (BlockSelector.this.cv.getConfigurer().getContentProvider() instanceof BlockContentProvider) {
                    BlockContentProvider blockContentProvider = (BlockContentProvider)BlockSelector.this.cv.getConfigurer().getContentProvider();
                    blockContentProvider.refreshViewer();
                }
            }
        };
    }

    @Override
    public SelectionDialog getSelectionDialog(Shell parent, Object data) {
        return new BlockSelektor(parent, data);
    }

    @Override
    public String getCodeSystemName() {
        return "Block";
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.cv.getViewerWidget();
    }

    @Override
    public MenuManager getMenuManager() {
        return this.mgr;
    }

    public static class BlockContentProvider
    implements ViewerConfigurer.ICommonViewerContentProvider,
    ITreeContentProvider {
        private BlockSelector selector;
        private CommonViewer cv;
        private String queryFilter;
        private HashMap<Leistungsblock, BlockTreeViewerItem> blockItemMap;
        private final ElexisEventListenerImpl eeli_lb = new ElexisEventListenerImpl(Leistungsblock.class, 4){

            public void catchElexisEvent(final ElexisEvent ev) {
                if (blockItemMap != null && ev.getObject() instanceof Leistungsblock) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (cv != null && cv.getViewerWidget() != null && !cv.getViewerWidget().getControl().isDisposed()) {
                                BlockTreeViewerItem item = (BlockTreeViewerItem)blockItemMap.get(ev.getObject());
                                cv.getViewerWidget().refresh((Object)item, true);
                            }
                        }
                    });
                }
            }
        };

        BlockContentProvider(BlockSelector selector, CommonViewer cv) {
            this.cv = cv;
            this.selector = selector;
        }

        @Override
        public void startListening() {
            this.cv.getConfigurer().getControlFieldProvider().addChangeListener(this);
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_lb});
        }

        @Override
        public void stopListening() {
            this.cv.getConfigurer().getControlFieldProvider().removeChangeListener(this);
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_lb});
        }

        public Object[] getElements(Object inputElement) {
            Query qbe = new Query(Leistungsblock.class);
            qbe.add("id", "<>", "Version");
            if (this.queryFilter != null && this.queryFilter.length() > 2) {
                if (this.selector.searchBlocksOnly.isChecked()) {
                    qbe.add("Name", "LIKE", "%" + this.queryFilter + "%");
                } else {
                    qbe.startGroup();
                    qbe.add("Name", "LIKE", "%" + this.queryFilter + "%");
                    qbe.or();
                    qbe.add("codeelements", "LIKE", "%" + this.queryFilter + "%");
                    qbe.endGroup();
                }
            }
            qbe.orderBy(false, new String[]{"Name"});
            this.blockItemMap = new HashMap();
            List list = qbe.execute().stream().filter(b -> this.applyMandatorFilter((Leistungsblock)b)).map(b -> {
                BlockTreeViewerItem item = BlockTreeViewerItem.of(b);
                this.blockItemMap.put((Leistungsblock)b, item);
                return item;
            }).collect(Collectors.toList());
            return list.toArray();
        }

        private boolean applyMandatorFilter(Leistungsblock b) {
            if (this.selector.searchFilterMandator.isChecked()) {
                Mandant mandator = ElexisEventDispatcher.getSelectedMandator();
                String blockMandantId = b.get("MandantID");
                if (StringUtils.isNotBlank((CharSequence)blockMandantId) && mandator != null) {
                    return blockMandantId.equals(mandator.getId());
                }
            }
            return true;
        }

        public void dispose() {
            this.stopListening();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        @Override
        public void changed(HashMap<String, String> vals) {
            this.queryFilter = vals.get("Name");
            this.refreshViewer();
        }

        private void refreshViewer() {
            this.cv.getViewerWidget().getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StructuredViewer viewer = cv.getViewerWidget();
                    if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                        viewer.setSelection((ISelection)new StructuredSelection());
                        viewer.getControl().setRedraw(false);
                        viewer.refresh();
                        if (queryFilter != null && queryFilter.length() > 2) {
                            if (!selector.searchBlocksOnly.isChecked() && viewer instanceof TreeViewer) {
                                ((TreeViewer)viewer).expandAll();
                            }
                        } else {
                            ((TreeViewer)viewer).collapseAll();
                        }
                        viewer.getControl().setRedraw(true);
                    }
                }
            });
        }

        @Override
        public void reorder(String field) {
        }

        @Override
        public void selected() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof BlockTreeViewerItem) {
                BlockTreeViewerItem item = (BlockTreeViewerItem)element;
                return item.getChildren().toArray();
            }
            return Collections.emptyList().toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof BlockTreeViewerItem) {
                BlockTreeViewerItem item = (BlockTreeViewerItem)element;
                return item.hasChildren();
            }
            return false;
        }

        @Override
        public void init() {
        }
    }
}

