/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.KonsFilter;
import ch.elexis.core.ui.dialogs.KonsFilterDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.HistoryDisplay;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.part.ViewPart;

public class KonsListe
extends ViewPart
implements IRefreshable,
ISaveablePart2 {
    public static final String ID = "ch.elexis.HistoryView";
    HistoryDisplay liste;
    Patient actPatient;
    ViewMenus menus;
    private Action filterAction;
    private KonsFilter filter;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            if (ev.getType() == 16) {
                if (KonsListe.this.actPatient == null || !KonsListe.this.actPatient.getId().equals(((Patient)ev.getObject()).getId())) {
                    KonsListe.this.actPatient = (Patient)ev.getObject();
                    KonsListe.this.restart(ev);
                }
            } else if (ev.getType() == 32) {
                KonsListe.this.liste.stop();
                KonsListe.this.liste.load(null, true);
                KonsListe.this.liste.start(KonsListe.this.filter);
            }
        }
    };
    private ElexisEventListener eeli_fall = new ElexisUiEventListenerImpl(Fall.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            Fall fall = (Fall)ev.getObject();
            KonsListe.this.actPatient = fall != null ? ((Fall)ev.getObject()).getPatient() : null;
            KonsListe.this.restart(ev);
        }
    };
    private ElexisEventListener eeli_kons = new ElexisEventListener(){
        private final ElexisEvent eetempl = new ElexisEvent(null, Konsultation.class, 15);

        public ElexisEvent getElexisEventFilter() {
            return this.eetempl;
        }

        public void catchElexisEvent(ElexisEvent ev) {
            KonsListe.this.restart(ev);
        }
    };

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.liste = new HistoryDisplay(parent, this.getViewSite());
        this.liste.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.makeActions();
        this.menus = new ViewMenus(this.getViewSite());
        this.menus.createToolbar(new IAction[]{GlobalActions.neueKonsAction, this.filterAction});
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_pat, this.eeli_kons});
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_kons, this.eeli_pat});
        this.liste.stop();
        super.dispose();
    }

    public void setFocus() {
        this.liste.setFocus();
        this.refresh();
    }

    @Override
    public void refresh() {
        this.eeli_pat.catchElexisEvent(ElexisEvent.createPatientEvent());
    }

    private void restart(ElexisEvent ev) {
        this.liste.stop();
        this.liste.load(this.actPatient, ev);
        this.liste.start(this.filter);
    }

    private void makeActions() {
        this.filterAction = new Action(Messages.KonsListe_FilterListAction, 2){
            {
                this.setImageDescriptor(Images.IMG_FILTER.getImageDescriptor());
                this.setToolTipText(Messages.KonsListe_FilterListToolTip);
            }

            public void run() {
                if (!this.isChecked()) {
                    KonsListe.this.filter = null;
                } else {
                    KonsFilterDialog kfd = new KonsFilterDialog(KonsListe.this.actPatient, KonsListe.this.filter);
                    if (kfd.open() == 0) {
                        KonsListe.this.filter = kfd.getResult();
                    } else {
                        kfd = null;
                        this.setChecked(false);
                    }
                }
                KonsListe.this.restart(null);
            }
        };
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    @Deprecated
    public void reloadContents(Class clazz) {
        if (clazz.equals(Konsultation.class)) {
            this.restart(null);
        }
    }
}

