/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonContentProviderAdapter;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.DefaultContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.FallDetailView;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.IFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;

public class FallListeView
extends ViewPart
implements IActivationListener,
ISaveablePart2 {
    private static boolean noPatientHandled = true;
    public static final String ID = "ch.elexis.FallListeView";
    CommonViewer fallViewer;
    CommonViewer behandlViewer;
    private ViewerConfigurer fallCf;
    private ViewerConfigurer behandlCf;
    private FormToolkit tk;
    private Form form;
    private Patient actPatient;
    private Fall actFall;
    private Konsultation actBehandlung;
    private ElexisEventListener eeli_pat = new ElexisUiEventListenerImpl(Patient.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            FallListeView.this.actPatient = (Patient)ev.getObject();
            FallListeView.this.form.setText(FallListeView.this.actPatient.getPersonalia());
            FallListeView.this.fallViewer.getViewerWidget().refresh();
        }
    };
    private ElexisEventListener eeli_fall = new ElexisUiEventListenerImpl(Fall.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            Fall f = (Fall)ev.getObject();
            FallListeView.this.setFall(f, null);
        }
    };
    private IAction filterClosedAction = new Action("", 2){
        private ViewerFilter closedFilter;
        {
            this.setToolTipText(Messages.FaelleView_ShowOnlyOpenCase);
            this.setImageDescriptor(Images.IMG_DOCUMENT_WRITE.getImageDescriptor());
            this.closedFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof Fall) {
                        Fall fall = (Fall)element;
                        return fall.isOpen();
                    }
                    return false;
                }
            };
        }

        public void run() {
            if (!this.isChecked()) {
                FallListeView.this.fallViewer.getViewerWidget().removeFilter(this.closedFilter);
            } else {
                FallListeView.this.fallViewer.getViewerWidget().addFilter(this.closedFilter);
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        this.form.getBody().setLayout((Layout)new GridLayout());
        SashForm sash = new SashForm(this.form.getBody(), 512);
        this.form.setText(Messages.FallListeView_NoPatientSelected);
        sash.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ViewerConfigurer.ButtonProvider fallButton = new ViewerConfigurer.ButtonProvider(){

            @Override
            public Button createButton(Composite parent1) {
                Button ret = FallListeView.this.tk.createButton(parent1, Messages.FallListeView_NewCase, 8);
                ret.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String bez = FallListeView.this.fallCf.getControlFieldProvider().getValues()[0];
                        Fall fall = FallListeView.this.actPatient.neuerFall(bez, Messages.FallListeView_Illness, "KVG");
                        Konsultation b = fall.neueKonsultation();
                        b.setMandant(CoreHub.actMandant);
                        FallListeView.this.fallCf.getControlFieldProvider().clearValues();
                        (this).FallListeView.this.fallViewer.getViewerWidget().refresh();
                        (this).FallListeView.this.fallViewer.setSelection(fall, true);
                    }
                });
                return ret;
            }

            @Override
            public boolean isAlwaysEnabled() {
                return false;
            }
        };
        this.fallViewer = new CommonViewer();
        this.fallCf = new ViewerConfigurer(new DefaultContentProvider(this.fallViewer, Fall.class){

            @Override
            public Object[] getElements(Object inputElement) {
                if (FallListeView.this.actPatient != null) {
                    if (FallListeView.this.fallCf.getControlFieldProvider().isEmpty()) {
                        return FallListeView.this.actPatient.getFaelle();
                    }
                    IFilter filter = FallListeView.this.fallCf.getControlFieldProvider().createFilter();
                    List list = FallListeView.this.actPatient.getList(Messages.FallListeView_Cases, true);
                    ArrayList<Fall> arr = new ArrayList<Fall>();
                    for (String s : list) {
                        Fall f = Fall.load((String)s);
                        if (!filter.select((Object)f)) continue;
                        arr.add(f);
                    }
                    return arr.toArray();
                }
                return new Object[0];
            }
        }, new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof Fall) {
                    if (((Fall)element).isOpen()) {
                        if (((Fall)element).isValid()) {
                            return Images.IMG_OK.getImage();
                        }
                        return Images.IMG_FEHLER.getImage();
                    }
                    return Images.IMG_LOCK_CLOSED.getImage();
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                return ((Fall)element).getLabel();
            }
        }, new DefaultControlFieldProvider(this.fallViewer, new String[]{Messages.FallListeView_Label}), fallButton, new SimpleWidgetProvider(2, 4, this.fallViewer));
        this.fallViewer.create(this.fallCf, (Composite)sash, 0, this.getViewSite());
        this.fallViewer.getViewerWidget().addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        this.behandlViewer = new CommonViewer();
        ViewerConfigurer.ButtonProvider behandlButton = new ViewerConfigurer.ButtonProvider(){

            @Override
            public Button createButton(Composite parent1) {
                Button ret = FallListeView.this.tk.createButton(parent1, Messages.FallListeView_NewKons, 8);
                ret.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Konsultation b = FallListeView.this.actFall.neueKonsultation();
                        if (b != null) {
                            b.setMandant(CoreHub.actMandant);
                            FallListeView.this.behandlCf.getControlFieldProvider().clearValues();
                            (this).FallListeView.this.behandlViewer.getViewerWidget().refresh();
                            FallListeView.this.setFall(FallListeView.this.actFall, b);
                        }
                    }
                });
                return ret;
            }

            @Override
            public boolean isAlwaysEnabled() {
                return true;
            }
        };
        this.behandlCf = new ViewerConfigurer(new CommonContentProviderAdapter(){

            @Override
            public Object[] getElements(Object inputElement) {
                if (FallListeView.this.actFall != null) {
                    Konsultation[] alle = FallListeView.this.actFall.getBehandlungen(true);
                    return FallListeView.this.actFall.getBehandlungen(true);
                }
                return new Object[0];
            }
        }, new DefaultLabelProvider(), new DefaultControlFieldProvider(this.behandlViewer, new String[]{Messages.FallListeView_Date}), behandlButton, new SimpleWidgetProvider(1, 516, this.behandlViewer));
        Composite cf = new Composite((Composite)sash, 2048);
        cf.setLayout((Layout)new GridLayout());
        this.behandlViewer.create(this.behandlCf, cf, 0, this.getViewSite());
        this.behandlViewer.getViewerWidget().addSelectionChangedListener((ISelectionChangedListener)GlobalEventDispatcher.getInstance().getDefaultListener());
        this.tk.adapt((Control)sash, false, false);
        GlobalEventDispatcher.addActivationListener(this, (IWorkbenchPart)this);
        sash.setWeights(new int[]{50, 50});
        this.createMenuAndToolbar();
        this.createContextMenu();
        ((DefaultContentProvider)this.fallCf.getContentProvider()).startListening();
        this.fallViewer.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                try {
                    FallDetailView fallDetailView = (FallDetailView)FallListeView.this.getSite().getPage().showView("ch.elexis.FallDetailView");
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        });
        this.behandlViewer.addDoubleClickListener(new CommonViewer.DoubleClickListener(){

            @Override
            public void doubleClicked(PersistentObject obj, CommonViewer cv) {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ch.elexis.Konsdetail");
                }
                catch (PartInitException e) {
                    ExHandler.handle((Throwable)e);
                }
            }
        });
    }

    private void createContextMenu() {
        MenuManager fallMenuMgr = new MenuManager();
        fallMenuMgr.setRemoveAllWhenShown(true);
        fallMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(GlobalActions.openFallaction);
                manager.add((IAction)GlobalActions.reopenFallAction);
                manager.add((IContributionItem)new GroupMarker("additions"));
                manager.add((IAction)GlobalActions.delFallAction);
                manager.add((IContributionItem)new Separator());
                manager.add(GlobalActions.makeBillAction);
            }
        });
        Menu fallMenu = fallMenuMgr.createContextMenu(this.fallViewer.getViewerWidget().getControl());
        this.fallViewer.getViewerWidget().getControl().setMenu(fallMenu);
        this.getSite().registerContextMenu("ch.elexis.FallListeMenu", fallMenuMgr, (ISelectionProvider)this.fallViewer.getViewerWidget());
        MenuManager behdlMenuMgr = new MenuManager();
        behdlMenuMgr.setRemoveAllWhenShown(true);
        behdlMenuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new GroupMarker("additions"));
                manager.add((IAction)GlobalActions.delKonsAction);
                manager.add(GlobalActions.moveBehandlungAction);
                manager.add(GlobalActions.redateAction);
            }
        });
        Menu behdlMenu = behdlMenuMgr.createContextMenu(this.behandlViewer.getViewerWidget().getControl());
        this.behandlViewer.getViewerWidget().getControl().setMenu(behdlMenu);
        this.getSite().registerContextMenu("ch.elexis.BehandlungsListeMenu", behdlMenuMgr, (ISelectionProvider)this.behandlViewer.getViewerWidget());
    }

    private void createMenuAndToolbar() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        mgr.add((IAction)GlobalActions.delFallAction);
        mgr.add((IAction)GlobalActions.delKonsAction);
        mgr.add((IContributionItem)new Separator());
        IToolBarManager tmg = this.getViewSite().getActionBars().getToolBarManager();
        tmg.add(GlobalActions.helpAction);
        tmg.add(this.filterClosedAction);
    }

    public void setFocus() {
    }

    public void setFall(Fall f, Konsultation b) {
        this.actFall = f;
        if (f != null) {
            this.actPatient = f.getPatient();
            this.form.setText(this.actPatient.getLabel());
            this.fallViewer.notify(CommonViewer.Message.update);
            this.fallViewer.setSelection(f, false);
            if (b == null) {
                b = f.getLetzteBehandlung();
            }
            if (b != null) {
                this.behandlViewer.setSelection(b, false);
            }
            this.actBehandlung = b;
            GlobalActions.reopenFallAction.setEnabled(!f.isOpen());
            this.behandlViewer.getViewerWidget().refresh(true);
            this.fallViewer.getViewerWidget().refresh(true);
            noPatientHandled = false;
        } else if (!noPatientHandled) {
            ElexisEventDispatcher.clearSelection(Konsultation.class);
            ElexisEventDispatcher.clearSelection(Fall.class);
            if (this.actPatient == null) {
                this.form.setText(Messages.FallListeView_NoPatientSelected);
            } else {
                this.form.setText(this.actPatient.getLabel());
            }
            this.fallViewer.notify(CommonViewer.Message.update);
            GlobalActions.reopenFallAction.setEnabled(false);
            this.behandlViewer.getViewerWidget().refresh(true);
            noPatientHandled = true;
        }
    }

    public void selectionEvent(PersistentObject obj) {
        if (!(obj instanceof Patient)) {
            boolean cfr_ignored_0 = obj instanceof Fall;
        }
    }

    public void dispose() {
        ((DefaultContentProvider)this.fallCf.getContentProvider()).stopListening();
        GlobalEventDispatcher.removeActivationListener(this, (IWorkbenchPart)this);
        super.dispose();
    }

    @Override
    public void activation(boolean mode) {
    }

    @Override
    public void visible(boolean mode) {
        if (mode) {
            ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_pat});
            this.actPatient = (Patient)ElexisEventDispatcher.getSelected(Patient.class);
            this.actFall = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
            if (this.actPatient != null) {
                if (this.actFall == null) {
                    this.actBehandlung = this.actPatient.getLetzteKons(false);
                    this.actFall = this.actBehandlung == null ? null : this.actBehandlung.getFall();
                } else if (this.actFall.getPatient().getId().equals(this.actPatient.getId())) {
                    if (!(this.actBehandlung == null || this.actBehandlung.getFall() != null && this.actBehandlung.getFall().getId().equals(this.actFall.getId()))) {
                        this.actBehandlung = this.actPatient.getLetzteKons(false);
                    }
                } else {
                    this.actBehandlung = this.actPatient.getLetzteKons(false);
                    this.actFall = this.actBehandlung == null ? null : this.actBehandlung.getFall();
                }
            } else {
                this.actFall = null;
                this.actBehandlung = null;
            }
            this.setFall(this.actFall, this.actBehandlung);
        } else {
            ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_pat});
        }
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }
}

