/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.data.interfaces.IFall;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.FallDetailBlatt2;
import ch.elexis.data.Anwender;
import ch.elexis.data.Fall;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;

public class FallDetailView
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "ch.elexis.FallDetailView";
    FallDetailBlatt2 fdb;
    private final ElexisEventListener eeli_user = new ElexisUiEventListenerImpl(Anwender.class, 64){

        @Override
        public void runInUi(ElexisEvent ev) {
            FallDetailView.this.fdb.reloadBillingSystemsMenu();
        }
    };
    private final ElexisEventListener eeli_fall = new ElexisUiEventListenerImpl(Fall.class){

        @Override
        public void runInUi(ElexisEvent ev) {
            Fall fall = (Fall)ev.getObject();
            Fall deselectedFall = null;
            switch (ev.getType()) {
                case 16: {
                    deselectedFall = FallDetailView.this.fdb.getFall();
                    FallDetailView.this.fdb.setFall((IFall)fall);
                    if (deselectedFall == null) break;
                    FallDetailView.this.releaseAndRefreshLock((IPersistentObject)deselectedFall, "ch.elexis.core.ui.command.ToggleCurrentCaseLockCommand");
                    break;
                }
                case 32: {
                    deselectedFall = FallDetailView.this.fdb.getFall();
                    FallDetailView.this.fdb.setFall(null);
                    if (deselectedFall == null) break;
                    FallDetailView.this.releaseAndRefreshLock((IPersistentObject)deselectedFall, "ch.elexis.core.ui.command.ToggleCurrentCaseLockCommand");
                    break;
                }
                case 4096: 
                case 16384: {
                    if (!fall.equals((Object)FallDetailView.this.fdb.getFall())) break;
                    FallDetailView.this.fdb.setUnlocked(ev.getType() == 4096);
                    break;
                }
            }
        }
    };

    private void releaseAndRefreshLock(IPersistentObject object, String commandId) {
        if (object != null && CoreHub.getLocalLockService().isLockedLocal(object)) {
            CoreHub.getLocalLockService().releaseLock(object);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(commandId, null);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.fdb = new FallDetailBlatt2(parent);
        this.fdb.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        this.fdb.setUnlocked(true);
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_user});
    }

    public void setFocus() {
        Fall f = (Fall)ElexisEventDispatcher.getSelected(Fall.class);
        this.fdb.setFall((IFall)f);
    }

    public void dispose() {
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_fall, this.eeli_user});
        super.dispose();
    }

    public int promptToSaveOnClose() {
        return GlobalActions.fixLayoutAction.isChecked() ? 2 : 1;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public Fall getActiveFall() {
        return this.fdb.getFall();
    }
}

