/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.lock.ILocalLockService;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.locks.LockResponseHelper;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireLockBlockingUi {
    private static Logger logger = LoggerFactory.getLogger(AcquireLockBlockingUi.class);

    public static void aquireAndRun(final IPersistentObject lockPo, final ILockHandler handler) {
        if (CoreHub.getLocalLockService().getStatus() == ILocalLockService.Status.STANDALONE) {
            handler.lockAcquired();
            return;
        }
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ProgressMonitorDialog progress = new ProgressMonitorDialog(display.getActiveShell());
                try {
                    progress.run(true, true, (IRunnableWithProgress)new AcquireLockRunnable(lockPo, handler));
                }
                catch (InterruptedException | InvocationTargetException e) {
                    logger.warn("Exception during acquire lock.", (Throwable)e);
                }
            }
        });
    }

    private static class AcquireLockRunnable
    implements IRunnableWithProgress {
        private IPersistentObject lockPo;
        private ILockHandler lockhander;

        public AcquireLockRunnable(IPersistentObject lockPo, ILockHandler lockhander) {
            this.lockPo = lockPo;
            this.lockhander = lockhander;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            final LockResponse result = CoreHub.getLocalLockService().acquireLockBlocking(this.lockPo, 30, monitor);
            Display display = Display.getDefault();
            if (result.isOk()) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        lockhander.lockAcquired();
                    }
                });
                monitor.beginTask("Releasing lock ...", -1);
                CoreHub.getLocalLockService().releaseLock(this.lockPo);
                monitor.done();
            } else {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        lockhander.lockFailed();
                        LockResponseHelper.showInfo(result, lockPo, logger);
                    }
                });
            }
        }
    }
}

