/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.model.IDiagnose;
import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.InsuranceElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.Konsultation;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import org.jdom.Element;

public class EpisodeElement
extends XChangeElement {
    public static final String XMLNAME = "episode";
    public static final String ATTR_BEGINDATE = "beginDate";
    public static final String ATTR_ENDDATE = "endDate";
    public static final String ATTR_TITLE = "name";
    public static final String ELEMENT_DIAGNOSIS = "diagnosis";
    public static final String ATTR_CODESYSTEM = "codesystem";
    public static final String ATTR_CODE = "code";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public EpisodeElement asExporter(XChangeExporter parent, Konsultation k, IDiagnose dg) {
        this.asExporter(parent);
        this.setAttribute(ATTR_BEGINDATE, new TimeTool(k.getDatum()).toString(6));
        this.setAttribute("id", XMLTool.idToXMLID((String)StringTool.unique((String)XMLNAME)));
        DiagnosisElement eDiag = new DiagnosisElement().asExporter(parent, dg);
        this.add(eDiag);
        this.setAttribute(ATTR_TITLE, dg.getLabel());
        InsuranceElement eInsurance = new InsuranceElement().asExporter(parent, k);
        this.add(eInsurance);
        return this;
    }

    public String getBeginDate() {
        return this.getAttr(ATTR_BEGINDATE);
    }

    public String getEndDate() {
        return this.getAttr(ATTR_ENDDATE);
    }

    public String getTitle() {
        return this.getAttr(ATTR_TITLE);
    }

    public String getText() {
        Element text = this.getElement().getChild("text", this.getContainer().getNamespace());
        if (text != null) {
            return text.getText();
        }
        return "";
    }

    public String getDiagnosis() {
        DiagnosisElement dia = (DiagnosisElement)this.getChild(ELEMENT_DIAGNOSIS, DiagnosisElement.class);
        if (dia != null) {
            DiagnosisElement de = new DiagnosisElement();
            String ret = String.valueOf(de.getCode()) + " (" + de.getCodeSystem() + ")";
            return ret;
        }
        return "";
    }

    static class DiagnosisElement
    extends XChangeElement {
        DiagnosisElement() {
        }

        @Override
        public String getXMLName() {
            return EpisodeElement.ELEMENT_DIAGNOSIS;
        }

        public DiagnosisElement asExporter(XChangeExporter parent, IDiagnose dg) {
            this.asExporter(parent);
            this.setAttribute(EpisodeElement.ATTR_CODESYSTEM, dg.getCodeSystemName());
            this.setAttribute(EpisodeElement.ATTR_CODE, dg.getCode());
            return this;
        }

        public String getCodeSystem() {
            return this.getAttr(EpisodeElement.ATTR_CODESYSTEM);
        }

        public String getCode() {
            return this.getAttr(EpisodeElement.ATTR_CODE);
        }
    }
}

