/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class KontaktExtDialog
extends TitleAreaDialog {
    private Kontakt k;
    private String[] f;

    public KontaktExtDialog(Shell shell, Kontakt k, String[] defvalues) {
        super(shell);
        this.k = k;
        this.f = defvalues;
        Arrays.sort(this.f, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        ExtInfoTable ret = new ExtInfoTable(parent, this.f);
        ret.setLayoutData(SWTHelper.getFillGridData(1, true, 1, true));
        ret.setKontakt(this.k);
        ret.pack();
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(this.k.getLabel());
        this.setMessage(Messages.KontaktExtDialog_pleaseENterDetails);
        this.getShell().setText(Messages.KontaktExtDialog_indetityDetails);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public static class ExtInfoTable
    extends Composite {
        Kontakt actKontakt;
        TableCursor cursor;
        ControlEditor editor;
        String[] fields;
        Table table;
        private HashMap<String, String> xids = new HashMap();

        public ExtInfoTable(Composite parent, String[] f) {
            super(parent, 0);
            this.setLayout((Layout)new FillLayout());
            this.fields = new String[f.length];
            int i = 0;
            while (i < f.length) {
                String[] val = f[i].split("=");
                this.fields[i] = val[0];
                if (val.length == 2) {
                    this.xids.put(val[0], val[1]);
                }
                ++i;
            }
            this.table = new Table((Composite)this, 66308);
            this.cursor = new TableCursor(this.table, 0);
            this.editor = new ControlEditor((Composite)this.cursor);
            this.editor.grabHorizontal = true;
            this.editor.grabVertical = true;
            this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    table.setSelection(new TableItem[]{cursor.getRow()});
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    TableItem row = cursor.getRow();
                    int column = cursor.getColumn();
                    this.doEdit(row.getText(column));
                }
            });
            this.cursor.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character > '0') {
                        StringBuilder sb = new StringBuilder();
                        sb.append(e.character);
                        this.doEdit(sb.toString());
                    }
                }
            });
            this.table.setLinesVisible(true);
            TableColumn parms = new TableColumn(this.table, 0);
            TableColumn vals = new TableColumn(this.table, 0);
            parms.setText(Messages.KontaktExtDialog_parameter);
            vals.setText(Messages.KontaktExtDialog_value);
            parms.setWidth(150);
            vals.setWidth(150);
            this.table.setHeaderVisible(true);
            int i2 = 0;
            while (i2 < this.fields.length) {
                new TableItem(this.table, 0);
                ++i2;
            }
        }

        public void setKontakt(Kontakt k) {
            int i = 0;
            while (i < this.fields.length) {
                TableItem it = this.table.getItem(i);
                it.setText(0, this.fields[i]);
                String val = "";
                String xid = this.xids.get(this.fields[i]);
                if (xid != null) {
                    val = k.getXid(xid);
                }
                if (val.length() == 0) {
                    val = (String)k.getInfoElement(this.fields[i]);
                }
                it.setText(1, val == null ? "" : val);
                ++i;
            }
            this.actKontakt = k;
        }

        private void doEdit(String inp) {
            final Text text = new Text((Composite)this.cursor, 2048);
            text.setText(inp);
            text.setSelection(inp.length());
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r' || e.keyCode == 0x1000002) {
                        TableItem it = cursor.getRow();
                        int idx = cursor.getColumn();
                        it.setText(idx, text.getText());
                        actKontakt.setInfoElement(it.getText(0), (Object)it.getText(1));
                        String xid = (String)xids.get(it.getText(0));
                        if (xid != null) {
                            actKontakt.addXid(xid, it.getText(1), true);
                        }
                        text.dispose();
                    }
                    if (e.character == '\u001b') {
                        text.dispose();
                    }
                }
            });
            this.editor.setEditor((Control)text);
            text.setFocus();
        }
    }
}

