/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.data.Brief;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.data.Sticker;
import ch.rgw.tools.StringTool;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DocumentSelectDialog
extends TitleAreaDialog {
    private static final String DELETE_DOCUMENT = Messages.DocumentSelectDialog_deleteDocument;
    private static final String DELETE_TEMPLATE = Messages.DocumentSelectDialog_deleteTemplate;
    private static final String OPEN_DOCUMENT = Messages.DocumentSelectDialog_openDocument;
    public static final int TYPE_LOAD_DOCUMENT = 0;
    public static final int TYPE_CREATE_DOC_WITH_TEMPLATE = 1;
    public static final int TYPE_LOAD_TEMPLATE = 2;
    public static final int TYPE_LOAD_SYSTEMPLATE = 4;
    protected static String DONTASKFORADDRESSEE_STICKER = "brief_dontaskforaddressee-*-&";
    protected static boolean dontAskForAddresseeStickerCreated = false;
    static final int TEMPLATE = 6;
    Person rel;
    int type;
    Brief result;
    Text tBetreff;
    String betreff;
    TableViewer tv;
    private MenuManager menu;
    private Action editNameAction;
    private Action editDontAskForAddressee;
    private Action deleteTemplateAction;
    private Action deleteTextAction;

    public DocumentSelectDialog(Shell shell, Person p, int typ) {
        super(shell);
        this.rel = p;
        this.type = typ;
    }

    public void create() {
        super.create();
        this.setTitleImage(Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize));
        this.makeActions();
        switch (this.type) {
            case 0: {
                this.setTitle(OPEN_DOCUMENT);
                this.setMessage(Messages.DocumentSelectDialog_pleaseSelectDocument);
                this.getShell().setText(OPEN_DOCUMENT);
                break;
            }
            case 1: {
                this.setTitle(Messages.DocumentSelectDialog_createLetterWithTemplate);
                this.setMessage(Messages.DocumentSelectDialog_selectTemplate);
                this.getShell().setText(Messages.DocumentSelectDialog_schooseTemplateForLetter);
                break;
            }
            case 2: {
                this.setTitle(Messages.DocumentSelectDialog_openTemplate);
                this.setMessage(Messages.DocumentSelectDialog_pleaseSelectTemplateFromList);
                this.getShell().setText(Messages.DocumentSelectDialog_openTemplate);
                break;
            }
            case 4: {
                this.setTitle(Messages.DocumentSelectDialog_loadSysTemplate);
                this.setMessage(Messages.DocumentSelectDialog_sysTemplateExplanation);
                this.getShell().setText(Messages.DocumentSelectDialog_loadTemplate);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout());
        if ((this.type & 6) != 0) {
            new Label(ret, 0).setText(Messages.DocumentSelectDialog_subject);
            this.tBetreff = SWTHelper.createText(ret, 1, 0);
            new Label(ret, 258);
        }
        this.tv = new TableViewer(ret, 512);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Query qbe = new Query(Brief.class);
                if (DocumentSelectDialog.this.type == 0) {
                    qbe.add("Typ", "<>", "Vorlagen");
                } else {
                    String sys = DocumentSelectDialog.this.type == 4 ? "=" : "<>";
                    qbe.add("Typ", "=", "Vorlagen");
                    qbe.add("BehandlungsID", sys, "SYS");
                    qbe.startGroup();
                    qbe.add("DestID", "=", CoreHub.actMandant.getId());
                    qbe.or();
                    qbe.add("DestID", "=", "");
                    qbe.endGroup();
                }
                qbe.and();
                qbe.add("deleted", "<>", "1");
                if (DocumentSelectDialog.this.type != 0) {
                    qbe.orderBy(false, new String[]{"Betreff"});
                } else {
                    qbe.orderBy(false, new String[]{"Datum"});
                }
                List l = qbe.execute();
                return l.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.makeActions();
        this.menu = new MenuManager();
        this.menu.setRemoveAllWhenShown(true);
        this.menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DocumentSelectDialog.this.menu.add((IAction)DocumentSelectDialog.this.editNameAction);
                if (DocumentSelectDialog.this.type == 2) {
                    Brief sel = (Brief)((IStructuredSelection)DocumentSelectDialog.this.tv.getSelection()).getFirstElement();
                    if (DocumentSelectDialog.getDontAskForAddresseeForThisTemplate(sel)) {
                        DocumentSelectDialog.this.menu.add((IAction)DocumentSelectDialog.this.editDontAskForAddressee);
                        DocumentSelectDialog.this.editDontAskForAddressee.setChecked(false);
                    } else {
                        DocumentSelectDialog.this.menu.add((IAction)DocumentSelectDialog.this.editDontAskForAddressee);
                        DocumentSelectDialog.this.editDontAskForAddressee.setChecked(true);
                    }
                }
                DocumentSelectDialog.this.menu.add((IAction)((DocumentSelectDialog.this.type & 6) != 0 ? DocumentSelectDialog.this.deleteTemplateAction : DocumentSelectDialog.this.deleteTextAction));
            }
        });
        this.tv.getControl().setMenu(this.menu.createContextMenu(this.tv.getControl()));
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.tv.setInput((Object)this);
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                DocumentSelectDialog.this.okPressed();
            }
        });
        return ret;
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel != null && !sel.isEmpty()) {
            this.result = (Brief)sel.getFirstElement();
            if ((this.type & 6) != 0) {
                this.betreff = this.tBetreff.getText();
            }
            if (StringTool.isNothing((Object)this.betreff)) {
                this.betreff = this.result.getBetreff();
            }
        }
        super.okPressed();
    }

    public Brief getSelectedDocument() {
        return this.result;
    }

    public String getBetreff() {
        return this.betreff;
    }

    private void makeActions() {
        this.deleteTemplateAction = new Action(DELETE_TEMPLATE){

            public void run() {
                Brief sel = (Brief)((IStructuredSelection)DocumentSelectDialog.this.tv.getSelection()).getFirstElement();
                if (MessageDialog.openConfirm((Shell)DocumentSelectDialog.this.getShell(), (String)DELETE_TEMPLATE, (String)MessageFormat.format(Messages.DocumentSelectDialog_reallyDeleteTemplate, sel.getBetreff()))) {
                    sel.delete();
                    DocumentSelectDialog.this.tv.refresh();
                }
            }
        };
        this.deleteTextAction = new Action(DELETE_DOCUMENT){

            public void run() {
                Brief sel = (Brief)((IStructuredSelection)DocumentSelectDialog.this.tv.getSelection()).getFirstElement();
                if (MessageDialog.openConfirm((Shell)DocumentSelectDialog.this.getShell(), (String)DELETE_DOCUMENT, (String)MessageFormat.format(Messages.DocumentSelectDialog_reallyDeleteDocument, sel.getBetreff()))) {
                    sel.set("geloescht", "1");
                    DocumentSelectDialog.this.tv.refresh();
                }
            }
        };
        this.editNameAction = new Action(Messages.DocumentSelectDialog_changeSubjectAction){

            public void run() {
                Brief sel = (Brief)((IStructuredSelection)DocumentSelectDialog.this.tv.getSelection()).getFirstElement();
                InputDialog inp = new InputDialog(DocumentSelectDialog.this.getShell(), Messages.DocumentSelectDialog_changeSubjectAction, Messages.DocumentSelectDialog_changeSubjectAction, sel.getBetreff(), null);
                int inputResult = inp.open();
                if (inputResult == 0) {
                    sel.setBetreff(inp.getValue());
                    DocumentSelectDialog.this.tv.refresh();
                }
            }
        };
        this.editDontAskForAddressee = new Action(Messages.DocumentSelectDialog_askForAddressee){

            public void run() {
                Brief sel;
                DocumentSelectDialog.setDontAskForAddresseeForThisTemplate(sel, !DocumentSelectDialog.getDontAskForAddresseeForThisTemplate(sel = (Brief)((IStructuredSelection)DocumentSelectDialog.this.tv.getSelection()).getFirstElement()));
                DocumentSelectDialog.this.tv.refresh();
            }
        };
    }

    public static String getDontAskForAddresseeStickerID() {
        Query qry = new Query(Sticker.class);
        qry.add("Name", "=", DONTASKFORADDRESSEE_STICKER);
        List stickerList = qry.execute();
        if (stickerList.size() > 0) {
            return ((Sticker)stickerList.get(0)).getId();
        }
        return "";
    }

    public static Sticker getDontAskForAddresseeSticker() {
        Query qry = new Query(Sticker.class);
        qry.add("Name", "=", DONTASKFORADDRESSEE_STICKER);
        List stickerList = qry.execute();
        if (stickerList.size() > 0) {
            return (Sticker)stickerList.get(0);
        }
        return null;
    }

    public static void createDontAskForAddresseeSticker() {
        if (!dontAskForAddresseeStickerCreated) {
            if (DocumentSelectDialog.getDontAskForAddresseeSticker() == null) {
                Sticker newSticker = new Sticker(DONTASKFORADDRESSEE_STICKER, null, null);
                newSticker.setClassForSticker(Brief.class);
                newSticker.setVisible(false);
            }
            dontAskForAddresseeStickerCreated = true;
        }
    }

    public static boolean getDontAskForAddresseeForThisTemplateName(String templateName) {
        Query qry = new Query(Brief.class);
        qry.add("Betreff", "=", templateName, true);
        qry.add("Typ", "=", "Vorlagen", true);
        List result = qry.execute();
        if (result.size() > 0) {
            Brief brief = (Brief)result.get(0);
            return DocumentSelectDialog.getDontAskForAddresseeForThisTemplate(brief);
        }
        return false;
    }

    public static boolean getDontAskForAddresseeForThisTemplate(Brief template) {
        DocumentSelectDialog.createDontAskForAddresseeSticker();
        List stickers = template.getStickers();
        for (ISticker st : stickers) {
            if (!st.getLabel().equalsIgnoreCase(DONTASKFORADDRESSEE_STICKER)) continue;
            return true;
        }
        return false;
    }

    public static void setDontAskForAddresseeForThisTemplate(Brief template, boolean dontAskForAddressee) {
        DocumentSelectDialog.createDontAskForAddresseeSticker();
        if (dontAskForAddressee) {
            Sticker st = DocumentSelectDialog.getDontAskForAddresseeSticker();
            template.addSticker((ISticker)st);
        } else {
            Sticker st = DocumentSelectDialog.getDontAskForAddresseeSticker();
            template.removeSticker((ISticker)st);
        }
    }

    public class MyLabelProvider
    extends DefaultLabelProvider
    implements ITableLabelProvider {
        @Override
        public Image getColumnImage(Object element, int columnIndex) {
            PersistentObject po = (PersistentObject)element;
            if (DocumentSelectDialog.this.type == 2 && !DocumentSelectDialog.getDontAskForAddresseeForThisTemplate((Brief)po)) {
                return Images.IMG_ADRESSETIKETTE.getImage();
            }
            return null;
        }
    }
}

