/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.views.controls.DaysOrDateSelectionComposite;
import ch.elexis.core.ui.views.controls.GenericSelectionComposite;
import ch.elexis.core.ui.views.controls.KontaktSelectionComposite;
import ch.elexis.core.ui.views.controls.TimeSpanSelectionComposite;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class BillingProposalWizardDialog
extends TitleAreaDialog {
    private List<Konsultation> proposal;
    private Button insurerOnly;
    private KontaktSelectionComposite insurerSelection;
    private Button timeSpanOnly;
    private TimeSpanSelectionComposite timeSpanSelection;
    private Button beforeTimeOnly;
    private DaysOrDateSelectionComposite beforeDaysOrDate;
    private Button mandatorOnly;
    private GenericSelectionComposite mandatorSelector;
    private Button accountingOnly;
    private GenericSelectionComposite accountingSelector;
    private Button errorneousOnly;

    public BillingProposalWizardDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Rechnungs-Vorschlag Auswahl");
        this.setMessage(Messages.KonsZumVerrechnenWizardDialog_createProposal);
        this.getShell().setText("Rechnungs-Vorschlag");
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(ret, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(1808));
        this.timeSpanOnly = new Button(content, 32);
        this.timeSpanOnly.setText("Offene Konsultationen innerhalb des Zeitraums");
        this.timeSpanSelection = new TimeSpanSelectionComposite(content, 0);
        this.timeSpanSelection.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.timeSpanSelection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.timeSpanOnly.setSelection(true);
                    BillingProposalWizardDialog.this.beforeTimeOnly.setSelection(false);
                } else {
                    BillingProposalWizardDialog.this.timeSpanOnly.setSelection(false);
                }
            }
        });
        LocalDate dateNow = LocalDate.now();
        this.timeSpanSelection.setTimeSpan(new TimeSpan(new TimeTool(dateNow.withDayOfMonth(1)), new TimeTool(dateNow)));
        this.beforeTimeOnly = new Button(content, 32);
        this.beforeTimeOnly.setText("Offene Behandlungsserien vor Tagen oder Datum");
        this.beforeDaysOrDate = new DaysOrDateSelectionComposite(content, 0);
        this.beforeDaysOrDate.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.beforeDaysOrDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.beforeTimeOnly.setSelection(true);
                    BillingProposalWizardDialog.this.timeSpanOnly.setSelection(false);
                } else {
                    BillingProposalWizardDialog.this.beforeTimeOnly.setSelection(false);
                }
            }
        });
        this.beforeDaysOrDate.setDate(LocalDate.now().minusDays(30L));
        this.insurerOnly = new Button(content, 32);
        this.insurerOnly.setText("nur von folgendem Versicherer");
        this.insurerSelection = new KontaktSelectionComposite(content, 2);
        this.insurerSelection.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.insurerSelection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.insurerOnly.setSelection(true);
                } else {
                    BillingProposalWizardDialog.this.insurerOnly.setSelection(false);
                }
            }
        });
        this.mandatorOnly = new Button(content, 32);
        this.mandatorOnly.setText("nur von folgenden Mandanten");
        this.mandatorSelector = new GenericSelectionComposite(content, 0);
        this.mandatorSelector.setInput(new Query(Mandant.class).execute());
        this.mandatorSelector.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.mandatorSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.mandatorOnly.setSelection(true);
                } else {
                    BillingProposalWizardDialog.this.mandatorOnly.setSelection(false);
                }
            }
        });
        this.accountingOnly = new Button(content, 32);
        this.accountingOnly.setText("nur von folgenden Abrechnungssystemen");
        this.accountingSelector = new GenericSelectionComposite(content, 0);
        this.accountingSelector.setInput(Arrays.asList(BillingSystem.getAbrechnungsSysteme()));
        this.accountingSelector.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.accountingSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.accountingOnly.setSelection(true);
                } else {
                    BillingProposalWizardDialog.this.accountingOnly.setSelection(false);
                }
            }
        });
        this.errorneousOnly = new Button(content, 32);
        this.errorneousOnly.setText("nur fehlerhafte");
        new Label(content, 0);
        return ret;
    }

    protected void okPressed() {
        ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
        QueryProposalRunnable runnable = new QueryProposalRunnable();
        try {
            progress.run(true, true, (IRunnableWithProgress)runnable);
            if (runnable.isCanceled()) {
                return;
            }
            this.proposal = runnable.getProposal();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerFactory.getLogger(BillingProposalWizardDialog.class).error("Error running proposal query", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Fehler", (String)"Fehler beim Ausf\u00fchren des Rechnungs-Vorschlags.");
            return;
        }
        super.okPressed();
    }

    public Optional<List<Konsultation>> getProposal() {
        return Optional.ofNullable(this.proposal);
    }

    private class QueryProposalRunnable
    implements IRunnableWithProgress {
        private static final String PS_GETOPENKONSOFFALL = "SELECT ID FROM BEHANDLUNGEN WHERE deleted='0' AND billable='1' AND RechnungsID is null AND FallID=?";
        private boolean canceled = false;
        private List<Konsultation> proposal = new ArrayList<Konsultation>();
        private IFilter insurerOnlyFilter;
        private IFilter accountingOnlyFilter;
        private IFilter errorneousOnlyFilter;
        private Query<Konsultation> query = new Query(Konsultation.class);
        private boolean addSeries;

        public QueryProposalRunnable() {
            IStructuredSelection selection;
            this.query.add("RechnungsID", "=", null);
            this.query.add("billable", "=", "1");
            if (BillingProposalWizardDialog.this.timeSpanOnly.getSelection() && (selection = (IStructuredSelection)BillingProposalWizardDialog.this.timeSpanSelection.getSelection()) != null && !selection.isEmpty()) {
                TimeSpan timeSpan = (TimeSpan)selection.getFirstElement();
                this.query.add("Datum", ">=", timeSpan.from.toString(9));
                this.query.add("Datum", "<=", timeSpan.until.toString(9));
            }
            if (BillingProposalWizardDialog.this.beforeTimeOnly.getSelection()) {
                this.addSeries = true;
                selection = (IStructuredSelection)BillingProposalWizardDialog.this.beforeDaysOrDate.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    LocalDate fromDate = (LocalDate)selection.getFirstElement();
                    TimeTool fromTool = new TimeTool(fromDate);
                    this.query.add("Datum", "<=", fromTool.toString(9));
                }
            }
            if (BillingProposalWizardDialog.this.mandatorOnly.getSelection() && (selection = (IStructuredSelection)BillingProposalWizardDialog.this.mandatorSelector.getSelection()) != null && !selection.isEmpty()) {
                List mandators = selection.toList();
                this.query.startGroup();
                int i = 0;
                while (i < mandators.size()) {
                    if (i > 0) {
                        this.query.or();
                    }
                    this.query.add("MandantID", "=", ((Mandant)mandators.get(i)).getId());
                    ++i;
                }
                this.query.endGroup();
            }
            if (BillingProposalWizardDialog.this.insurerOnly.getSelection()) {
                this.insurerOnlyFilter = new IFilter(){
                    private List<Kontakt> insurers;
                    {
                        this.insurers = ((IStructuredSelection)BillingProposalWizardDialog.this.insurerSelection.getSelection()).toList();
                    }

                    public boolean select(Object element) {
                        Fall fall = ((Konsultation)element).getFall();
                        Kontakt costBearer = fall.getCostBearer();
                        if (costBearer != null) {
                            for (Kontakt insurer : this.insurers) {
                                if (!costBearer.getId().equals(insurer.getId())) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                };
            }
            if (BillingProposalWizardDialog.this.accountingOnly.getSelection()) {
                this.accountingOnlyFilter = new IFilter(){
                    private List<String> accountings;
                    {
                        this.accountings = ((IStructuredSelection)BillingProposalWizardDialog.this.accountingSelector.getSelection()).toList();
                    }

                    public boolean select(Object element) {
                        Fall fall = ((Konsultation)element).getFall();
                        String accounting = fall.getAbrechnungsSystem();
                        return this.accountings.contains(accounting);
                    }
                };
            }
            if (BillingProposalWizardDialog.this.errorneousOnly.getSelection()) {
                this.errorneousOnlyFilter = new IFilter(){

                    public boolean select(Object element) {
                        return !BillingUtil.getBillableResult((Konsultation)((Konsultation)element)).isOK();
                    }
                };
            }
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public List<Konsultation> getProposal() {
            return this.proposal;
        }

        private static /* synthetic */ String lambda$0(Konsultation k) {
            return k.getId();
        }
    }
}

