/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.ISticker;
import ch.elexis.core.ui.data.UiSticker;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Sticker;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class AssignStickerDialog
extends TitleAreaDialog {
    PersistentObject mine;
    TableViewer viewer;
    StickerViewerComparator comparator;
    List<Sticker> alleEtiketten;
    List<ISticker> mineEtiketten;

    public AssignStickerDialog(Shell shell, PersistentObject obj) {
        super(shell);
        this.mine = obj;
        this.mineEtiketten = this.mine.getStickers();
        this.alleEtiketten = Sticker.getStickersForClass(this.mine.getClass());
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        ret.setLayout((Layout)new GridLayout());
        Label lbl = new Label(ret, 64);
        lbl.setText(Messages.AssignStickerDialog_PleaseConfirm);
        this.viewer = new TableViewer(ret, 65568);
        this.viewer.getTable().setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput(this.alleEtiketten);
        this.createColumns();
        this.comparator = new StickerViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.checkAlreadySelected();
        return ret;
    }

    private void checkAlreadySelected() {
        TableItem[] tableItems;
        TableItem[] tableItemArray = tableItems = this.viewer.getTable().getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (this.mineEtiketten.contains(item.getData())) {
                item.setChecked(true);
            }
            ++n2;
        }
    }

    private void createColumns() {
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.AssignStickerDialog_StickerName);
        col.getColumn().setWidth(300);
        col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 0));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Sticker s = (Sticker)element;
                return s.getLabel();
            }

            public Color getBackground(Object element) {
                Sticker s = (Sticker)element;
                UiSticker uiSticker = new UiSticker(s);
                return uiSticker.getBackground();
            }

            public Color getForeground(Object element) {
                Sticker s = (Sticker)element;
                UiSticker uiSticker = new UiSticker(s);
                return uiSticker.getForeground();
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        col.getColumn().setText(Messages.AssignStickerDialog_StickerWert);
        col.getColumn().setWidth(50);
        col.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(col.getColumn(), 1));
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Sticker s = (Sticker)element;
                return String.valueOf(s.getWert());
            }

            public Color getBackground(Object element) {
                Sticker s = (Sticker)element;
                UiSticker uiSticker = new UiSticker(s);
                return uiSticker.getBackground();
            }

            public Color getForeground(Object element) {
                Sticker s = (Sticker)element;
                UiSticker uiSticker = new UiSticker(s);
                return uiSticker.getForeground();
            }
        });
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignStickerDialog.this.comparator.setColumn(index);
                AssignStickerDialog.this.viewer.getTable().setSortDirection(AssignStickerDialog.this.comparator.getDirection());
                AssignStickerDialog.this.viewer.getTable().setSortColumn(column);
                AssignStickerDialog.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void create() {
        super.create();
        this.setTitle("Sticker");
        this.setMessage(MessageFormat.format(Messages.AssignStickerDialog_enterStickers, this.mine.getLabel()));
        this.getShell().setText("Elexis Sticker");
    }

    protected void okPressed() {
        AcquireLockBlockingUi.aquireAndRun((IPersistentObject)this.mine, new ILockHandler(){

            @Override
            public void lockFailed() {
            }

            @Override
            public void lockAcquired() {
                TableItem[] tableItems;
                TableItem[] tableItemArray = tableItems = AssignStickerDialog.this.viewer.getTable().getItems();
                int n = tableItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem it = tableItemArray[n2];
                    Sticker et = (Sticker)it.getData();
                    if (it.getChecked()) {
                        if (!AssignStickerDialog.this.mineEtiketten.contains(et)) {
                            AssignStickerDialog.this.mine.addSticker((ISticker)et);
                        }
                    } else if (AssignStickerDialog.this.mineEtiketten.contains(et)) {
                        AssignStickerDialog.this.mine.removeSticker((ISticker)et);
                    }
                    ++n2;
                }
                ElexisEventDispatcher.update((PersistentObject)AssignStickerDialog.this.mine);
                AssignStickerDialog.this.closeDialog(true);
            }
        });
    }

    private void closeDialog(boolean withOk) {
        if (withOk) {
            super.okPressed();
        } else {
            super.cancelPressed();
        }
    }

    class StickerViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private boolean direction = true;
        private Sticker s1;
        private Sticker s2;

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Sticker && e2 instanceof Sticker) {
                this.s1 = (Sticker)e1;
                this.s2 = (Sticker)e2;
                int rc = 0;
                switch (this.propertyIndex) {
                    case 0: {
                        String label1 = this.s1.getLabel().toLowerCase();
                        String label2 = this.s2.getLabel().toLowerCase();
                        rc = label1.compareTo(label2);
                        break;
                    }
                    case 1: {
                        Integer wert1 = this.s1.getWert();
                        Integer wert2 = this.s2.getWert();
                        rc = wert1.compareTo(wert2);
                        break;
                    }
                }
                if (this.direction) {
                    rc = -rc;
                }
                return rc;
            }
            return 0;
        }

        public int getDirection() {
            return this.direction ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = !this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = true;
            }
        }
    }
}

