/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.ui.icons.Images;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class RemoveSelectedEntriesAction
extends Action {
    private StructuredViewer structuredViewer;
    private Collection<?> targetCollection;

    public RemoveSelectedEntriesAction(StructuredViewer structuredViewer, Collection<?> targetCollection) {
        this.structuredViewer = structuredViewer;
        this.targetCollection = targetCollection;
        this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
        this.setText(Messages.LabGroupPrefs_delete);
    }

    public RemoveSelectedEntriesAction(StructuredViewer structuredViewer) {
        this(structuredViewer, null);
    }

    public void run() {
        IStructuredSelection structuredSelection = this.structuredViewer.getStructuredSelection();
        if (this.targetCollection != null) {
            this.targetCollection.removeAll(structuredSelection.toList());
            this.structuredViewer.setInput(this.targetCollection);
        } else {
            Object input = this.structuredViewer.getInput();
            if (input instanceof Collection) {
                ((Collection)input).removeAll(structuredSelection.toList());
            }
            this.structuredViewer.refresh();
        }
        super.run();
    }
}

