/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.extension.AbstractCoreOperationAdvisor;
import ch.elexis.core.ui.Messages;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.dialogs.ErsterMandantDialog;
import ch.elexis.core.ui.dialogs.LoginDialog;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.SqlWithUiRunner;
import ch.elexis.core.ui.wizards.DBConnectWizard;
import ch.elexis.data.Anwender;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreOperationAdvisor
extends AbstractCoreOperationAdvisor {
    public String initialPerspectiveString;
    private Logger log = LoggerFactory.getLogger(CoreOperationAdvisor.class);

    public void requestDatabaseConnectionConfiguration() {
        WizardDialog wd = new WizardDialog(UiDesk.getTopShell(), (IWizard)new DBConnectWizard());
        wd.create();
        SWTHelper.center(wd.getShell());
        wd.open();
        CoreHub.localCfg.flush();
    }

    public void requestInitialMandatorConfiguration() {
        Display d = Display.getDefault();
        new ErsterMandantDialog(d.getActiveShell()).open();
    }

    public void adaptForUser() {
        if (CoreHub.actUser != null) {
            this.initialPerspectiveString = CoreHub.localCfg.get(CoreHub.actUser + "/default_perspective", null);
            boolean fixLayoutChecked = CoreHub.userCfg.get("perspectives/fix_layout", false);
            if (GlobalActions.fixLayoutAction != null) {
                GlobalActions.fixLayoutAction.setChecked(fixLayoutChecked);
            }
        } else if (GlobalActions.fixLayoutAction != null) {
            GlobalActions.fixLayoutAction.setChecked(false);
        }
    }

    public String getInitialPerspective() {
        return this.initialPerspectiveString == null ? "ch.elexis.PatientPerspective" : this.initialPerspectiveString;
    }

    public void openInformation(String title, String message) {
        if (this.isDisplayAvailable()) {
            InfoDialogRunnable runnable = new InfoDialogRunnable(title, message);
            Display.getDefault().syncExec((Runnable)runnable);
            return;
        }
        this.log.error("Could not show info [" + title + "] [" + message + "]");
    }

    public boolean openQuestion(String title, String message) {
        if (this.isDisplayAvailable()) {
            QuestionDialogRunnable runnable = new QuestionDialogRunnable(title, message);
            Display.getDefault().syncExec((Runnable)runnable);
            return runnable.getResult();
        }
        this.log.error("Could not ask question [" + title + "] [" + message + "]");
        return false;
    }

    public void performLogin(Object shell) {
        String username = System.getProperty("ch.elexis.username");
        String password = System.getProperty("ch.elexis.password");
        if (username != null && password != null) {
            this.log.error("Bypassing LoginDialog with username " + username);
            if (!Anwender.login((String)username, (String)password)) {
                this.log.error("Authentication failed. Exiting");
            }
        } else {
            LoginDialog dlg = new LoginDialog((Shell)shell);
            dlg.create();
            dlg.getShell().setText(Messages.LoginDialog_loginHeader);
            dlg.setTitle(Messages.LoginDialog_notLoggedIn);
            dlg.setMessage(Messages.LoginDialog_enterUsernamePass);
            dlg.open();
        }
    }

    public boolean performDatabaseUpdate(String[] array, String pluginId) {
        return new SqlWithUiRunner(array, pluginId).runSql();
    }

    public void showProgress(final ch.elexis.core.data.util.IRunnableWithProgress irwp, final String taskName) {
        try {
            if (this.isDisplayAvailable()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getDefault().getActiveShell()){

                            protected void configureShell(Shell shell) {
                                super.configureShell(shell);
                                if (taskName != null) {
                                    shell.setText(taskName);
                                }
                            }
                        };
                        IRunnableWithProgress irpwAdapter = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                irwp.run(monitor);
                            }
                        };
                        try {
                            pmd.run(true, true, irpwAdapter);
                        }
                        catch (InterruptedException | InvocationTargetException e) {
                            CoreOperationAdvisor.this.log.error("Execution error", (Throwable)e);
                        }
                    }
                });
            } else {
                irwp.run((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.log.error("Execution error", (Throwable)e);
        }
    }

    protected boolean isDisplayAvailable() {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        return Display.getDefault() != null;
    }

    private class InfoDialogRunnable
    implements Runnable {
        private String title;
        private String message;

        public InfoDialogRunnable(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)this.title, (String)this.message);
        }
    }

    private class QuestionDialogRunnable
    implements Runnable {
        private String title;
        private String message;
        private boolean result;

        public QuestionDialogRunnable(String title, String message) {
            this.title = title;
            this.message = message;
        }

        @Override
        public void run() {
            this.result = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)this.title, (String)this.message);
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

