/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Artikel;
import ch.elexis.data.Query;
import ch.elexis.data.Verrechnet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class FixLeistungenKlasseReferenz
extends ExternalMaintenance {
    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        StringBuilder output = new StringBuilder();
        pm.beginTask("Fixing class designations", 4);
        pm.subTask("Finding articles ...");
        Query qbe = new Query(Artikel.class);
        qbe.or();
        qbe.add("deleted", "=", "1");
        List qre = qbe.execute();
        pm.worked(1);
        pm.subTask("Fixing entries ...");
        for (Artikel artikel : qre) {
            String klasse = artikel.get("Klasse");
            int klasseLength = klasse.length();
            if (klasseLength > 0) continue;
            String artikelTyp = artikel.get("Typ").trim();
            if (artikelTyp.equalsIgnoreCase("Medical")) {
                artikel.set("Klasse", "ch.elexis.artikel_ch.data.Medical");
                output.append("Fixing " + artikel.getName() + " from no Klasse field entry to ch.elexis.artikel_ch.data.Medical\n");
                continue;
            }
            if (artikelTyp.equalsIgnoreCase("Medikament")) {
                artikel.set("Klasse", "ch.elexis.artikel_ch.data.Medikament");
                output.append("Setting " + artikel.getName() + " from no Klasse field entry to ch.elexis.artikel_ch.data.Medikament\n");
                continue;
            }
            if (artikelTyp.equalsIgnoreCase("Medikamente")) {
                artikel.set("Klasse", "ch.elexis.artikel_ch.data.Medikament");
                output.append("Setting " + artikel.getName() + " from no Klasse field entry to ch.elexis.artikel_ch.data.Medikament\n");
                continue;
            }
            if (artikelTyp.equalsIgnoreCase("Eigenartikel")) {
                artikel.set("Klasse", "ch.elexis.data.Eigenartikel");
                output.append("Setting " + artikel.getName() + " from no Klasse field entry to ch.elexis.data.Eigenartikel\n");
                continue;
            }
            if (!artikelTyp.equalsIgnoreCase("MiGeL")) continue;
            artikel.set("Klasse", "ch.elexis.artikel_ch.data.MiGelArtikel");
            output.append("Setting " + artikel.getName() + " from no Klasse field entry to ch.elexis.artikel_ch.data.MiGelArtikel\n");
        }
        pm.worked(1);
        pm.subTask("Finding leistungen ...");
        Query qbeV = new Query(Verrechnet.class);
        qbeV.or();
        qbeV.add("deleted", "=", "1");
        List qreV = qbeV.execute();
        pm.worked(1);
        pm.subTask("Fixing entries ...");
        for (Verrechnet ver : qreV) {
            String leistungId = ver.get("Leistg_code");
            Artikel art = Artikel.load((String)leistungId);
            if (!art.exists()) continue;
            ver.set("Klasse", art.get("Klasse"));
            output.append("Fixing Klasse entry for " + ver.getLabel() + " to " + art.get("Klasse") + "\n");
        }
        pm.worked(1);
        pm.done();
        return output.toString();
    }

    @Override
    public String getMaintenanceDescription() {
        return "Fix class type designations in article and leistungen";
    }
}

