/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.crypt;

import ch.rgw.crypt.Base64Coder;
import ch.rgw.crypt.Cryptologist;
import ch.rgw.crypt.CryptologistException;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.SoapConverter;
import ch.rgw.tools.StringTool;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class SAT {
    public static final String KEY_RESULT = "return";
    public static final String KEY_ERROR = "error";
    public static final String USER_UNKNOWN = "User unknown";
    public static final String RESULT_BAD_SIGNATURE = "Bad signature";
    public static final String ADM_TIMESTAMP = "ADM_timestamp";
    public static final String ADM_SIGNED_BY = "ADM_user";
    public static final String ADM_PAYLOAD = "ADM_payload";
    public static final String ADM_SIGNATURE = "ADM_signature";
    public static final String ERR_SERVER = "Server error: ";
    public static final String ERR_DECRYPT = "Decrypt error: ";
    private static final String VERSION = "0.3.0";
    private String ident = "xidClient";
    private String prov = "elexis.ch";
    Cryptologist crypt;

    public SAT(Cryptologist c) {
        this.crypt = c;
    }

    public SAT(String creator, String provider, Cryptologist c) {
        this(c);
        this.ident = creator;
        this.prov = provider;
    }

    public Map<String, Serializable> unwrap(byte[] encrypted, boolean bCheckSignature) throws CryptologistException {
        if (encrypted == null) {
            throw new CryptologistException("Null packet from server", 1);
        }
        if (encrypted.length < 35) {
            throw new CryptologistException(new String(encrypted), 2);
        }
        Result<byte[]> dec = this.crypt.decrypt(encrypted);
        if (dec == null || !dec.isOK()) {
            throw new CryptologistException("Decryption failed: " + dec == null ? "dec is null" : String.valueOf(dec), 3);
        }
        SoapConverter sc = new SoapConverter();
        byte[] decrypted = dec.get();
        if (sc.load(decrypted)) {
            Map<String, Serializable> fields = sc.getParameters();
            String user = (String)((Object)fields.get(ADM_SIGNED_BY));
            Long ts = (Long)fields.get(ADM_TIMESTAMP);
            byte[] signature = (byte[])fields.get(ADM_SIGNATURE);
            if (StringTool.isNothing(user) || signature == null) {
                throw new CryptologistException("Bad protocol", 4);
            }
            if (ts == null || System.currentTimeMillis() - ts > 300000L) {
                throw new CryptologistException("timeout", 5);
            }
            Map ret = (Map)((Object)fields.get(ADM_PAYLOAD));
            if (!bCheckSignature) {
                return ret;
            }
            byte[] digest = this.calcDigest(sc);
            if (this.crypt.verify(digest, signature, user) == Cryptologist.VERIFY_RESULT.OK) {
                ret.put(ADM_SIGNED_BY, user);
                return ret;
            }
            throw new CryptologistException("User unknown: " + user, 7);
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put(KEY_ERROR, (Serializable)((Object)"Invalid Message"));
        return result;
    }

    public byte[] wrap(Map<String, Serializable> var, String dest) throws CryptologistException {
        SoapConverter sc = new SoapConverter();
        sc.create(this.ident, VERSION, this.prov);
        try {
            sc.addMap(null, ADM_PAYLOAD, var);
        }
        catch (Exception ex) {
            throw new CryptologistException("Internal Cryptologist error: " + ex.getMessage(), 6);
        }
        sc.addIntegral(ADM_TIMESTAMP, System.currentTimeMillis());
        sc.addString(ADM_SIGNED_BY, this.crypt.getUser());
        byte[] digest = this.calcDigest(sc);
        byte[] signature = this.crypt.sign(digest);
        sc.addArray(ADM_SIGNATURE, signature);
        String xml = sc.toString();
        byte[] wrapped = this.crypt.encrypt(StringTool.getBytes(xml), dest);
        if (wrapped == null) {
            throw new CryptologistException("Encry<ption failed", 9);
        }
        return wrapped;
    }

    @Deprecated
    public String sendRequest(String hostaddress, String request) {
        try {
            int in;
            URLConnection conn = new URL(hostaddress).openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            String rx = new String(Base64Coder.encodeString(request));
            out.write("request=" + rx);
            out.close();
            StringBuilder sb = new StringBuilder();
            InputStream is = conn.getInputStream();
            while ((in = is.read()) != -1) {
                sb.append((byte)in);
            }
            return Base64Coder.decodeString(sb.toString());
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return "";
        }
    }

    public byte[] sendRequest(String hostaddress, byte[] request) {
        try {
            int in;
            URLConnection conn = new URL(hostaddress).openConnection();
            conn.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            String rx = StringTool.enPrintableStrict(request);
            out.write("request=" + rx);
            out.close();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream is = conn.getInputStream();
            while ((in = is.read()) != -1) {
                baos.write(in);
            }
            return baos.toByteArray();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    private byte[] calcDigest(SoapConverter sc) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            Document doc = sc.getXML();
            Element eRoot = doc.getRootElement();
            Element body = eRoot.getChild("Body", SoapConverter.ns);
            this.addParameters(body, digest);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            ExHandler.handle(e);
            return null;
        }
    }

    private void addParameters(Element e, MessageDigest digest) {
        List params = e.getChildren("parameter", SoapConverter.ns);
        for (Element el : params) {
            String type = el.getAttributeValue("type");
            String name = el.getAttributeValue("name");
            if (type.equalsIgnoreCase("map")) {
                this.addParameters(el, digest);
                continue;
            }
            if (name.equalsIgnoreCase(ADM_SIGNATURE)) continue;
            digest.update(StringTool.getBytes(type));
            digest.update(StringTool.getBytes(name));
            digest.update(StringTool.getBytes(el.getTextTrim()));
        }
    }
}

