/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.crypt;

import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.x509.X509V1CertificateGenerator;

public class JCEKeyManager {
    private static final String CERTIFICATE_SIGNATURE_ALGO = "SHA256withRSA";
    protected KeyStore ks;
    private static SecureRandom _srnd;
    protected static Logger log;
    protected char[] storePwd = null;
    protected String ksType;
    private String ksFile;

    static {
        log = Logger.getLogger("KeyManager");
        _srnd = new SecureRandom();
    }

    public static String Version() {
        return "0.1.6";
    }

    private JCEKeyManager() {
    }

    public JCEKeyManager(String keystoreFile, String type, char[] keystorePwd) {
        this(type, keystorePwd);
        File fksPath;
        this.ksFile = StringTool.isNothing(keystoreFile) ? String.valueOf(System.getProperty("user.home")) + "/.keystore" : FileTool.resolveFile(keystoreFile).getAbsolutePath();
        log.log(Level.FINE, "ksPathName: " + this.ksFile);
        File fks = new File(this.ksFile);
        if (!fks.exists() && !(fksPath = fks.getParentFile()).exists()) {
            fksPath.mkdirs();
        }
    }

    public JCEKeyManager(String type, char[] storepwd) {
        try {
            _srnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            ExHandler.handle(e);
            _srnd = new SecureRandom();
        }
        this.ksType = StringTool.isNothing(type) ? "jks" : type;
        this.storePwd = storepwd;
    }

    public boolean load(boolean bCreateIfNotExists) {
        try {
            File ksf = new File(this.ksFile);
            if (!ksf.exists()) {
                return this.create(false);
            }
            this.ks = KeyStore.getInstance(this.ksType);
            this.ks.load(new FileInputStream(this.ksFile), this.storePwd);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            log.log(Level.SEVERE, "No Keystore found or could not open Keystore: " + ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean create(boolean bDeleteIfExists) {
        File ksF = new File(this.ksFile);
        if (ksF.exists()) {
            if (bDeleteIfExists) {
                if (!ksF.delete()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.ks == null) {
            try {
                this.ks = KeyStore.getInstance(this.ksType);
                this.ks.load(null, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.save();
    }

    public boolean save() {
        try {
            this.ks.store(new FileOutputStream(this.ksFile), this.storePwd);
            return true;
        }
        catch (Exception e) {
            ExHandler.handle(e);
            return false;
        }
    }

    public boolean isKeystoreLoaded() {
        return this.ks != null;
    }

    public PublicKey getPublicKey(String alias) {
        Certificate cert;
        block6: {
            if (alias == null) {
                return null;
            }
            if (this.ks == null) {
                log.log(Level.WARNING, "Keystore nicht geladen");
                if (!this.load(true)) {
                    return null;
                }
            }
            try {
                cert = this.ks.getCertificate(alias);
                if (cert != null) break block6;
                log.log(Level.WARNING, "No certificate \"" + alias + "\"found");
                return null;
            }
            catch (Exception ex) {
                ExHandler.handle(ex);
                return null;
            }
        }
        return cert.getPublicKey();
    }

    public X509Certificate getCertificate(String alias) {
        Certificate cert;
        block5: {
            if (this.ks == null) {
                log.log(Level.WARNING, "Keystore nicht geladen");
                if (!this.load(true)) {
                    return null;
                }
            }
            try {
                cert = this.ks.getCertificate(alias);
                if (cert != null) break block5;
                log.log(Level.WARNING, "No certificate \"" + alias + "\"found");
                return null;
            }
            catch (Exception ex) {
                ExHandler.handle(ex);
                return null;
            }
        }
        return (X509Certificate)cert;
    }

    public PublicKey getPublicKey(InputStream is) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(is);
            return cert.getPublicKey();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public PrivateKey getPrivateKey(String alias, char[] pwd) {
        block3: {
            try {
                if (!StringTool.isNothing(alias) && this.ks.isKeyEntry(alias)) break block3;
                log.log(Level.WARNING, "Alias falsch oder fehlend");
                return null;
            }
            catch (Exception ex) {
                ExHandler.handle(ex);
                log.log(Level.SEVERE, "Kann Key nicht laden");
                return null;
            }
        }
        return (PrivateKey)this.ks.getKey(alias, pwd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addCertificate(X509Certificate cert) {
        try {
            String[] n;
            String[] stringArray = n = cert.getSubjectX500Principal().getName().split(",");
            int n2 = n.length;
            int n3 = 0;
            while (true) {
                String[] fx;
                if (n3 >= n2) {
                    return false;
                }
                String sub = stringArray[n3];
                if (sub.startsWith("CN") && (fx = sub.split("\\s*=\\s*")).length > 1) {
                    this.ks.setCertificateEntry(fx[1].trim(), cert);
                    return true;
                }
                ++n3;
            }
        }
        catch (KeyStoreException e) {
            ExHandler.handle(e);
            return false;
        }
    }

    public X509Certificate generateCertificate(PublicKey pk, PrivateKey signingKey, String issuer, String subject, TimeTool ttFrom, TimeTool ttUntil) throws InvalidKeyException, NoSuchProviderException, SignatureException, CertificateEncodingException, IllegalStateException, NoSuchAlgorithmException, KeyStoreException {
        X509V1CertificateGenerator certGen = new X509V1CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(new X500Principal("CN=" + issuer));
        if (ttFrom == null) {
            ttFrom = new TimeTool();
        }
        if (ttUntil == null) {
            ttUntil = new TimeTool(ttFrom);
            ttUntil.add(1, 2);
        }
        certGen.setNotBefore(ttFrom.getTime());
        certGen.setNotAfter(ttUntil.getTime());
        certGen.setSubjectDN(new X500Principal("CN=" + subject));
        certGen.setPublicKey(pk);
        certGen.setSignatureAlgorithm(CERTIFICATE_SIGNATURE_ALGO);
        X509Certificate cert = certGen.generate(signingKey);
        this.ks.setCertificateEntry(subject, cert);
        return cert;
    }

    public boolean addKeyPair(PrivateKey kpriv, X509Certificate cert, char[] keyPwd) throws Exception {
        String alias = this.getName(cert);
        this.ks.setKeyEntry(alias, kpriv, keyPwd, new Certificate[]{cert});
        return true;
    }

    String getName(X509Certificate cert) {
        String cn = cert.getSubjectDN().getName();
        int s = cn.indexOf(61);
        if (s != -1) {
            return cn.substring(s + 1);
        }
        return cn;
    }

    public boolean existsPrivate(String alias) {
        try {
            return this.ks.isKeyEntry(alias);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean existsCertificate(String alias) {
        try {
            return this.ks.isCertificateEntry(alias);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return false;
        }
    }

    public KeyPair generateKeys() {
        try {
            KeyPairGenerator kp = KeyPairGenerator.getInstance("RSA");
            kp.initialize(1024, _srnd);
            return kp.generateKeyPair();
        }
        catch (Exception e) {
            ExHandler.handle(e);
            return null;
        }
    }

    public SecureRandom getRandom() {
        return _srnd;
    }

    public boolean removeKey(String alias) {
        try {
            this.ks.deleteEntry(alias);
            return this.save();
        }
        catch (KeyStoreException e) {
            ExHandler.handle(e);
            return false;
        }
    }
}

