/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.compress;

import ch.rgw.io.BitInputStream;
import ch.rgw.io.BitOutputStream;
import ch.rgw.tools.ExHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GLZ {
    private static final int LZBUFFSIZE = 36082;
    private static final short ofb = 4;
    private int[] buff1 = new int[36082];
    private int[] buff2 = new int[36082];
    private int[] buff3 = new int[18041];
    int LZCode;
    int MaxCode;
    int bitcount;

    public static String Version() {
        return "1.0.0";
    }

    public int compress(InputStream in, OutputStream o) throws IOException {
        BitOutputStream bos = new BitOutputStream(o);
        int size = 0;
        this.fillbuffer();
        int Prev = in.read();
        if (Prev == -1) {
            Prev = 256;
        }
        while (in.available() > 0) {
            int hash;
            int Act = in.read();
            ++size;
            int cnt1 = (hash = Act << 6 ^ Prev) != 0 ? 18041 - hash : 1;
            if (this.buff1[hash = this.findHash(hash, Prev, Act, cnt1)] != -1) {
                Prev = this.buff1[hash];
                continue;
            }
            ++this.LZCode;
            this.buff2[hash] = Prev;
            this.buff3[hash] = (byte)Act;
            bos.pushbits(Prev, this.bitcount);
            Prev = Act;
            if (this.LZCode > 16382) {
                bos.pushbits(258, this.bitcount);
                this.fillbuffer();
                continue;
            }
            if (this.LZCode <= this.MaxCode) continue;
            bos.pushbits(257, this.bitcount++);
            this.MaxCode <<= 1;
            this.MaxCode |= 1;
        }
        bos.pushbits(Prev, this.bitcount);
        bos.pushbits(256, this.bitcount);
        bos.pushbits(0, this.bitcount);
        bos.flush();
        return size + 1;
    }

    private int findHash(int hash, int Prev, int Act, int cnt1) {
        while (this.buff1[hash] != -1) {
            if (this.buff2[hash] == Prev && this.buff3[hash] == (byte)Act) break;
            if ((hash -= cnt1) >= 0) continue;
            hash += 18041;
        }
        return hash;
    }

    private void fillbuffer() {
        int i = 0;
        while (i < this.buff1.length) {
            this.buff1[i] = -1;
            ++i;
        }
        this.LZCode = 259;
        this.bitcount = 9;
        this.MaxCode = 511;
    }

    public void expand(InputStream i, OutputStream o) throws IOException {
        BitInputStream bis = new BitInputStream(i);
        block5: while (true) {
            int Prev;
            this.LZCode = 259;
            this.bitcount = 9;
            this.MaxCode = 511;
            int Prev1 = bis.pullBits(this.bitcount);
            if (Prev1 == 256) {
                o.flush();
                return;
            }
            int Act = Prev = Prev1;
            o.write(Act);
            while (Prev1 != 256) {
                Prev1 = bis.pullBits(this.bitcount);
                switch (Prev1) {
                    case 257: {
                        ++this.bitcount;
                    }
                    case 256: {
                        break;
                    }
                    case 258: {
                        continue block5;
                    }
                    default: {
                        int dx;
                        int si = 4;
                        if (Prev1 >= this.LZCode) {
                            this.buff1[si++] = Act;
                            dx = Prev;
                        }
                        while (dx > 255) {
                            this.buff1[si++] = this.buff3[dx];
                            dx = this.buff2[dx];
                        }
                        this.buff1[si] = Act = dx;
                        do {
                            o.write(this.buff1[si--]);
                        } while (si >= 4);
                        this.buff2[this.LZCode] = Prev;
                        this.buff3[this.LZCode++] = (byte)Act;
                        Prev = Prev1;
                    }
                }
            }
            break;
        }
        o.flush();
    }

    public byte[] encodeString(String input) {
        byte[] b = input.getBytes();
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.compress(in, out);
            return out.toByteArray();
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }

    public String decodeString(byte[] i) {
        ByteArrayInputStream in = new ByteArrayInputStream(i);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.expand(in, out);
            byte[] cp = out.toByteArray();
            return new String(cp);
        }
        catch (Exception ex) {
            ExHandler.handle(ex);
            return null;
        }
    }
}

