/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.views;

import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.events.ElexisEventListener;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.dialogs.ArticleDefaultSignatureTitleAreaDialog;
import ch.elexis.core.ui.dialogs.MediDetailDialog;
import ch.elexis.core.ui.events.ElexisUiEventListenerImpl;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.locks.AcquireLockUi;
import ch.elexis.core.ui.locks.ILockHandler;
import ch.elexis.core.ui.medication.handlers.PrintRecipeHandler;
import ch.elexis.core.ui.medication.handlers.PrintTakingsListHandler;
import ch.elexis.core.ui.medication.views.MedicationViewHelper;
import ch.elexis.core.ui.medication.views.Messages;
import ch.elexis.core.ui.util.CreatePrescriptionHelper;
import ch.elexis.core.ui.util.ListDisplay;
import ch.elexis.core.ui.util.PersistentObjectDragSource;
import ch.elexis.core.ui.util.PersistentObjectDropTarget;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.views.controls.InteractionLink;
import ch.elexis.data.Artikel;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Prescription;
import ch.rgw.tools.ExHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.services.IEvaluationService;

public class FixMediDisplay
extends ListDisplay<Prescription> {
    public static final String ID = "ch.elexis.FixMediDisplay";
    private final ListDisplay.LDListener dlisten;
    private IAction stopMedicationAction;
    private IAction changeMedicationAction;
    private IAction removeMedicationAction;
    private IAction addDefaultSignatureAction;
    FixMediDisplay self;
    Label lCost;
    InteractionLink interactionLink;
    PersistentObjectDropTarget target;
    private MenuManager menuManager;
    private IViewSite viewSite;
    static final String REZEPT = Messages.FixMediDisplay_Prescription;
    static final String LISTE = Messages.FixMediDisplay_UsageList;
    static final String HINZU = Messages.FixMediDisplay_AddItem;
    static final String KOPIEREN = Messages.FixMediDisplay_Copy;
    private ElexisEventListener eeli_presc = new ElexisUiEventListenerImpl(Prescription.class, 7){

        public void runInUi(ElexisEvent ev) {
            FixMediDisplay.this.reload();
        }
    };

    public FixMediDisplay(Composite parent, IViewSite viewSite) {
        super(parent, 0, null);
        this.viewSite = viewSite;
        this.lCost = new Label((Composite)this, 0);
        this.lCost.setText(Messages.FixMediDisplay_DailyCost);
        this.lCost.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.interactionLink = new InteractionLink((Composite)this, 0);
        this.interactionLink.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.dlisten = new DauerMediListener(viewSite);
        this.self = this;
        this.addHyperlinks(new String[]{HINZU, LISTE, REZEPT});
        this.makeActions();
        ViewMenus menu = new ViewMenus(viewSite);
        menu.createControlContextMenu((Control)this.list, new IAction[]{this.stopMedicationAction, this.changeMedicationAction, this.addDefaultSignatureAction, null, this.removeMedicationAction});
        this.menuManager = menu.getContextMenu();
        this.setDLDListener(this.dlisten);
        this.target = new PersistentObjectDropTarget(Messages.FixMediDisplay_FixMedikation, (Control)this, new PersistentObjectDropTarget.IReceiver(){

            public boolean accept(PersistentObject o) {
                if (o instanceof Prescription) {
                    return true;
                }
                return o instanceof Artikel;
            }

            public void dropped(PersistentObject o, DropTargetEvent e) {
                if (o instanceof Artikel) {
                    CreatePrescriptionHelper prescriptionHelper = new CreatePrescriptionHelper((Artikel)o, FixMediDisplay.this.getShell());
                    prescriptionHelper.setMedicationTypeFix(true);
                    prescriptionHelper.createPrescription();
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, Prescription.class, 4)});
                } else if (o instanceof Prescription) {
                    List existing = ((Patient)ElexisEventDispatcher.getSelected(Patient.class)).getMedication(new EntryType[]{EntryType.FIXED_MEDICATION, EntryType.RESERVE_MEDICATION, EntryType.SYMPTOMATIC_MEDICATION});
                    Prescription pre = (Prescription)o;
                    for (Prescription pe : existing) {
                        if (!pe.equals((Object)pre)) continue;
                        return;
                    }
                    final Prescription prescription = new Prescription(pre.getArtikel(), ElexisEventDispatcher.getSelectedPatient(), pre.getDosis(), pre.getBemerkung());
                    AcquireLockUi.aquireAndRun((IPersistentObject)prescription, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                            prescription.remove();
                        }

                        public void lockAcquired() {
                        }
                    });
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent(null, Prescription.class, 4)});
                }
            }
        });
        new PersistentObjectDragSource((Control)this.list, new PersistentObjectDragSource.ISelectionRenderer(){

            public List<PersistentObject> getSelection() {
                Prescription pr = (Prescription)FixMediDisplay.this.getSelection();
                ArrayList<PersistentObject> ret = new ArrayList<PersistentObject>(1);
                if (pr != null) {
                    ret.add((PersistentObject)pr);
                }
                return ret;
            }
        });
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)((PersistentObject)FixMediDisplay.this.getSelection()));
            }
        });
        ElexisEventDispatcher.getInstance().addListeners(new ElexisEventListener[]{this.eeli_presc});
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public void sortList() {
        Object[] items = this.list.getItems();
        Arrays.sort(items);
        this.list.removeAll();
        this.list.setItems((String[])items);
        this.update();
        this.redraw();
    }

    public void reload() {
        if (!this.isDisposed()) {
            this.clear();
            Patient act = ElexisEventDispatcher.getSelectedPatient();
            if (act != null) {
                List fix = act.getMedication(new EntryType[]{EntryType.FIXED_MEDICATION});
                fix.stream().forEach(p -> this.add(p));
                this.lCost.setText(MedicationViewHelper.calculateDailyCostAsString(fix));
                this.interactionLink.updateAtcs(MedicationViewHelper.getAllGtins(fix));
            }
            this.sortList();
        }
    }

    private void makeActions() {
        this.changeMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.FixMediDisplay_Change){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_Modify);
            }

            public void doRun() {
                Prescription pr = (Prescription)FixMediDisplay.this.getSelection();
                if (pr != null) {
                    MediDetailDialog md = new MediDetailDialog(FixMediDisplay.this.getShell(), pr, true);
                    md.setExecutedFrom(FixMediDisplay.class.getSimpleName());
                    md.open();
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)pr, Prescription.class, 4)});
                }
            }
        };
        this.stopMedicationAction = new RestrictedAction(AccessControlDefaults.MEDICATION_MODIFY, Messages.FixMediDisplay_Stop){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_StopThisMedicament);
            }

            public void doRun() {
                final Prescription pr = (Prescription)FixMediDisplay.this.getSelection();
                if (pr != null) {
                    FixMediDisplay.this.remove(pr);
                    AcquireLockUi.aquireAndRun((IPersistentObject)pr, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            if (pr.delete()) {
                                pr.setStopReason("Ge\u00e4ndert durch " + CoreHub.actUser.getLabel());
                            }
                        }
                    });
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)pr, Prescription.class, 4)});
                }
            }
        };
        this.addDefaultSignatureAction = new Action(Messages.FixMediDisplay_AddDefaultSignature){
            {
                this.setImageDescriptor(Images.IMG_BOOKMARK_PENCIL.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_AddDefaultSignature_Tooltip);
            }

            public void run() {
                Prescription pr = (Prescription)FixMediDisplay.this.getSelection();
                if (pr != null) {
                    ArticleDefaultSignatureTitleAreaDialog adtad = new ArticleDefaultSignatureTitleAreaDialog(UiDesk.getTopShell(), pr);
                    adtad.open();
                }
            }
        };
        this.removeMedicationAction = new RestrictedAction(AccessControlDefaults.DELETE_MEDICATION, Messages.FixMediDisplay_Delete){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.FixMediDisplay_DeleteUnrecoverable);
            }

            public void doRun() {
                final Prescription pr = (Prescription)FixMediDisplay.this.getSelection();
                if (pr != null && MessageDialog.openQuestion((Shell)FixMediDisplay.this.getShell(), (String)Messages.FixMediDisplay_DeleteUnrecoverable, (String)Messages.FixMediDisplay_DeleteUnrecoverable)) {
                    FixMediDisplay.this.remove(pr);
                    AcquireLockUi.aquireAndRun((IPersistentObject)pr, (ILockHandler)new ILockHandler(){

                        public void lockFailed() {
                        }

                        public void lockAcquired() {
                            pr.remove();
                        }
                    });
                    ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)pr, Prescription.class, 4)});
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
        ElexisEventDispatcher.getInstance().removeListeners(new ElexisEventListener[]{this.eeli_presc});
    }

    class DauerMediListener
    implements ListDisplay.LDListener {
        IViewSite site;

        DauerMediListener(IViewSite s) {
            this.site = s;
        }

        public void hyperlinkActivated(String l) {
            try {
                if (l.equals(HINZU)) {
                    this.site.getPage().showView("ch.elexis.LeistungenView");
                    CodeSelectorHandler.getInstance().setCodeSelectorTarget((ICodeSelectorTarget)FixMediDisplay.this.target);
                } else if (l.equals(LISTE)) {
                    HashMap<String, String> parameterMap = new HashMap<String, String>();
                    parameterMap.put("ch.elexis.core.ui.medication.commandParameter.medication", "fix");
                    IEvaluationService evaluationService = (IEvaluationService)FixMediDisplay.this.viewSite.getService(IEvaluationService.class);
                    new PrintTakingsListHandler().execute(new ExecutionEvent(null, parameterMap, null, (Object)evaluationService.getCurrentState()));
                } else if (l.equals(REZEPT)) {
                    HashMap<String, String> parameterMap = new HashMap<String, String>();
                    parameterMap.put("ch.elexis.core.ui.medication.commandParameter.medication", "fix");
                    IEvaluationService evaluationService = (IEvaluationService)FixMediDisplay.this.viewSite.getService(IEvaluationService.class);
                    new PrintRecipeHandler().execute(new ExecutionEvent(null, parameterMap, null, (Object)evaluationService.getCurrentState()));
                } else if (l.equals(KOPIEREN)) {
                    FixMediDisplay.this.toClipBoard(true);
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
            }
        }

        public String getLabel(Object o) {
            if (o instanceof Prescription) {
                Prescription presc = (Prescription)o;
                return presc.isReserveMedication() ? String.valueOf(presc.getLabel()) + " Res." : presc.getLabel();
            }
            return o.toString();
        }
    }
}

