/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.medication.handlers;

import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.medication.views.MedicationTableViewerItem;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Prescription;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class MentionInConsultationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection != null && !selection.isEmpty()) {
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            ArrayList<Prescription> prescriptions = new ArrayList<Prescription>();
            List mtvItems = strucSelection.toList();
            for (MedicationTableViewerItem mtvItem : mtvItems) {
                Prescription p = mtvItem.getPrescription();
                if (p == null) continue;
                prescriptions.add(p);
            }
            Konsultation cons = Konsultation.getAktuelleKons();
            if (cons != null) {
                StringBuilder sb = new StringBuilder();
                for (Prescription presc : prescriptions) {
                    String articleLabel = "";
                    if (presc.getArtikel() != null) {
                        articleLabel = presc.getArtikel().getLabel();
                    }
                    sb.append("\n");
                    sb.append("Medikation: " + articleLabel + ", " + presc.getDosis() + " " + this.getType(presc.getEntryType()));
                }
                Samdas samdas = new Samdas(cons.getEintrag().getHead());
                Samdas.Record rec = samdas.getRecord();
                String recText = rec.getText();
                recText = String.valueOf(recText) + sb.toString();
                rec.setText(recText);
                cons.updateEintrag(samdas.toString(), true);
            }
        }
        return null;
    }

    private String getType(EntryType entryType) {
        switch (entryType) {
            case FIXED_MEDICATION: {
                return "(Fixmedikation)";
            }
            case RESERVE_MEDICATION: {
                return "(Reservemedikation)";
            }
            case SELF_DISPENSED: {
                return "(Dispensiert)";
            }
            case RECIPE: {
                return "(Rezeptiert)";
            }
        }
        return "";
    }
}

