/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.schematron.svrl;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.error.EErrorLevel;
import com.phloc.schematron.svrl.ISVRLErrorLevelDeterminator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.oclc.purl.dsdl.svrl.FailedAssert;
import org.oclc.purl.dsdl.svrl.SuccessfulReport;

public class DefaultSVRLErrorLevelDeterminator
implements ISVRLErrorLevelDeterminator {
    public static final EErrorLevel DEFAULT_ERROR_LEVEL = EErrorLevel.ERROR;

    @Nonnull
    public EErrorLevel getErrorLevelFromFlag(@Nullable String string) {
        if (string == null) {
            return DEFAULT_ERROR_LEVEL;
        }
        if (string.equalsIgnoreCase("warning") || string.equalsIgnoreCase("warn")) {
            return EErrorLevel.WARN;
        }
        if (string.equalsIgnoreCase("error") || string.equalsIgnoreCase("err")) {
            return EErrorLevel.ERROR;
        }
        if (string.equalsIgnoreCase("fatal") || string.equalsIgnoreCase("fatal_error") || string.equalsIgnoreCase("fatalerror")) {
            return EErrorLevel.FATAL_ERROR;
        }
        throw new IllegalArgumentException("Cannot convert the SVRL failed assertion flag '" + string + "' to an error level. Please extend the preceeding list!");
    }

    @Override
    @Nonnull
    public EErrorLevel getErrorLevelFromFailedAssert(@Nonnull FailedAssert failedAssert) {
        ValueEnforcer.notNull((Object)failedAssert, (String)"FailedAssert");
        return this.getErrorLevelFromFlag(failedAssert.getFlag());
    }

    @Override
    @Nonnull
    public EErrorLevel getErrorLevelFromSuccessfulReport(@Nonnull SuccessfulReport successfulReport) {
        ValueEnforcer.notNull((Object)successfulReport, (String)"SuccessfulReport");
        return this.getErrorLevelFromFlag(successfulReport.getFlag());
    }
}

