/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.ValueEnforcer;
import com.phloc.commons.io.streams.NonBlockingStringWriter;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsManager;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLSerializerPhloc;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Immutable
public final class XMLWriter {
    public static final EXMLVersion DEFAULT_XML_VERSION = EXMLVersion.DEFAULT;
    public static final NamespaceContext DEFAULT_NAMESPACE_CTX = null;
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLWriter.class);
    private static final IStatisticsHandlerSize s_aSizeHdl = StatisticsManager.getSizeHandler(XMLWriter.class);
    private static final XMLWriter s_aInstance = new XMLWriter();

    private XMLWriter() {
    }

    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node node, @Nonnull @WillClose OutputStream outputStream) {
        return XMLWriter.writeToStream(node, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node node, @Nonnull @WillClose OutputStream outputStream, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(node, "Node");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        try {
            XMLSerializerPhloc xMLSerializerPhloc = new XMLSerializerPhloc(iXMLWriterSettings);
            xMLSerializerPhloc.write(node, outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            s_aLogger.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            s_aLogger.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamUtils.close(outputStream);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node node, @Nonnull @WillClose Writer writer) {
        return XMLWriter.writeToWriter(node, writer, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node node, @Nonnull @WillClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(node, "Node");
        ValueEnforcer.notNull(writer, "Writer");
        ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        try {
            XMLSerializerPhloc xMLSerializerPhloc = new XMLSerializerPhloc(iXMLWriterSettings);
            xMLSerializerPhloc.write(node, writer);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            s_aLogger.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            s_aLogger.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamUtils.close(writer);
        }
        return ESuccess.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getNodeAsString(@Nonnull Node node, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        NonBlockingStringWriter nonBlockingStringWriter;
        block4: {
            String string;
            nonBlockingStringWriter = null;
            try {
                nonBlockingStringWriter = new NonBlockingStringWriter(51200);
                if (!XMLWriter.writeToWriter(node, nonBlockingStringWriter, iXMLWriterSettings).isSuccess()) break block4;
                s_aSizeHdl.addSize(nonBlockingStringWriter.size());
                string = nonBlockingStringWriter.getAsString();
            }
            catch (Throwable throwable) {
                try {
                    s_aLogger.error("Error serializing DOM node with settings " + iXMLWriterSettings.toString(), throwable);
                }
                catch (Throwable throwable2) {
                    StreamUtils.close(nonBlockingStringWriter);
                    throw throwable2;
                }
                StreamUtils.close(nonBlockingStringWriter);
            }
            StreamUtils.close(nonBlockingStringWriter);
            return string;
        }
        StreamUtils.close(nonBlockingStringWriter);
        return null;
    }

    @Nullable
    public static String getXMLString(@Nonnull Node node) {
        return XMLWriter.getNodeAsString(node, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

