/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.hash;

import com.phloc.commons.annotations.IsSPIImplementation;
import com.phloc.commons.hash.HashCodeCalculator;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.hash.IHashCodeImplementation;
import com.phloc.commons.hash.IHashCodeImplementationRegistrarSPI;
import com.phloc.commons.hash.IHashCodeImplementationRegistry;
import com.phloc.commons.io.file.FilenameHelper;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@IsSPIImplementation
public final class DefaultHashCodeImplementationRegistrarSPI
implements IHashCodeImplementationRegistrarSPI {
    @Override
    public void registerHashCodeImplementations(@Nonnull IHashCodeImplementationRegistry iHashCodeImplementationRegistry) {
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuffer.class, new HashCodeImplementationStringBuffer());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(StringBuilder.class, new HashCodeImplementationStringBuilder());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Node.class, new HashCodeImplementationNode());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicBoolean.class, new HashCodeImplementationAtomicBoolean());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicInteger.class, new HashCodeImplementationAtomicInteger());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(AtomicLong.class, new HashCodeImplementationAtomicLong());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(boolean[].class, new HashCodeImplementationArrayBoolean());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(byte[].class, new HashCodeImplementationArrayByte());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(char[].class, new HashCodeImplementationArrayChar());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(double[].class, new HashCodeImplementationArrayDouble());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(float[].class, new HashCodeImplementationArrayFloat());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(int[].class, new HashCodeImplementationArrayInt());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(long[].class, new HashCodeImplementationArrayLong());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(short[].class, new HashCodeImplementationArrayShort());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Map.class, new HashCodeImplementationMap());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Collection.class, new HashCodeImplementationCollection());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Iterator.class, new HashCodeImplementationIterator());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(Enumeration.class, new HashCodeImplementationEnumeration());
        iHashCodeImplementationRegistry.registerHashCodeImplementation(File.class, new HashCodeImplementationFile());
    }

    private static final class HashCodeImplementationStringBuffer
    implements IHashCodeImplementation {
        private HashCodeImplementationStringBuffer() {
        }

        @Override
        public int getHashCode(Object object) {
            return object.toString().hashCode();
        }
    }

    private static final class HashCodeImplementationStringBuilder
    implements IHashCodeImplementation {
        private HashCodeImplementationStringBuilder() {
        }

        @Override
        public int getHashCode(Object object) {
            return object.toString().hashCode();
        }
    }

    private static final class HashCodeImplementationNode
    implements IHashCodeImplementation {
        private HashCodeImplementationNode() {
        }

        @Override
        public int getHashCode(Object object) {
            Node node = (Node)object;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(node).append(node.getNodeType()).append(node.getNodeName()).append(node.getLocalName()).append(node.getNamespaceURI()).append(node.getPrefix()).append(node.getNodeValue());
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            hashCodeGenerator = hashCodeGenerator.append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(nodeList.item(i));
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationAtomicBoolean
    implements IHashCodeImplementation {
        private HashCodeImplementationAtomicBoolean() {
        }

        @Override
        public int getHashCode(Object object) {
            return HashCodeCalculator.append(0, ((AtomicBoolean)object).get());
        }
    }

    private static final class HashCodeImplementationAtomicInteger
    implements IHashCodeImplementation {
        private HashCodeImplementationAtomicInteger() {
        }

        @Override
        public int getHashCode(Object object) {
            return HashCodeCalculator.append(0, ((AtomicInteger)object).get());
        }
    }

    private static final class HashCodeImplementationAtomicLong
    implements IHashCodeImplementation {
        private HashCodeImplementationAtomicLong() {
        }

        @Override
        public int getHashCode(Object object) {
            return HashCodeCalculator.append(0, ((AtomicLong)object).get());
        }
    }

    private static final class HashCodeImplementationArrayBoolean
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayBoolean() {
        }

        @Override
        public int getHashCode(Object object) {
            boolean[] blArray = (boolean[])object;
            int n = blArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(blArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationArrayByte
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayByte() {
        }

        @Override
        public int getHashCode(Object object) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(byArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationArrayChar
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayChar() {
        }

        @Override
        public int getHashCode(Object object) {
            char[] cArray = (char[])object;
            int n = cArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(cArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationArrayDouble
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayDouble() {
        }

        @Override
        public int getHashCode(Object object) {
            double[] dArray = (double[])object;
            int n = dArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(dArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationArrayFloat
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayFloat() {
        }

        @Override
        public int getHashCode(Object object) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(fArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationArrayInt
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayInt() {
        }

        @Override
        public int getHashCode(Object object) {
            int[] nArray = (int[])object;
            int n = nArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(nArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationArrayLong
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayLong() {
        }

        @Override
        public int getHashCode(Object object) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(lArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationArrayShort
    implements IHashCodeImplementation {
        private HashCodeImplementationArrayShort() {
        }

        @Override
        public int getHashCode(Object object) {
            short[] sArray = (short[])object;
            int n = sArray.length;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(object.getClass()).append(n);
            for (int i = 0; i < n; ++i) {
                hashCodeGenerator = hashCodeGenerator.append(sArray[i]);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationMap
    implements IHashCodeImplementation {
        private HashCodeImplementationMap() {
        }

        @Override
        public int getHashCode(Object object) {
            Map map = (Map)object;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(map).append(map.size());
            for (Map.Entry entry : map.entrySet()) {
                hashCodeGenerator = hashCodeGenerator.append(entry.getKey()).append(entry.getValue());
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationCollection
    implements IHashCodeImplementation {
        private HashCodeImplementationCollection() {
        }

        @Override
        public int getHashCode(Object object) {
            Collection collection = (Collection)object;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(collection).append(collection.size());
            for (Object e : collection) {
                hashCodeGenerator = hashCodeGenerator.append(e);
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationIterator
    implements IHashCodeImplementation {
        private HashCodeImplementationIterator() {
        }

        @Override
        public int getHashCode(Object object) {
            Iterator iterator = (Iterator)object;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(iterator);
            while (iterator.hasNext()) {
                hashCodeGenerator = hashCodeGenerator.append(iterator.next());
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationEnumeration
    implements IHashCodeImplementation {
        private HashCodeImplementationEnumeration() {
        }

        @Override
        public int getHashCode(Object object) {
            Enumeration enumeration = (Enumeration)object;
            HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(enumeration);
            while (enumeration.hasMoreElements()) {
                hashCodeGenerator = hashCodeGenerator.append(enumeration.nextElement());
            }
            return hashCodeGenerator.getHashCode();
        }
    }

    private static final class HashCodeImplementationFile
    implements IHashCodeImplementation {
        private HashCodeImplementationFile() {
        }

        @Override
        public int getHashCode(@Nonnull Object object) {
            File file = (File)object;
            return FilenameHelper.getCleanPath(file.getAbsoluteFile()).hashCode();
        }
    }
}

