/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Hl7InputStreamMessageStringIterator;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import ch.elexis.core.jdt.Nullable;
import ch.elexis.hl7.HL7Reader;
import ch.elexis.hl7.v26.Messages;
import ch.elexis.hl7.v2x.HL7ReaderV21;
import ch.elexis.hl7.v2x.HL7ReaderV22;
import ch.elexis.hl7.v2x.HL7ReaderV23;
import ch.elexis.hl7.v2x.HL7ReaderV231;
import ch.elexis.hl7.v2x.HL7ReaderV24;
import ch.elexis.hl7.v2x.HL7ReaderV25;
import ch.elexis.hl7.v2x.HL7ReaderV251;
import ch.elexis.hl7.v2x.HL7ReaderV26;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HL7ReaderFactory {
    INSTANCE;

    protected List<Message> messageList;
    private static Logger logger;

    static {
        logger = LoggerFactory.getLogger(HL7ReaderFactory.class);
    }

    public List<HL7Reader> getReader(File file) throws IOException {
        this.checkClassLoader();
        this.messageList = new ArrayList<Message>();
        return this.load(file);
    }

    @Nullable
    public HL7Reader getReader(String message) throws IOException {
        this.checkClassLoader();
        this.messageList = new ArrayList<Message>();
        try {
            return this.loadMessage(message);
        }
        catch (HL7Exception e) {
            throw new IOException(String.valueOf(HL7Exception.class.getName()) + ": " + e.getMessage());
        }
    }

    private List<HL7Reader> load(File file) throws IOException {
        if (!file.canRead()) {
            throw new IOException(MessageFormat.format(Messages.HL7Reader_CannotReadFile, file.getAbsolutePath()));
        }
        ArrayList<HL7Reader> ret = new ArrayList<HL7Reader>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = this.getFileInputStream(file);){
                Hl7InputStreamMessageStringIterator stringIterator = new Hl7InputStreamMessageStringIterator(inputStream);
                PipeParser p = new PipeParser();
                p.setValidationContext((ValidationContext)new NoValidation());
                while (stringIterator.hasNext()) {
                    String next = stringIterator.next();
                    next = this.assureSaveMessage(next);
                    Message hl7Message = p.parse(next);
                    this.messageList.add(hl7Message);
                    ret.add(this.getReaderForMessage(hl7Message));
                }
                return ret;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    private void checkClassLoader() {
        ClassLoader parserLoader;
        ClassLoader modelLoader = GenericMessage.V23.class.getClassLoader();
        if (modelLoader != (parserLoader = Parser.class.getClassLoader())) {
            throw new IllegalStateException("Model and Parser loaded by different ClassLoader");
        }
    }

    private InputStream getFileInputStream(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        CharsetDetector detector = new CharsetDetector();
        detector.setText(bytes);
        CharsetMatch match = detector.detect();
        if (match != null) {
            if (match.getName().contains("IBM424")) {
                logger.warn("Reading HL7 file " + file.getAbsolutePath() + " with unsupported encoding " + match.getName() + " - trying to use ISO-8859-1 instead");
                return new ByteArrayInputStream(new String(bytes, "ISO-8859-1").getBytes());
            }
            logger.info("Reading HL7 file " + file.getAbsolutePath() + " encoded " + match.getName() + " language " + match.getLanguage());
            return new ByteArrayInputStream(match.getString().getBytes());
        }
        return new ByteArrayInputStream(bytes);
    }

    private String assureSaveMessage(String hl7Message) {
        String ret = this.assureSaveMSH9Access(hl7Message);
        ret = this.assureSaveORC(ret);
        return ret;
    }

    private String[] getLines(String hl7Message) {
        String separator = "\r";
        String[] splitted = hl7Message.split(separator);
        if (splitted.length < 2) {
            separator = "\n";
            splitted = hl7Message.split(separator);
        }
        int i = 0;
        while (i < splitted.length) {
            splitted[i] = splitted[i].replaceAll("\n", "");
            ++i;
        }
        return splitted;
    }

    private int getIndexOfSegment(String[] splittedMessage, String segmentStart) {
        int index = 0;
        boolean found = false;
        while (index < splittedMessage.length) {
            if (splittedMessage[index].startsWith(segmentStart)) {
                found = true;
                break;
            }
            ++index;
        }
        return found ? index : -1;
    }

    private String assureSaveORC(String hl7Message) {
        String[] splitted = this.getLines(hl7Message);
        if (splitted.length < 2) {
            throw new IllegalArgumentException("Could not split message");
        }
        ArrayList<String> splittedList = new ArrayList<String>(Arrays.asList(splitted));
        String[] mshPart = splitted[0].split("\\|", -1);
        if (mshPart[8].contains("OUL^R22")) {
            int orcIndex = this.getIndexOfSegment(splitted, "ORC|");
            int obrIndex = this.getIndexOfSegment(splitted, "OBR|");
            if (orcIndex > 0 && obrIndex > 0 && orcIndex < obrIndex) {
                Collections.swap(splittedList, orcIndex, obrIndex);
            }
        }
        return this.joinStrings(splittedList.toArray(new String[splittedList.size()]), "\r\n");
    }

    private String assureSaveMSH9Access(String hl7Message) {
        String[] splitted = this.getLines(hl7Message);
        if (splitted.length < 2) {
            throw new IllegalArgumentException("Could not split message");
        }
        String[] mshPart = splitted[0].split("\\|", -1);
        if (!(mshPart[8].equals("ORU^R01") || mshPart[11].startsWith("2.5") || mshPart[11].startsWith("2.6"))) {
            mshPart[8] = "ORU^R01";
            splitted[0] = this.joinStrings(mshPart, "|");
        }
        if (mshPart[11].equals("2.3.2")) {
            mshPart[11] = "2.3";
            splitted[0] = this.joinStrings(mshPart, "|");
        }
        if (mshPart[11].equals("2.2")) {
            int i = 0;
            while (i < splitted.length) {
                String[] obxPart;
                if (splitted[i].startsWith("OBX") && (obxPart = splitted[i].split("\\|", -1))[2].equals("SN")) {
                    obxPart[2] = "NM";
                    splitted[i] = this.joinStrings(obxPart, "|");
                }
                ++i;
            }
        }
        if (mshPart[11].equals("2.7.1")) {
            mshPart[11] = "2.6";
            splitted[0] = this.joinStrings(mshPart, "|");
        }
        return this.joinStrings(splitted, "\r\n");
    }

    private String joinStrings(String[] array, String separator) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (builder.length() != 0) {
                builder.append(separator);
            }
            builder.append(s);
            ++n2;
        }
        return builder.toString();
    }

    private HL7Reader loadMessage(String message) throws HL7Exception {
        PipeParser p = new PipeParser();
        p.setValidationContext((ValidationContext)new NoValidation());
        Message hl7Msg = p.parse(message);
        this.messageList.add(hl7Msg);
        return this.getReaderForMessage(hl7Msg);
    }

    private HL7Reader getReaderForMessage(Message message) {
        String version = message.getVersion();
        if (version.equals("2.1")) {
            return new HL7ReaderV21(message);
        }
        if (version.equals("2.2")) {
            return new HL7ReaderV22(message);
        }
        if (version.equals("2.3")) {
            return new HL7ReaderV23(message);
        }
        if (version.equals("2.3.1")) {
            return new HL7ReaderV231(message);
        }
        if (version.equals("2.4")) {
            return new HL7ReaderV24(message);
        }
        if (version.equals("2.5")) {
            return new HL7ReaderV25(message);
        }
        if (version.equals("2.5.1")) {
            return new HL7ReaderV251(message);
        }
        if (version.equals("2.6")) {
            return new HL7ReaderV26(message);
        }
        return null;
    }
}

