/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.handler;

import ch.elexis.core.data.events.ElexisEvent;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.findings.IFinding;
import ch.elexis.core.findings.ui.dialogs.FindingsEditDialog;
import ch.elexis.core.model.IPersistentObject;
import ch.elexis.core.ui.locks.AcquireLockBlockingUi;
import ch.elexis.core.ui.locks.ILockHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class FindingEditHandler
extends AbstractHandler
implements IHandler {
    public static final String COMMAND_ID = "ch.elexis.core.findings.ui.commandEdit";
    private Boolean ret;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object item;
        this.ret = Boolean.FALSE;
        ISelection selection = this.getSelection(event);
        if (selection instanceof StructuredSelection && !((StructuredSelection)selection).isEmpty() && (item = ((StructuredSelection)selection).getFirstElement()) instanceof IFinding) {
            final IFinding iFinding = (IFinding)item;
            AcquireLockBlockingUi.aquireAndRun((IPersistentObject)((IPersistentObject)iFinding), (ILockHandler)new ILockHandler(){

                public void lockFailed() {
                }

                public void lockAcquired() {
                    FindingsEditDialog findingsEditDialog = new FindingsEditDialog(Display.getDefault().getActiveShell(), iFinding);
                    int dialogRet = findingsEditDialog.open();
                    findingsEditDialog.releaseAllLocks();
                    if (dialogRet == 0) {
                        ElexisEventDispatcher.getInstance().fire(new ElexisEvent[]{new ElexisEvent((IPersistentObject)iFinding, IFinding.class, 8)});
                        FindingEditHandler.this.ret = Boolean.TRUE;
                    }
                }
            });
        }
        return this.ret;
    }

    private ISelection getSelection(ExecutionEvent executionEvent) {
        ISelection selection = null;
        if (executionEvent.getTrigger() != null) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        } else {
            IEclipseContext iEclipseContext = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
            selection = (StructuredSelection)iEclipseContext.get(COMMAND_ID.concat(".selection"));
            iEclipseContext.remove(COMMAND_ID.concat(".selection"));
        }
        return selection;
    }
}

