/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.findings.ui.dialogs;

import ch.elexis.core.findings.ICoding;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class VisibleCodingsSelectionDialog
extends TitleAreaDialog {
    private List<ICoding> available;
    private CheckboxTableViewer viewer;
    private List<ICoding> selected;

    public VisibleCodingsSelectionDialog(Shell parentShell, List<ICoding> available) {
        super(parentShell);
        this.available = available;
    }

    public void create() {
        super.create();
        this.setTitle("Sichtbare Befunde Codes ausw\u00e4hlen.");
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)new GridData(1808));
        ret.setLayout((Layout)new FillLayout());
        Table table = new Table(ret, 34);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                ICoding iCoding = (ICoding)element;
                return iCoding != null ? String.valueOf(iCoding.getDisplay()) + " (" + iCoding.getCode() + ")" : "";
            }
        });
        this.viewer.setInput(this.available);
        for (ICoding iCoding : this.selected) {
            this.viewer.setChecked((Object)iCoding, true);
        }
        return ret;
    }

    protected void okPressed() {
        this.selected = Arrays.asList(this.viewer.getCheckedElements()).stream().map(c -> (ICoding)c).collect(Collectors.toList());
        super.okPressed();
    }

    public void setSelected(List<ICoding> selected) {
        this.selected = selected;
    }

    public List<ICoding> getSelected() {
        return this.selected;
    }
}

