/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.Log;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.IllegalAddException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XML2Database {
    protected static Log log = Log.get((String)XML2Database.class.getName());
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String LIST_TAG = "DATALIST";
    private static final String UID_TAG = "UID";
    private static final String UID_VERSION_ATTRIBUTE = "version";
    private static final String CLASS_ATTRIBUTE = "javaclass";
    private static final String TEXT_TAG = "#text";
    private HashMap<Class, HashMap<String, List<String>>> cache = new HashMap();

    private List<String> getValues(Class javaClass, String uidValue) {
        HashMap<String, List<String>> map = this.cache.get(javaClass);
        if (map == null) {
            map = new HashMap();
            this.cache.put(javaClass, map);
            Query query = new Query(javaClass);
            List poList = query.execute();
            for (PersistentObject po : poList) {
                String value = po.getExportUIDValue();
                List<String> idList = map.get(value);
                if (idList == null) {
                    idList = new Vector<String>();
                    map.put(value, idList);
                }
                idList.add(po.getId());
            }
        }
        return map.get(uidValue);
    }

    private void importData(Node tableNode, boolean overwrite) {
        try {
            String className = tableNode.getAttributes().getNamedItem(CLASS_ATTRIBUTE).getNodeValue();
            Class<?> javaClass = Class.forName(className);
            String uidValue = null;
            String uidVersion = "";
            Vector<DataField> fieldList = new Vector<DataField>();
            NodeList nodeList = tableNode.getChildNodes();
            int index = 0;
            while (index < nodeList.getLength()) {
                Node fieldNode = nodeList.item(index);
                if (!TEXT_TAG.equals(fieldNode.getNodeName())) {
                    if (UID_TAG.equals(fieldNode.getNodeName())) {
                        uidValue = fieldNode.getTextContent();
                        if (fieldNode.getAttributes().getNamedItem(UID_VERSION_ATTRIBUTE) == null) {
                            throw new IllegalArgumentException("No UID export version found!");
                        }
                        uidVersion = fieldNode.getAttributes().getNamedItem(UID_VERSION_ATTRIBUTE).getNodeValue();
                    } else {
                        fieldList.add(new DataField(fieldNode.getNodeName(), fieldNode.getTextContent()));
                    }
                }
                ++index;
            }
            String[] fields = new String[fieldList.size()];
            String[] results = new String[fieldList.size()];
            int i = 0;
            while (i < fieldList.size()) {
                fields[i] = ((DataField)fieldList.get((int)i)).name;
                results[i] = ((DataField)fieldList.get((int)i)).value;
                ++i;
            }
            Constructor<?> constructor = javaClass.getDeclaredConstructor(new Class[0]);
            PersistentObject po = (PersistentObject)constructor.newInstance(new Object[0]);
            if (!uidVersion.equals(po.getExportUIDVersion())) {
                throw new IllegalArgumentException("UID export versions are different!");
            }
            List<String> list = this.getValues(javaClass, uidValue);
            if (list == null || list.size() == 0) {
                po.create(null);
                po.set(fields, results);
            } else if (overwrite) {
                for (String idValue : list) {
                    Constructor<?> tmpConstr = javaClass.getDeclaredConstructor(String.class);
                    PersistentObject tmpPo = (PersistentObject)tmpConstr.newInstance(idValue);
                    System.out.println("Name: " + tmpPo.get("Name"));
                    tmpPo.set(fields, results);
                }
            }
        }
        catch (Exception e) {
            log.log(e.getMessage(), 2);
        }
    }

    private Document readXmlDocument(InputSource is, String docDescription) throws SAXException, ParserConfigurationException, IOException {
        if (is == null) {
            return null;
        }
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(is);
    }

    private void importXML(String xml, boolean overwrite) {
        try {
            Document document = this.readXmlDocument(new InputSource(new StringReader(xml)), "Import");
            NodeList rootNodeList = document.getChildNodes();
            int rootIndex = 0;
            while (rootIndex < rootNodeList.getLength()) {
                Node rootNode = rootNodeList.item(rootIndex);
                if (LIST_TAG.equals(rootNode.getNodeName())) {
                    NodeList nodeList = rootNode.getChildNodes();
                    int i = 0;
                    while (i < nodeList.getLength()) {
                        Node tableNode = nodeList.item(i);
                        if (!TEXT_TAG.equals(tableNode.getNodeName()) && tableNode.getAttributes() != null) {
                            this.importData(tableNode, overwrite);
                        }
                        ++i;
                    }
                } else {
                    this.importData(rootNode, overwrite);
                }
                ++rootIndex;
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void importData(String data, boolean overwrite) {
        new XML2Database().importXML(data, overwrite);
    }

    public static String exportData(PersistentObject object) {
        StringBuffer buffer = new StringBuffer(HEADER);
        buffer.append(new XMLObject(object).exportData());
        return buffer.toString();
    }

    public static String exportData(List<? extends PersistentObject> dataList) {
        StringBuffer buffer = new StringBuffer(HEADER);
        buffer.append("<DATALIST>\n");
        for (PersistentObject persistentObject : dataList) {
            buffer.append(new XMLObject(persistentObject).exportData());
        }
        buffer.append("</DATALIST>\n");
        return buffer.toString();
    }

    private static class DataField {
        final String name;
        final String value;

        public DataField(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class XMLObject {
        private PersistentObject object = null;
        private StringBuffer buffer = new StringBuffer();
        private final Stack<String> stack = new Stack();
        private boolean elementOpened = false;

        private XMLObject(PersistentObject object) {
            this.object = object;
        }

        private void openElement(String name) {
            if (this.elementOpened) {
                this.writeCloseSign(true);
            }
            this.addTab();
            this.buffer.append("<" + name);
            this.elementOpened = true;
            this.stack.push(name);
        }

        private void writeCloseSign(boolean newLine) {
            this.buffer.append(">");
            if (newLine) {
                this.buffer.append("\n");
            }
            this.elementOpened = false;
        }

        private void addTab() {
            int i = 0;
            while (i < this.stack.size()) {
                this.buffer.append("\t");
                ++i;
            }
        }

        private void closeElement() {
            if (this.elementOpened) {
                this.writeCloseSign(true);
                this.stack.pop();
            } else if (!this.stack.isEmpty()) {
                String name = this.stack.pop();
                this.buffer.append("</" + name + ">\n");
            }
        }

        private void addAttribute(String attribute, String value) {
            if (!this.elementOpened) {
                throw new IllegalAddException("");
            }
            this.buffer.append(" " + attribute + "=\"" + value + "\"");
        }

        private void addValue(String value) {
            if (this.elementOpened) {
                this.writeCloseSign(false);
            }
            this.buffer.append(value);
        }

        private String exportData() {
            String[] fieldList = this.object.getExportFields();
            String[] resultList = new String[fieldList.length];
            this.object.get(fieldList, resultList);
            this.openElement(this.object.getTableName());
            this.addAttribute(XML2Database.CLASS_ATTRIBUTE, this.object.getClass().getName());
            this.openElement(XML2Database.UID_TAG);
            this.addAttribute(XML2Database.UID_VERSION_ATTRIBUTE, this.object.getExportUIDVersion());
            this.addValue(this.object.getExportUIDValue());
            this.closeElement();
            int i = 0;
            while (i < fieldList.length) {
                String name = fieldList[i];
                String value = resultList[i];
                this.openElement(name);
                this.addValue(value);
                this.closeElement();
                ++i;
            }
            this.closeElement();
            return this.buffer.toString();
        }
    }
}

