/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.data;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Anwender;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.net.NetTool;

public class DBLog
extends PersistentObject {
    private static final String TABLENAME = "LOGS";

    static {
        DBLog.addMapping(TABLENAME, "OID", "Datum=S:D:datum", "typ", "userID", "station", "ExtInfo");
    }

    public DBLog(PersistentObject obj, TYP typ) {
        String oid;
        this.create(null);
        if (typ == null) {
            typ = TYP.UNKNOWN;
        }
        String user = "?";
        if (CoreHub.actUser != null) {
            user = CoreHub.actUser.getId();
        }
        String hostname = "?";
        if (NetTool.hostname != null) {
            hostname = NetTool.hostname;
        }
        if ((oid = obj.storeToString()) == null) {
            oid = obj.getId();
        }
        this.set(new String[]{"OID", "Datum", "typ", "userID", "station"}, oid, new TimeTool().toString(4), typ.name(), user, hostname);
    }

    public static DBLog load(String id) {
        return new DBLog(id);
    }

    protected DBLog(String id) {
        super(id);
    }

    protected DBLog() {
    }

    public Anwender getAnwender() {
        String aid = DBLog.checkNull(this.get("userID"));
        Anwender an = Anwender.load(aid);
        return an;
    }

    public String getTimeStamp() {
        long up = this.getLastUpdate();
        TimeTool ts = new TimeTool(up);
        return ts.toString(0);
    }

    public String getWorkstation() {
        return DBLog.checkNull(this.get("station"));
    }

    public String getType() {
        return DBLog.checkNull(this.get("typ"));
    }

    public PersistentObject getObject() {
        String oid = this.getObjectID();
        PersistentObject ret = CoreHub.poFactory.createFromString(oid);
        return ret;
    }

    public String getObjectID() {
        return DBLog.checkNull(this.get("OID"));
    }

    @Override
    public String getLabel() {
        return "DB-Log";
    }

    @Override
    protected String getTableName() {
        return TABLENAME;
    }

    public static enum TYP {
        DELETE,
        UNDELETE,
        UNKNOWN;

    }
}

