/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.admin;

import ch.elexis.admin.ACE;
import ch.elexis.admin.AbstractAccessControl;
import ch.elexis.admin.AccessControlDefaults;
import ch.elexis.admin.Messages;
import ch.elexis.core.constants.StringConstants;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Anwender;
import ch.elexis.data.NamedBlob;
import ch.elexis.data.Role;
import ch.elexis.data.User;
import ch.rgw.io.InMemorySettings;
import ch.rgw.io.Settings;
import ch.rgw.tools.Log;
import ch.rgw.tools.StringTool;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessControlImpl
extends AbstractAccessControl {
    public static final String KEY_GROUPS = "Groups";
    public static final String DB_UID = "dbUID";
    private static final boolean FORCE_ADMIN = false;
    public static final String ALL_GROUP = StringConstants.ROLE_ALL;
    public static final String USER_GROUP = StringConstants.ROLE_USERS;
    public static final String ADMIN_GROUP = StringConstants.ROLE_ADMIN;
    public static final String GROUP_FOR_PREFERENCEPAGE = "ch.elexis.preferences.acl";
    private static final String BLOBNAME = "AccessControl";
    private static final String ACLNAME = "AccessControlACL";
    private static Hashtable<String, ACE> rights;
    private static Hashtable<String, List<String>> usergroups;
    private static Hashtable<String, ACE> acls;
    private static final Log log;

    static {
        log = Log.get((String)BLOBNAME);
    }

    public void load() {
        NamedBlob rset = NamedBlob.load(BLOBNAME);
        if (rset == null) {
            log.log("Warnung: ACEs nicht gefunden, erstelle neu ", 2);
            NamedBlob.createTable();
            rset = NamedBlob.load(BLOBNAME);
        }
        NamedBlob aclset = NamedBlob.load(ACLNAME);
        rights = rset.getHashtable();
        System.out.println("========= RIGHTS");
        rights.keySet().stream().forEach(k -> {
            ACE ace = rights.get(k);
            System.out.println(String.valueOf(k) + ": " + ace.getCanonicalName());
        });
        acls = aclset.getHashtable();
        if (rights.isEmpty() || acls.isEmpty()) {
            this.reset();
        }
        System.out.println("========= ACLS");
        acls.keySet().stream().forEach(k -> {
            ACE ace = acls.get(k);
            System.out.println(String.valueOf(k) + ": " + ace.getCanonicalName());
        });
        usergroups = new Hashtable();
        log.log("loaded AccessControl", 4);
        for (String k1 : rights.keySet()) {
            log.log(k1, 5);
        }
        log.log("loaded ACLs", 4);
        for (String k1 : acls.keySet()) {
            log.log(k1, 5);
        }
    }

    @Override
    public void flush() {
        NamedBlob.load(BLOBNAME).put(rights);
        NamedBlob.load(ACLNAME).put(acls);
    }

    @Override
    public boolean request(ACE right) {
        return this.request(CoreHub.actUser, right);
    }

    public boolean request(Anwender user, ACE rightACE) {
        if (rightACE == null) {
            return true;
        }
        String right = rightACE.getCanonicalName();
        if (rights == null) {
            return false;
        }
        if (rights.get(String.valueOf(Messages.AccessControl_GroupAll) + right) != null) {
            return true;
        }
        if (user == null) {
            return false;
        }
        if (rights.get("Self" + right) != null && CoreHub.actUser.getId().equals(user.getId())) {
            return true;
        }
        if (rights.get(String.valueOf(user.getId()) + right) != null) {
            return true;
        }
        List<String> list = usergroups.get(String.valueOf(user.getId()) + "#groups#");
        if (list == null) {
            String grp;
            list = new ArrayList<String>();
            Map h = user.getMap("ExtInfo");
            if (h != null && (grp = (String)h.get(KEY_GROUPS)) != null) {
                String[] grps;
                String[] stringArray = grps = grp.split(",");
                int n = grps.length;
                int n2 = 0;
                while (n2 < n) {
                    String g = stringArray[n2];
                    list.add(g);
                    ++n2;
                }
                usergroups.put(String.valueOf(user.getId()) + "#groups#", list);
            }
        }
        for (String g : list) {
            if (ADMIN_GROUP.equals(g)) {
                return true;
            }
            if (rights.get(String.valueOf(g) + right) == null) continue;
            return true;
        }
        ACE parent = rightACE.getParent();
        if (parent != null) {
            return this.request(user, parent);
        }
        return false;
    }

    public void grant(Anwender user, ACE ... elements) {
        ACE[] aCEArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ACE right = aCEArray[n2];
            rights.put(String.valueOf(user.getId()) + right.getCanonicalName(), right);
            acls.put(right.getCanonicalName(), right);
            ++n2;
        }
    }

    public void revoke(Anwender user, ACE ... elements) {
        ACE[] aCEArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ACE right = aCEArray[n2];
            rights.remove(String.valueOf(user.getId()) + right.getCanonicalName());
            ++n2;
        }
    }

    public void grant(String group, ACE ... elements) {
        ACE[] aCEArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ACE right = aCEArray[n2];
            rights.put(String.valueOf(group) + right.getCanonicalName(), right);
            acls.put(right.getCanonicalName(), right);
            ++n2;
        }
    }

    public void revoke(String group, ACE ... elements) {
        ACE[] aCEArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ACE right = aCEArray[n2];
            rights.remove(String.valueOf(group) + right.getCanonicalName());
            ++n2;
        }
    }

    @Override
    public void grant(Role r, ACE ace) {
        r.grantAccessRight(ace);
    }

    @Override
    public void revoke(Role r, ACE ace) {
        r.revokeAccessRight(ace);
    }

    public void grantForSelf(ACE ... elements) {
        ACE[] aCEArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ACE r = aCEArray[n2];
            rights.put("Self" + r.getCanonicalName(), r);
            acls.put(r.getCanonicalName(), r);
            ++n2;
        }
    }

    public void revokeFromSelf(ACE ... strings) {
        ACE[] aCEArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            ACE e = aCEArray[n2];
            rights.remove("Self" + e.getCanonicalName());
            ++n2;
        }
    }

    public void addToGroup(String group, Anwender user) {
        String g = this.remove(group, user);
        g = String.valueOf(g) + "," + group;
        user.setInfoElement(KEY_GROUPS, g);
    }

    public void removeFromGroup(String group, Anwender user) {
        String g = this.remove(group, user);
        user.setInfoElement(KEY_GROUPS, g);
    }

    private String remove(String group, Anwender user) {
        String g = (String)user.getInfoElement(KEY_GROUPS);
        if (g != null) {
            g = g.replaceAll(user.getId(), "");
            g = g.replaceAll("\\s*,*$", "");
            return g;
        }
        return "";
    }

    public List<String> getGroups() {
        ArrayList<String> ret = new ArrayList<String>();
        String grp = CoreHub.globalCfg.get("groupNames", ADMIN_GROUP);
        String[] stringArray = grp.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ret.add(s);
            ++n2;
        }
        return ret;
    }

    public List<String> groupsForGrant(ACE rightACE) {
        ArrayList<String> ret = new ArrayList<String>();
        String right = rightACE.getCanonicalName();
        Pattern p = Pattern.compile("([a-zA-Z0-9]+)" + right);
        Enumeration<String> e = rights.keys();
        while (e.hasMoreElements()) {
            String grp;
            Anwender an;
            String k = e.nextElement();
            Matcher m = p.matcher(k);
            if (!m.matches() || (an = Anwender.load(grp = m.group(1))) != null) continue;
            ret.add(grp);
        }
        return ret;
    }

    public List<Anwender> usersForGrant(ACE rightACE) {
        ArrayList<Anwender> ret = new ArrayList<Anwender>();
        String right = rightACE.getCanonicalName();
        Pattern p = Pattern.compile("([a-zA-Z0-9]+)" + right);
        Enumeration<String> e = rights.keys();
        while (e.hasMoreElements()) {
            String grp;
            Anwender an;
            String k = e.nextElement();
            Matcher m = p.matcher(k);
            if (!m.matches() || (an = Anwender.load(grp = m.group(1))) == null || !an.exists()) continue;
            ret.add(an);
        }
        return ret;
    }

    public void deleteGrant(ACE grantACE) {
        String grant = grantACE.getCanonicalName();
        Pattern p = Pattern.compile("([a-zA-Z0-9]+)" + grant);
        Enumeration<String> e = rights.keys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            Matcher m = p.matcher(k);
            if (!m.matches()) continue;
            rights.remove(k);
        }
        acls.remove(grantACE);
    }

    public Settings asSettings() {
        return new InMemorySettings(rights);
    }

    public void reset() {
        rights.clear();
        this.grant(ALL_GROUP, AccessControlDefaults.getAlle());
        this.grant(USER_GROUP, AccessControlDefaults.getAnwender());
        acls.put(DB_UID, new ACE(ACE.ACE_ROOT, DB_UID, StringTool.unique((String)"db%id")));
        this.flush();
    }

    public String getDBUID(boolean bCreate) {
        ACE dbuid = acls.get(DB_UID);
        if (bCreate && dbuid == null) {
            dbuid = new ACE(ACE.ACE_ROOT, DB_UID, StringTool.unique((String)"db%id"));
            rights.put(DB_UID, dbuid);
            this.flush();
        }
        return dbuid.getLocalizedName();
    }

    @Override
    public boolean request(Role r, ACE ace) {
        return false;
    }

    @Override
    public boolean request(User u, ACE ace) {
        return false;
    }

    @Override
    public void grant(String s, ACE ace) {
    }

    @Override
    public boolean request(String right) {
        return false;
    }
}

