/*
 * Decompiled with CFR 0.152.
 */
package ooo.connector.example;

import com.sun.star.beans.PropertyValue;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.List;
import ooo.connector.BootstrapSocketConnector;
import ooo.connector.server.OOoServer;

public class BootstrapSocketConnectorExample {
    private static final String OOO_EXEC_FOLDER = "C:/Programme/OpenOffice.org 2.3/program/";
    private static final String TEMPLATE_FOLDER = "C:/Temp/";
    private static final String TEXT_DOCUMENT_NAME = "Text";
    private static final String FILE_URL_PREFIX = "file:///";
    private static final String TEXT_DOCUMENT_EXTENSION = ".odt";
    private static final String PDF_DOCUMENT_EXTENSION = ".pdf";

    public static void main(String[] args) {
        String textDocumentName = args.length > 0 ? args[0] : TEXT_DOCUMENT_NAME;
        String loadUrl = "file:///C:/Temp/" + textDocumentName + TEXT_DOCUMENT_EXTENSION;
        try {
            try {
                String storeUrl = "file:///C:/Temp/" + textDocumentName + "SC" + PDF_DOCUMENT_EXTENSION;
                BootstrapSocketConnectorExample.convertWithStaticConnector(loadUrl, storeUrl);
                storeUrl = "file:///C:/Temp/" + textDocumentName + "C" + PDF_DOCUMENT_EXTENSION;
                BootstrapSocketConnectorExample.convertWithConnector(loadUrl, storeUrl);
            }
            catch (NoConnectException e) {
                System.out.println("OOo is not responding");
                e.printStackTrace();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
        finally {
            System.exit(0);
        }
    }

    private static void convertWithStaticConnector(String loadUrl, String storeUrl) throws Exception, IllegalArgumentException, IOException, BootstrapException {
        XComponentContext remoteContext = BootstrapSocketConnector.bootstrap(OOO_EXEC_FOLDER);
        BootstrapSocketConnectorExample.convert(loadUrl, storeUrl, remoteContext);
    }

    private static void convertWithConnector(String loadUrl, String storeUrl) throws Exception, IllegalArgumentException, IOException, BootstrapException {
        List oooOptions = OOoServer.getDefaultOOoOptions();
        oooOptions.add("-nofirststartwizard");
        OOoServer oooServer = new OOoServer(OOO_EXEC_FOLDER, oooOptions);
        BootstrapSocketConnector bootstrapSocketConnector = new BootstrapSocketConnector(oooServer);
        XComponentContext remoteContext = bootstrapSocketConnector.connect();
        BootstrapSocketConnectorExample.convert(loadUrl, storeUrl, remoteContext);
        bootstrapSocketConnector.disconnect();
    }

    protected static void convert(String loadUrl, String storeUrl, XComponentContext remoteContext) throws IllegalArgumentException, IOException, Exception {
        XComponentLoader xcomponentloader = BootstrapSocketConnectorExample.getComponentLoader(remoteContext);
        XComponent objectDocumentToStore = xcomponentloader.loadComponentFromURL(loadUrl, "_blank", 0, new PropertyValue[0]);
        PropertyValue[] conversionProperties = new PropertyValue[]{new PropertyValue()};
        conversionProperties[0].Name = "FilterName";
        conversionProperties[0].Value = "writer_pdf_Export";
        XStorable xstorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)objectDocumentToStore);
        xstorable.storeToURL(storeUrl, conversionProperties);
    }

    private static XComponentLoader getComponentLoader(XComponentContext remoteContext) throws Exception {
        XMultiComponentFactory remoteServiceManager = remoteContext.getServiceManager();
        Object desktop = remoteServiceManager.createInstanceWithContext("com.sun.star.frame.Desktop", remoteContext);
        XComponentLoader xcomponentloader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)desktop);
        return xcomponentloader;
    }
}

