/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa4e.ui.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;

public class AsyncProgressMonitorWrapper
implements IProgressMonitor {
    private IProgressMonitor progressMonitor = null;
    private Display display = null;

    public AsyncProgressMonitorWrapper(IProgressMonitor progressMonitor, Display display) {
        assert (progressMonitor != null);
        assert (display != null);
        this.progressMonitor = progressMonitor;
        this.display = display;
    }

    public void beginTask(final String name, final int totalWork) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AsyncProgressMonitorWrapper.this.progressMonitor.beginTask(name, totalWork);
            }
        });
    }

    public void done() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AsyncProgressMonitorWrapper.this.progressMonitor.done();
            }
        });
    }

    public void internalWorked(final double work) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AsyncProgressMonitorWrapper.this.progressMonitor.internalWorked(work);
            }
        });
    }

    public boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    public void setCanceled(final boolean value) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AsyncProgressMonitorWrapper.this.progressMonitor.setCanceled(value);
            }
        });
    }

    public void setTaskName(final String name) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AsyncProgressMonitorWrapper.this.progressMonitor.setTaskName(name);
            }
        });
    }

    public void subTask(final String name) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AsyncProgressMonitorWrapper.this.progressMonitor.subTask(name);
            }
        });
    }

    public void worked(final int work) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AsyncProgressMonitorWrapper.this.progressMonitor.worked(work);
            }
        });
    }
}

