/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.search;

import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.NOAException;
import ag.ion.noa.search.ISearchResult;
import ag.ion.noa.text.TextRangeSelection;

public class ResultMatchWalker {
    private IDocument document = null;
    private ITextRange[] textRanges = null;
    private int index = -1;
    private int maxIndex = -1;

    public ResultMatchWalker(IDocument document, ISearchResult searchResult) {
        Assert.isNotNull(document, IDocument.class, this);
        Assert.isNotNull(searchResult, ISearchResult.class, this);
        this.document = document;
        this.textRanges = searchResult.getTextRanges();
        this.maxIndex = this.textRanges.length - 1;
    }

    public boolean hasNextMatch() {
        return this.maxIndex != -1 && this.index + 1 <= this.maxIndex;
    }

    public boolean nextMatch() {
        if (this.maxIndex != -1) {
            ++this.index;
            if (this.index <= this.maxIndex) {
                ITextRange textRange = this.getTextRange(this.index);
                try {
                    this.document.setSelection(new TextRangeSelection(textRange));
                    return true;
                }
                catch (NOAException nOAException) {}
            }
        }
        return false;
    }

    public boolean hasPreviousMatch() {
        return this.maxIndex != -1 && this.index - 1 >= 0;
    }

    public boolean previousMatch() {
        if (this.maxIndex != -1) {
            --this.index;
            if (this.index >= 0) {
                ITextRange textRange = this.getTextRange(this.index);
                try {
                    this.document.setSelection(new TextRangeSelection(textRange));
                    return true;
                }
                catch (NOAException nOAException) {}
            }
        }
        return false;
    }

    private ITextRange getTextRange(int index) {
        return this.textRanges[index];
    }
}

