/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.internal.script;

import ag.ion.bion.officelayer.util.Assert;
import ag.ion.noa.internal.script.Script;
import ag.ion.noa.script.IScript;
import ag.ion.noa.script.IScriptProvider;
import com.sun.star.beans.XPropertySet;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.provider.XScript;
import com.sun.star.script.provider.XScriptProvider;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.List;

public class ScriptProvider
implements IScriptProvider {
    private XScriptProvider scriptProvider = null;

    public ScriptProvider(XScriptProvider xScriptProvider) {
        Assert.isNotNull(xScriptProvider, XScriptProvider.class, this);
        this.scriptProvider = xScriptProvider;
    }

    @Override
    public IScript getScript(String type, String library, String module, String name) {
        if (type == null || library == null || name == null) {
            return null;
        }
        boolean needsModule = type.equals("Basic");
        if (needsModule && module == null) {
            return null;
        }
        IScript[] allScripts = this.getScripts(type, library);
        int i = 0;
        while (i < allScripts.length) {
            IScript script = allScripts[i];
            String moduleName = script.getModuleName();
            if (script.getName().equals(name)) {
                if (needsModule) {
                    if (moduleName != null && moduleName.equals(module)) {
                        return script;
                    }
                } else {
                    return script;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public IScript[] getScripts(String type, String library) {
        if (type == null || library == null) {
            return IScript.EMPTY_ARRAY;
        }
        return this.getScriptsInternal(type, library);
    }

    @Override
    public IScript[] getScripts(String library) {
        if (library == null) {
            return IScript.EMPTY_ARRAY;
        }
        return this.getScriptsInternal(null, library);
    }

    @Override
    public IScript[] getScripts() {
        XBrowseNode rootNode = (XBrowseNode)UnoRuntime.queryInterface(XBrowseNode.class, (Object)this.scriptProvider);
        XBrowseNode[] typeNodes = rootNode.getChildNodes();
        ArrayList list = new ArrayList();
        int i = 0;
        int n = typeNodes.length;
        while (i < n) {
            XBrowseNode typeNode = typeNodes[i];
            XBrowseNode[] libraryNodes = typeNode.getChildNodes();
            int j = 0;
            int m = libraryNodes.length;
            while (j < m) {
                XBrowseNode libraryNode = libraryNodes[j];
                this.buildScripts(list, libraryNode);
                ++j;
            }
            ++i;
        }
        return list.toArray(new IScript[list.size()]);
    }

    private IScript[] getScriptsInternal(String type, String library) {
        XBrowseNode rootNode = (XBrowseNode)UnoRuntime.queryInterface(XBrowseNode.class, (Object)this.scriptProvider);
        XBrowseNode[] typeNodes = rootNode.getChildNodes();
        ArrayList list = new ArrayList();
        int i = 0;
        int n = typeNodes.length;
        while (i < n) {
            XBrowseNode libraryNode;
            XBrowseNode typeNode = typeNodes[i];
            if ((type == null || typeNode.getName().equals(type)) && (libraryNode = this.getLibraryNode(typeNode, library)) != null) {
                this.buildScripts(list, libraryNode);
            }
            ++i;
        }
        return list.toArray(new IScript[list.size()]);
    }

    private List buildScripts(List list, XBrowseNode browseNode) {
        XBrowseNode[] scriptNodes = browseNode.getChildNodes();
        if (list == null) {
            list = new ArrayList<Script>();
        }
        int i = 0;
        int n = scriptNodes.length;
        while (i < n) {
            XBrowseNode scriptNode = scriptNodes[i];
            if (scriptNode.getType() == 0) {
                XPropertySet propertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)scriptNode);
                if (propertySet != null) {
                    try {
                        Object object = propertySet.getPropertyValue("URI");
                        String uri = object.toString();
                        XScript xScript = this.scriptProvider.getScript(uri);
                        list.add(new Script(uri, xScript));
                    }
                    catch (Throwable throwable) {}
                }
            } else {
                this.buildScripts(list, scriptNode);
            }
            ++i;
        }
        return list;
    }

    private XBrowseNode getLibraryNode(XBrowseNode typeNode, String library) {
        XBrowseNode[] libraryNodes = typeNode.getChildNodes();
        int i = 0;
        int n = libraryNodes.length;
        while (i < n) {
            XBrowseNode libraryNode = libraryNodes[i];
            if (libraryNode.getName().equals(library)) {
                return libraryNode;
            }
            ++i;
        }
        return null;
    }
}

