/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.internal.printing;

import ag.ion.bion.officelayer.document.DocumentException;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.noa.NOAException;
import ag.ion.noa.internal.printing.Printer;
import ag.ion.noa.printing.IPrintProperties;
import ag.ion.noa.printing.IPrintService;
import ag.ion.noa.printing.IPrinter;
import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XPrintable;

public class PrintService
implements IPrintService {
    private IDocument document = null;

    public PrintService(IDocument document) {
        if (document == null) {
            throw new NullPointerException("Invalid document for print service.");
        }
        this.document = document;
    }

    @Override
    public void print() throws DocumentException {
        this.print(null);
    }

    @Override
    public void print(IPrintProperties printProperties) throws DocumentException {
        try {
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.document.getXComponent());
            PropertyValue[] printOpts = null;
            if (printProperties != null) {
                printOpts = printProperties.getPages() != null ? new PropertyValue[2] : new PropertyValue[]{new PropertyValue()};
                printOpts[0].Name = "CopyCount";
                printOpts[0].Value = printProperties.getCopyCount();
                if (printProperties.getPages() != null) {
                    printOpts[1] = new PropertyValue();
                    printOpts[1].Name = "Pages";
                    printOpts[1].Value = printProperties.getPages();
                }
            } else {
                printOpts = new PropertyValue[]{};
            }
            xPrintable.print(printOpts);
        }
        catch (Throwable throwable) {
            throw new DocumentException(throwable);
        }
    }

    @Override
    public boolean isActivePrinterBusy() throws NOAException {
        try {
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.document.getXComponent());
            PropertyValue[] printerProps = xPrintable.getPrinter();
            Boolean busy = new Boolean(false);
            int i = 0;
            while (i < printerProps.length) {
                if (printerProps[i].Name.equals("IsBusy")) {
                    busy = (Boolean)printerProps[i].Value;
                }
                ++i;
            }
            return busy;
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public IPrinter getActivePrinter() throws NOAException {
        try {
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.document.getXComponent());
            PropertyValue[] printerProps = xPrintable.getPrinter();
            String name = null;
            int i = 0;
            while (i < printerProps.length) {
                if (printerProps[i].Name.equals("Name")) {
                    name = (String)printerProps[i].Value;
                }
                ++i;
            }
            return new Printer(name);
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public void setActivePrinter(IPrinter printer) throws NOAException {
        try {
            if (printer == null) {
                throw new NullPointerException("Invalid printer to be set");
            }
            XPrintable xPrintable = (XPrintable)UnoRuntime.queryInterface(XPrintable.class, (Object)this.document.getXComponent());
            PropertyValue[] printerDesc = new PropertyValue[]{new PropertyValue()};
            printerDesc[0].Name = "Name";
            printerDesc[0].Value = printer.getName();
            xPrintable.setPrinter(printerDesc);
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
    }

    @Override
    public IPrinter createPrinter(String name) throws NOAException {
        return new Printer(name);
    }
}

