/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.graphic;

import ag.ion.noa.NOAException;
import com.sun.star.text.TextContentAnchorType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class GraphicInfo {
    private static final double PIXEL_RATIO = 26.45;
    private File tmpFile = null;
    private String url = null;
    private int width = 0;
    private int height = 0;
    private short verticalAlignment = 1;
    private short horizontalAlignment = (short)2;
    private TextContentAnchorType anchor = null;

    public GraphicInfo(InputStream imageInputStream, int width, boolean widthPixel, int height, boolean heightPixel, short verticalAlignment, short horizontalAlignment, TextContentAnchorType anchor) throws NOAException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            int c;
            this.tmpFile = File.createTempFile("NOATempImage", ".noa.tmp");
            this.tmpFile.deleteOnExit();
            FileOutputStream streamOut = new FileOutputStream(this.tmpFile);
            while ((c = imageInputStream.read()) != -1) {
                streamOut.write(c);
            }
            imageInputStream.close();
            streamOut.close();
        }
        catch (Throwable throwable) {
            throw new NOAException(throwable);
        }
        String url = this.tmpFile.getAbsolutePath();
        this.init(url, width, widthPixel, height, heightPixel, verticalAlignment, horizontalAlignment, anchor);
    }

    public GraphicInfo(String url, int width, boolean widthPixel, int height, boolean heightPixel, short verticalAlignment, short horizontalAlignment, TextContentAnchorType anchor) {
        this.init(url, width, widthPixel, height, heightPixel, verticalAlignment, horizontalAlignment, anchor);
    }

    public String getUrl() {
        return this.url;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public short getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public short getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public TextContentAnchorType getAnchor() {
        return this.anchor;
    }

    public void cleanUp() {
        if (this.tmpFile != null && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
    }

    private void init(String url, int width, boolean widthPixel, int height, boolean heightPixel, short verticalAlignment, short horizontalAlignment, TextContentAnchorType anchor) {
        if (url == null || width < 1 || height < 1) {
            throw new IllegalArgumentException();
        }
        this.url = new File(url).toURI().toString();
        if (widthPixel) {
            width = (int)Math.round(Math.floor((double)width * 26.45));
        }
        this.width = width;
        if (heightPixel) {
            height = (int)Math.round(Math.floor((double)height * 26.45));
        }
        this.height = height;
        this.verticalAlignment = verticalAlignment;
        this.horizontalAlignment = horizontalAlignment;
        this.anchor = anchor;
    }
}

