/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.noa.filter;

import ag.ion.bion.officelayer.filter.IFilter;
import ag.ion.noa.filter.AbstractFilter;

public class OpenOfficeFilter
extends AbstractFilter
implements IFilter {
    public static final IFilter FILTER = new OpenOfficeFilter();

    @Override
    public String getFilterDefinition(String documentType) {
        if (documentType.equals("Text Document")) {
            return "StarOffice XML (Writer)";
        }
        if (documentType.equals("Global Document")) {
            return "writer_globaldocument_StarOffice_XML_Writer_GlobalDocument";
        }
        if (documentType.equals("Calc Document")) {
            return "StarOffice XML (Calc)";
        }
        if (documentType.equals("Draw Document")) {
            return "StarOffice XML (Draw)";
        }
        if (documentType.equals("Impress Document")) {
            return "StarOffice XML (Impress)";
        }
        if (documentType.equals("Math Document")) {
            return "StarOffice XML (Math)";
        }
        return null;
    }

    @Override
    public String getFileExtension(String documentType) {
        if (documentType == null) {
            return null;
        }
        if (documentType.equals("Text Document")) {
            return "sxw";
        }
        if (documentType.equals("Global Document")) {
            return "sxg";
        }
        if (documentType.equals("Calc Document")) {
            return "sxc";
        }
        if (documentType.equals("Draw Document")) {
            return "sxd";
        }
        if (documentType.equals("Impress Document")) {
            return "sxi";
        }
        if (documentType.equals("Math Document")) {
            return "sxm";
        }
        return null;
    }

    @Override
    public String getName(String documentType) {
        if (documentType.equals("Text Document")) {
            return "OpenOffice.org 1.0 Textdocument";
        }
        if (documentType.equals("Global Document")) {
            return "OpenOffice.org 1.0 Global Document";
        }
        if (documentType.equals("Calc Document")) {
            return "OpenOffice.org 1.0 Spreadsheet";
        }
        if (documentType.equals("Draw Document")) {
            return "OpenOffice.org 1.0 Drawing";
        }
        if (documentType.equals("Impress Document")) {
            return "OpenOffice.org 1.0 Presentation";
        }
        if (documentType.equals("Math Document")) {
            return "OpenOffice.org 1.0 Formula";
        }
        return null;
    }
}

