/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.workbench.office.editor.core;

import ag.ion.bion.officelayer.application.IOfficeApplication;
import ag.ion.bion.officelayer.application.OfficeApplicationRuntime;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class EditorCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.jsigle.noatext_jsl";
    private static EditorCorePlugin plugin;
    private ResourceBundle resourceBundle;
    private IOfficeApplication localOfficeApplication = null;
    private String librariesLocation = null;

    public EditorCorePlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("ag.ion.bion.workbench.office.editor.core.CorePluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        System.out.println();
        System.out.println("EditorCorePlugin: start(BundleContext context): About to start the " + this.toString() + " plugin.");
        System.out.println("EditorCorePlugin: start(BundleContext context): Obtaining IOfficeApplication.NOA_NATIVE_LIB_PATH...");
        System.out.println();
        System.out.println("EditorCorePlugin: ToDo: 201206262304js, 201207262255js - NOAText_jsl - containing noa-libre: ");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: In start(BundleContext context),");
        System.out.println("EditorCorePlugin: ToDo: in System.setProperty(IOfficeApplication.NOA_NATIVE_LIB_PATH,getLibrariesLocation():");
        System.out.println("EditorCorePlugin: ToDo: getLibrariesLocation() would return null, when no separate noa library was available.");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: As the noa libraries are currently located below the NOAText_jsl plugin,");
        System.out.println("EditorCorePlugin: ToDo: and have specific adoptions for Elexis, I replaced that call by an empty string.");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: (Even) when the noa libraries are not separately available, that cures these errors:");
        System.out.println("EditorCorePlugin: ToDo: 'An error occured while automatically activating bundle: ch.elexis.noatext_jsl or com.jsigle.noatext_jsl'");
        System.out.println("EditorCorePlugin: ToDo: 'Unable to create the selected preference page. ag.ion.noa4e.internal.ui.preferences.LocalOfficeApplicationPreferencesPage'");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: Also see src/ag/ion/bion/workbench/office/editor/core/EditorCorePlugin.java where this string is also hardcoded (with/without _jsl)");
        System.out.println("EditorCorePlugin: ToDo: Also see noa4e/internal/ui/preferences/LocalOfficeApplicationPreferencesPage.java where this string is also hardcoded (with/without _jsl)");
        System.out.println("EditorCorePlugin: ToDo: Also see com/jsigle/noa/NOAText.java where this string is also hardcoded (with/without _jsl)");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: A 'semi intelligent' alternative aproach would be:");
        System.out.println("EditorCorePlugin: ToDo: [if getLibrariesLocation()==null then use empty string, else use getLibrariesLocation()]");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: This might automatically use portions of an externally provided noa library file -");
        System.out.println("EditorCorePlugin: ToDo: elegant for easy updates by alternative future versions of noa, but on the other hand,");
        System.out.println("EditorCorePlugin: ToDo: that might introduce unwanted variability.");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: I may reconsider using that, once I have reviewed again the spread and implications");
        System.out.println("EditorCorePlugin: ToDo: of each specific adoption in noa for Elexis. I need to see whether a completely");
        System.out.println("EditorCorePlugin: ToDo: externally provided noa would supply everything needed for [stable] operation?.");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: If yes, I would remove everything Elexis specific adoption from the");
        System.out.println("EditorCorePlugin: ToDo: core noa (or rather: noa-libre) library that might hinder such re-separation.");
        System.out.println("EditorCorePlugin: ToDo:");
        System.out.println("EditorCorePlugin: ToDo: Several code alternatives are already included below (and commented out).");
        System.out.println();
        if (this == null) {
            System.out.println("EditorCorePlugin: start(BundleContext context): WARNING: this==null");
        } else {
            System.out.println("EditorCorePlugin: start(BundleContext context): this=" + this.toString());
        }
        if (this.getLibrariesLocation() == null) {
            System.out.println("EditorCorePlugin: start(BundleContext context): WARNING: getLibrariesLocation()==null");
        } else {
            System.out.println("EditorCorePlugin: start(BundleContext context): getLibrariesLocation()=" + this.getLibrariesLocation());
        }
        if ("noa.native.lib.path" == null) {
            System.out.println("EditorCorePlugin: start(BundleContext context): WARNING: IOfficeApplication.NOA_NATIVE_LIB_PATH==null");
        } else {
            System.out.println("EditorCorePlugin: start(BundleContext context): IOfficeApplication.NOA_NATIVE_LIB_PATH=noa.native.lib.path");
        }
        System.out.println("EditorCorePlugin:");
        System.out.println("EditorCorePlugin: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.out.println("EditorCorePlugin: !!!  Please note: If you see an error in console output below this line,    !!!");
        System.out.println("EditorCorePlugin: !!!               and the noatext_jsl plugin should not load correctly,     !!!");
        System.out.println("EditorCorePlugin: !!!               then please review the output above and the code          !!!");
        System.out.println("EditorCorePlugin: !!!               just below in EditorCorePlugin.java, which should set     !!!");
        System.out.println("EditorCorePlugin: !!!               IOfficeApplication.NOA_NATIVE_LIB_PATH to something       !!!");
        System.out.println("EditorCorePlugin: !!!               reasonable either automatically or manually.              !!!");
        System.out.println("EditorCorePlugin: !!!                                                                         !!!");
        System.out.println("EditorCorePlugin: !!!  A problem may also appear when opening a document in the plugin:       !!!");
        System.out.println("EditorCorePlugin: !!!               The document frame would remain empty, and the console    !!!");
        System.out.println("EditorCorePlugin: !!!               would show the error message: ag.ion.noa4e.ui code=4      !!!");
        System.out.println("EditorCorePlugin: !!!               Can't load library: ... nativeview.dll                    !!!");
        System.out.println("EditorCorePlugin: !!!                                                                         !!!");
        System.out.println("EditorCorePlugin: !!!  Most probably, you'll have to set a constant in getLibrariesLocation() !!!");
        System.out.println("EditorCorePlugin: !!!               to the name of your bundle, instead of ag.ion.noa         !!!");
        System.out.println("EditorCorePlugin: !!!               or com.jsigle.noatext_jsl or something alike. js          !!!");
        System.out.println("EditorCorePlugin: !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n");
        System.setProperty("noa.native.lib.path", this.getLibrariesLocation());
        System.out.println("EditorCorePlugin: *********************************************************************************************");
        System.out.println("EditorCorePlugin: Workaround to integrate OpenOffice.org window into an AWT frame on Linux: try new Frame();");
        System.out.println("EditorCorePlugin: Workaround: Apparently, this does not work any more. Now, tried it without that...");
        System.out.println("EditorCorePlugin: Workaround: ...which produces nothing different at all. No luck getting content into a frame.");
        System.out.println("EditorCorePlugin: Workaround: TO DO: WE CAN POSSIBLY DISABLE THIS PERMANENTLY. Temp reenabled it again for now.");
        System.out.println("EditorCorePlugin: Workaround: TO DO: NO, ONCE AGAIN DISABLED HERE AND IN NOAText.java as well. What happens?");
        System.out.println("EditorCorePlugin: Workaround: TO DO: Under Linux: No change, today, if both are disabled.");
        System.out.println("EditorCorePlugin: *********************************************************************************************");
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static EditorCorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = EditorCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public synchronized IOfficeApplication getManagedLocalOfficeApplication() {
        if (this.localOfficeApplication == null) {
            HashMap<String, String> configuration = new HashMap<String, String>(1);
            configuration.put("type", "local");
            try {
                this.localOfficeApplication = OfficeApplicationRuntime.getApplication(configuration);
            }
            catch (Throwable throwable) {
                Platform.getLog((Bundle)this.getBundle()).log((IStatus)new Status(4, PLUGIN_ID, 4, throwable.getMessage(), throwable));
            }
        }
        return this.localOfficeApplication;
    }

    public String getLibrariesLocation() {
        if (this.librariesLocation == null) {
            try {
                System.out.println("EditorCorePlugin: getLibrariesLocation(): ToDo: This method uses a constant string to identify the library.");
                System.out.println("EditorCorePlugin: getLibrariesLocation(): ToDo: It is set to ag.ion.noa in the original code,");
                System.out.println("EditorCorePlugin: getLibrariesLocation(): ToDo: and I have currently set this to com.jsigle.noatext_jsl");
                System.out.println("EditorCorePlugin: getLibrariesLocation(): ToDo: Instead, it should be passed as a variable, determined");
                System.out.println("EditorCorePlugin: getLibrariesLocation(): ToDo: on compile time, run-time, or configurable at run-time.");
                URL url = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
                url = FileLocator.toFileURL((URL)url);
                String bundleLocation = url.getPath();
                File file = new File(bundleLocation);
                bundleLocation = file.getAbsolutePath();
                this.librariesLocation = bundleLocation = String.valueOf(bundleLocation.replace('/', File.separatorChar)) + File.separator + "lib";
                System.out.println("EditorCorePlugin: getLibrariesLocation(): librariesLocation=" + bundleLocation);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return this.librariesLocation;
    }
}

