/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.util;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class PropertyCollection {
    private HashMap collection = null;

    public PropertyCollection() {
        this.collection = new HashMap();
    }

    public PropertyCollection(int initialCapacity) {
        this.collection = new HashMap(initialCapacity);
    }

    public PropertyCollection(int initialCapacity, float loadFactor) {
        this.collection = new HashMap(initialCapacity, loadFactor);
    }

    public void addProperty(String name, Object value) {
        this.collection.put(name, value);
    }

    public Object getPropertyValue(String name) {
        return this.collection.get(name);
    }

    public Set getPropertyNames() {
        return this.collection.keySet();
    }

    public boolean containesProperty(String name) {
        return this.collection.containsKey(name);
    }

    public static PropertyCollection getPropertyCollection(Object object) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            if (xPropertySet != null) {
                return PropertyCollection.getPropertyCollection(xPropertySet);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static PropertyCollection getPropertyCollection(XPropertySet xPropertySet) {
        try {
            XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
            Property[] property = xPropertySetInfo.getProperties();
            PropertyCollection propertyCollection = new PropertyCollection(property.length);
            int i = 0;
            while (i < property.length) {
                String name = property[i].Name;
                try {
                    propertyCollection.addProperty(name, xPropertySet.getPropertyValue(name));
                }
                catch (Exception exception) {}
                ++i;
            }
            return propertyCollection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static PropertyCollection getPropertyCollection(XPropertySet xPropertySet, String[] names) {
        try {
            if (names != null) {
                PropertyCollection propertyCollection = new PropertyCollection(names.length);
                int i = 0;
                while (i < names.length) {
                    String name = names[i];
                    try {
                        propertyCollection.addProperty(name, xPropertySet.getPropertyValue(name));
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                return propertyCollection;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setPropertyCollection(PropertyCollection propertyCollection, Object object) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            if (xPropertySet != null) {
                PropertyCollection.setPropertyCollection(propertyCollection, xPropertySet, null, null);
            }
        }
        catch (Exception exception) {}
    }

    public static void setPropertyCollection(PropertyCollection propertyCollection, Object object, String[] orderProperties) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            if (xPropertySet != null) {
                PropertyCollection.setPropertyCollection(propertyCollection, xPropertySet, orderProperties, null);
            }
        }
        catch (Exception exception) {}
    }

    public static void setPropertyCollection(PropertyCollection propertyCollection, Object object, String[] orderProperties, String[] excludeProperties) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object);
            if (xPropertySet != null) {
                PropertyCollection.setPropertyCollection(propertyCollection, xPropertySet, orderProperties, excludeProperties);
            }
        }
        catch (Exception exception) {}
    }

    public static void setPropertyCollection(PropertyCollection propertyCollection, XPropertySet xPropertySet, String[] orderProperties, String[] excludeProperties) {
        try {
            int i;
            XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
            ArrayList<String> order = null;
            ArrayList<String> exclude = null;
            if (excludeProperties != null) {
                exclude = new ArrayList<String>(excludeProperties.length);
                i = 0;
                while (i < excludeProperties.length) {
                    exclude.add(excludeProperties[i]);
                    ++i;
                }
            }
            if (orderProperties != null) {
                order = new ArrayList<String>(orderProperties.length);
                i = 0;
                while (i < orderProperties.length) {
                    try {
                        xPropertySet.setPropertyValue(orderProperties[i], propertyCollection.getPropertyValue(orderProperties[i]));
                        order.add(orderProperties[i]);
                    }
                    catch (Exception exception) {}
                    ++i;
                }
            }
            Property[] property = xPropertySetInfo.getProperties();
            int i2 = 0;
            while (i2 < property.length) {
                boolean useProperty = true;
                String name = property[i2].Name;
                if (order != null && order.contains(name)) {
                    useProperty = false;
                }
                if (exclude != null && exclude.contains(name)) {
                    useProperty = false;
                }
                if (useProperty) {
                    try {
                        if (propertyCollection.containesProperty(name)) {
                            if (name.equalsIgnoreCase("NumberFormat")) {
                                if ((Integer)propertyCollection.getPropertyValue("NumberFormat") == 256) {
                                    xPropertySet.setPropertyValue(name, (Object)new Integer(49));
                                } else {
                                    xPropertySet.setPropertyValue(name, propertyCollection.getPropertyValue(name));
                                }
                            } else {
                                xPropertySet.setPropertyValue(name, propertyCollection.getPropertyValue(name));
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i2;
            }
        }
        catch (Exception exception) {}
    }
}

