/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.text.test;

import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TextTableCellNameHelperTest
extends TestCase {
    public void testGetRowIndex() {
        int rowIndex = TextTableCellNameHelper.getRowIndex("A991");
        Assert.assertEquals((int)990, (int)rowIndex);
    }

    public void testGetColumnIndex() {
        int columnIndex = TextTableCellNameHelper.getColumnIndex("Z6");
        Assert.assertEquals((int)25, (int)columnIndex);
        columnIndex = TextTableCellNameHelper.getColumnIndex("z6");
        Assert.assertEquals((int)51, (int)columnIndex);
        columnIndex = TextTableCellNameHelper.getColumnIndex("AP6");
        Assert.assertEquals((int)67, (int)columnIndex);
        columnIndex = TextTableCellNameHelper.getColumnIndex("Az6");
        Assert.assertEquals((int)103, (int)columnIndex);
    }

    public void testGetColumnCharacter() {
        String character = TextTableCellNameHelper.getColumnCharacter(25);
        Assert.assertEquals((String)"Z", (String)character);
        character = TextTableCellNameHelper.getColumnCharacter(51);
        Assert.assertEquals((String)"z", (String)character);
        character = TextTableCellNameHelper.getColumnCharacter(77);
        Assert.assertEquals((String)"AZ", (String)character);
        character = TextTableCellNameHelper.getColumnCharacter(102);
        Assert.assertEquals((String)"Ay", (String)character);
    }

    public void testMoveRowCounterValue() {
        try {
            String cellName = TextTableCellNameHelper.moveRowCounterValue(5, "A2");
            Assert.assertEquals((String)"A7", (String)cellName);
            cellName = TextTableCellNameHelper.moveRowCounterValue(-1, "A2");
            Assert.assertEquals((String)"A1", (String)cellName);
        }
        catch (TextException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testMoveColumnIndex() {
        try {
            String cellName = TextTableCellNameHelper.moveColumnIndex(2, "A2");
            Assert.assertEquals((String)"C2", (String)cellName);
            cellName = TextTableCellNameHelper.moveColumnIndex(-1, "B2");
            Assert.assertEquals((String)"A2", (String)cellName);
        }
        catch (TextException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testGetCellRangeStartRowIndex() {
        int rowNumber = TextTableCellNameHelper.getCellRangeStartRowIndex("A2:B7");
        Assert.assertEquals((int)1, (int)rowNumber);
    }

    public void testGetCellRangeStartColumnIndex() {
        int rowNumber = TextTableCellNameHelper.getCellRangeStartColumnIndex("A2:B7");
        Assert.assertEquals((int)0, (int)rowNumber);
    }

    public void testGetCellRangeEndRowIndex() {
        int rowNumber = TextTableCellNameHelper.getCellRangeEndRowIndex("A2:B7");
        Assert.assertEquals((int)6, (int)rowNumber);
    }

    public void testGetCellRangeEndColumnIndex() {
        int rowNumber = TextTableCellNameHelper.getCellRangeEndColumnIndex("A2:B7");
        Assert.assertEquals((int)1, (int)rowNumber);
    }
}

