/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.text.test;

import ag.ion.bion.officelayer.application.LocalOfficeApplicationConfiguration;
import ag.ion.bion.officelayer.clone.CloneDestinationPosition;
import ag.ion.bion.officelayer.document.DocumentDescriptor;
import ag.ion.bion.officelayer.document.IDocument;
import ag.ion.bion.officelayer.document.IDocumentDescriptor;
import ag.ion.bion.officelayer.internal.application.LocalOfficeApplication;
import ag.ion.bion.officelayer.internal.text.TextRange;
import ag.ion.bion.officelayer.text.IParagraph;
import ag.ion.bion.officelayer.text.ITextContentEnumeration;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextRange;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import java.io.File;
import java.io.FileInputStream;
import junit.framework.TestCase;

public class IParagraphTest
extends TestCase {
    public void testGetParagraphText() {
        try {
            LocalOfficeApplication localOfficeApplication = new LocalOfficeApplication(null);
            LocalOfficeApplicationConfiguration configuration = new LocalOfficeApplicationConfiguration();
            configuration.setApplicationHomePath("/home/Sebastianr/OpenOffice.org1.1.1");
            localOfficeApplication.setConfiguration(configuration);
            localOfficeApplication.activate();
            IDocument document = localOfficeApplication.getDocumentService().loadDocument(new FileInputStream(new File("test/testTexts.sxw")), (IDocumentDescriptor)new DocumentDescriptor());
            if (document != null) {
                System.out.println("Loaded document");
                ITextDocument textDocument = (ITextDocument)document;
                ITextContentEnumeration textEnumeration = textDocument.getTextService().getText().getTextContentEnumeration();
                IParagraph[] paragraphs = textEnumeration.getParagraphs();
                ITextRange newTextRange = textDocument.getViewCursorService().getViewCursor().getStartTextRange();
                XTextCursor cursor = newTextRange.getXTextRange().getText().createTextCursor();
                cursor.gotoEnd(false);
                newTextRange = new TextRange(textDocument, (XTextRange)cursor);
                paragraphs[0].getCloneService().cloneToPosition(new CloneDestinationPosition(newTextRange, newTextRange.getClass()), true, null);
                textDocument.close();
                localOfficeApplication.deactivate();
            }
        }
        catch (Exception excep) {
            excep.printStackTrace();
        }
    }
}

