/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.text.table;

import ag.ion.bion.officelayer.text.TextException;

public class TextTableCellNameHelper {
    private TextTableCellNameHelper() {
    }

    public static int getRowIndex(String cellName) {
        if (cellName == null) {
            return -1;
        }
        char[] chars = cellName.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            if (Character.isDigit(chars[i])) {
                stringBuffer.append(chars[i]);
            }
            ++i;
        }
        try {
            return Integer.parseInt(stringBuffer.toString()) - 1;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static int getRowCounterValue(String cellName) {
        if (cellName == null) {
            return -1;
        }
        return TextTableCellNameHelper.getRowIndex(cellName) + 1;
    }

    public static int getRowCounterValue(int rowIndex) {
        return rowIndex + 1;
    }

    public static String moveRowCounterValue(int count, String cellName) throws TextException {
        int newRowCounterValue = TextTableCellNameHelper.getRowCounterValue(cellName) + count;
        if (newRowCounterValue < 1) {
            throw new TextException("The new row counter value is not valid.");
        }
        return String.valueOf(TextTableCellNameHelper.getColumnCharacter(cellName)) + newRowCounterValue;
    }

    public static String moveRowCounterValueTo(int newRowCounterValue, String cellName) throws TextException {
        if (newRowCounterValue < 0) {
            throw new TextException("The submitted row counter value is not valid.");
        }
        return String.valueOf(TextTableCellNameHelper.getColumnCharacter(cellName)) + newRowCounterValue;
    }

    public static int getColumnIndex(String cellName) {
        if (cellName == null) {
            return -1;
        }
        if (cellName.startsWith("<")) {
            cellName = cellName.substring(1);
        }
        if (cellName.endsWith(">")) {
            cellName = cellName.substring(0, cellName.length() - 1);
        }
        cellName = cellName.replaceAll("[0-9]*", "");
        int columnNumber = 0;
        int i = 0;
        while (i < cellName.length()) {
            int charAsValue = (byte)cellName.charAt(i) - 64;
            if (charAsValue < 0) break;
            if (charAsValue > 26) {
                if ((charAsValue -= 6) < 1 || charAsValue >= 53) break;
                columnNumber += TextTableCellNameHelper.int4Letter(cellName.length() - (i + 1), charAsValue);
            } else {
                columnNumber += TextTableCellNameHelper.int4Letter(cellName.length() - (i + 1), charAsValue);
            }
            ++i;
        }
        return columnNumber - 1;
    }

    private static int int4Letter(int level, int character) {
        int multiplyer = (int)Math.pow(52.0, level);
        return character *= multiplyer;
    }

    public static String getColumnCharacter(int columnIndex) {
        if (columnIndex < 26) {
            return String.valueOf((char)(columnIndex + 65));
        }
        if (columnIndex < 52) {
            return String.valueOf((char)(columnIndex + 71));
        }
        char[] chars = new char[2];
        int firstIndex = columnIndex / 52;
        chars[0] = (char)(firstIndex + 64);
        int secondIndex = columnIndex - firstIndex * 52;
        chars[1] = secondIndex < 26 ? (char)(secondIndex + 65) : (char)(secondIndex + 71);
        return String.copyValueOf(chars);
    }

    public static String getColumnCharacter(String cellName) {
        if (cellName == null) {
            return null;
        }
        char[] chars = cellName.toCharArray();
        String cellCharacters = "";
        int i = 0;
        while (i < chars.length) {
            if (Character.isDigit(chars[i])) break;
            cellCharacters = String.valueOf(cellCharacters) + chars[i];
            ++i;
        }
        return cellCharacters;
    }

    public static String moveColumnIndex(int count, String cellName) throws TextException {
        int newColumnIndex = TextTableCellNameHelper.getColumnIndex(cellName) + count;
        if (newColumnIndex < 0) {
            throw new TextException("The new column index is not valid.");
        }
        return String.valueOf(TextTableCellNameHelper.getColumnCharacter(newColumnIndex)) + TextTableCellNameHelper.getRowCounterValue(cellName);
    }

    public static String moveColumnIndexTo(int newColumnIndex, String cellName) throws TextException {
        if (newColumnIndex < 0) {
            throw new TextException("The submitted column index is not valid.");
        }
        int rowIndex = TextTableCellNameHelper.getRowCounterValue(cellName);
        return String.valueOf(TextTableCellNameHelper.getColumnCharacter(newColumnIndex)) + rowIndex;
    }

    public static int getCellRangeStartRowIndex(String range) {
        int indexRangeIndicator = range.indexOf(":");
        String cellName = range;
        if (indexRangeIndicator != -1) {
            cellName = range.substring(0, range.indexOf(":"));
        }
        return TextTableCellNameHelper.getRowIndex(cellName);
    }

    public static int getCellRangeStartColumnIndex(String range) {
        int indexRangeIndicator = range.indexOf(":");
        String cellName = range;
        if (indexRangeIndicator != -1) {
            cellName = range.substring(0, indexRangeIndicator);
        }
        return TextTableCellNameHelper.getColumnIndex(cellName);
    }

    public static int getCellRangeEndRowIndex(String range) {
        int indexRangeIndicator = range.indexOf(":");
        String cellName = range;
        if (indexRangeIndicator != -1) {
            cellName = range.substring(range.indexOf(":") + 1);
        }
        return TextTableCellNameHelper.getRowIndex(cellName);
    }

    public static int getCellRangeEndColumnIndex(String range) {
        int indexRangeIndicator = range.indexOf(":");
        String cellName = range;
        if (indexRangeIndicator != -1) {
            cellName = range.substring(range.indexOf(":") + 1);
        }
        return TextTableCellNameHelper.getColumnIndex(cellName);
    }

    public static String getNextColumnName(String columnName) {
        if (columnName.length() == 1) {
            char column = columnName.charAt(0);
            if ((column = (char)(column + '\u0001')) == '[') {
                return "a";
            }
            if (column == '{') {
                return "AA";
            }
            return String.valueOf(column);
        }
        if (columnName.length() == 2) {
            char columnPartOne = columnName.charAt(0);
            char columnPartTwo = columnName.charAt(1);
            if ((columnPartTwo = (char)(columnPartTwo + '\u0001')) == '[') {
                columnPartTwo = 'a';
            } else if (columnPartTwo == '{') {
                columnPartTwo = 'A';
                columnPartOne = (char)(columnPartOne + '\u0001');
            }
            return String.valueOf(String.valueOf(columnPartOne)) + String.valueOf(columnPartTwo);
        }
        return null;
    }

    public static String getRangeName(int startColumnIndex, int startRowIndex, int endColumnIndex, int endRowIndex) {
        return String.valueOf(TextTableCellNameHelper.getColumnCharacter(startColumnIndex)) + (startRowIndex + 1) + ":" + TextTableCellNameHelper.getColumnCharacter(endColumnIndex) + (endRowIndex + 1);
    }
}

