/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.util;

import ag.ion.bion.officelayer.internal.util.JavaNumberFormat;
import ag.ion.bion.officelayer.util.IJavaNumberFormat;
import ag.ion.bion.officelayer.util.INumberFormat;
import ag.ion.bion.officelayer.util.INumberFormatService;
import ag.ion.bion.officelayer.util.UtilException;
import com.sun.star.beans.XPropertySet;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class NumberFormat
implements INumberFormat {
    private static final String EXAMPLE_NUMBER = "-1234,12";
    private static final String EXAMPLE_PERCENT = "-123412,35%";
    private static final String EXAMPLE_CURRENCY = "-1234,12";
    private static final String EXAMPLE_SCIENTIFIC = "-1,23E+003";
    private static final String EXAMPLE_FRACTION = "-1234 10/81";
    private static final String EXAMPLE_LOGICAL = "true";
    private static final String EXAMPLE_STRING = "Text";
    private static final String EXAMPLE_UNKNOWN = "Unknown";
    private int formatKey = 0;
    private XPropertySet xPropertySet = null;
    private INumberFormatService numberFormatService = null;

    public NumberFormat(int formatKey, XPropertySet xPropertySet, INumberFormatService numberFormatService) throws IllegalArgumentException {
        if (xPropertySet == null) {
            throw new IllegalArgumentException("Submitted OpenOffice.org XPropertySet interface is not valid.");
        }
        this.formatKey = formatKey;
        this.xPropertySet = xPropertySet;
        this.numberFormatService = numberFormatService;
    }

    @Override
    public int getFormatKey() {
        return this.formatKey;
    }

    @Override
    public short getFormatType() {
        try {
            return (Short)this.xPropertySet.getPropertyValue("Type");
        }
        catch (Exception exception) {
            return 2048;
        }
    }

    @Override
    public String getExample() throws UtilException {
        short type = this.getFormatType();
        if (type == 256) {
            return this.numberFormatService.applyFormat(EXAMPLE_STRING, this);
        }
        if (type == 16) {
            return this.numberFormatService.applyFormat("-1234,12", this);
        }
        if (type == 128) {
            return this.numberFormatService.applyFormat(EXAMPLE_PERCENT, this);
        }
        if (type == 8 || type == 9) {
            return this.numberFormatService.applyFormat("-1234,12", this);
        }
        if (type == 2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String dateTimeString = simpleDateFormat.format(Calendar.getInstance().getTime());
            return this.numberFormatService.applyFormat(dateTimeString, this);
        }
        if (type == 4) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            String dateTimeString = simpleDateFormat.format(Calendar.getInstance().getTime());
            return this.numberFormatService.applyFormat(dateTimeString, this);
        }
        if (type == 6) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateTimeString = simpleDateFormat.format(Calendar.getInstance().getTime());
            return this.numberFormatService.applyFormat(dateTimeString, this);
        }
        if (type == 32) {
            return this.numberFormatService.applyFormat(EXAMPLE_SCIENTIFIC, this);
        }
        if (type == 64) {
            return this.numberFormatService.applyFormat(EXAMPLE_FRACTION, this);
        }
        if (type == 1024) {
            return this.numberFormatService.applyFormat(EXAMPLE_LOGICAL, this);
        }
        return this.numberFormatService.applyFormat(EXAMPLE_UNKNOWN, this);
    }

    @Override
    public String getFormatPattern() {
        try {
            return (String)this.xPropertySet.getPropertyValue("FormatString");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public IJavaNumberFormat getJavaNumberFormat() throws UtilException {
        return new JavaNumberFormat(this.getFormatPattern());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof INumberFormat)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getFormatType()) + "_" + this.formatKey;
    }
}

