/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.util;

import ag.ion.bion.officelayer.internal.util.JavaFormattedNumber;
import ag.ion.bion.officelayer.internal.util.JavaNumberFormatCondition;
import ag.ion.bion.officelayer.internal.util.JavaNumberFormatter;
import ag.ion.bion.officelayer.util.IJavaFormattedNumber;
import ag.ion.bion.officelayer.util.IJavaNumberFormat;
import ag.ion.bion.officelayer.util.UtilException;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class JavaNumberFormat
implements IJavaNumberFormat {
    private static final String COLOR_CYAN = "cyan";
    private static final String COLOR_MAGENTA = "magenta";
    private static final String COLOR_GREEN_EN = "green";
    private static final String COLOR_BLACK_EN = "black";
    private static final String COLOR_BLUE_EN = "blue";
    private static final String COLOR_RED_EN = "red";
    private static final String COLOR_WHITE_EN = "white";
    private static final String COLOR_YELLOW_EN = "yellow";
    private static final String COLOR_GREEN_DE = "gruen";
    private static final String COLOR_BLACK_DE = "schwarz";
    private static final String COLOR_BLUE_DE = "blau";
    private static final String COLOR_RED_DE = "rot";
    private static final String COLOR_WHITE_DE = "weiss";
    private static final String COLOR_YELLOW_DE = "gelb";
    private String formatPattern = null;
    private JavaNumberFormatterRegistry javaNumberFormatterRegistry = null;

    public JavaNumberFormat(String formatPattern) throws UtilException {
        this.formatPattern = formatPattern;
        this.javaNumberFormatterRegistry = new JavaNumberFormatterRegistry();
        StringTokenizer stringTokenizer = new StringTokenizer(formatPattern, ";");
        int counter = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            StringBuffer pattern = new StringBuffer();
            JavaNumberFormatter javaNumberFormatter = new JavaNumberFormatter();
            StringBuffer contentBefore = new StringBuffer();
            StringBuffer contentAfter = new StringBuffer();
            int i = 0;
            while (i < token.length()) {
                char character = token.charAt(i);
                boolean onlyContent = false;
                boolean appendContent = false;
                if (character == '[') {
                    StringBuffer bracketContent = new StringBuffer();
                    int j = i + 1;
                    while (j < token.length()) {
                        character = token.charAt(j);
                        if (onlyContent) {
                            if (character == '-') {
                                appendContent = false;
                            } else {
                                if (character == ']') {
                                    i = j;
                                    break;
                                }
                                if (appendContent) {
                                    if (pattern.length() == 0) {
                                        contentBefore.append(character);
                                    } else {
                                        contentAfter.append(character);
                                    }
                                }
                            }
                        }
                        if (character == '$') {
                            onlyContent = true;
                            appendContent = true;
                        } else {
                            if (character == ']') {
                                i = j;
                                if (!onlyContent) {
                                    this.analyzeBracketContent(bracketContent.toString(), javaNumberFormatter);
                                }
                                break;
                            }
                            if (!onlyContent) {
                                bracketContent.append(character);
                            }
                        }
                        ++j;
                    }
                } else if (character == '#' || character == '.' || character == ',' || character == '0') {
                    if (character == ',') {
                        pattern.append('.');
                    } else if (character == '.') {
                        pattern.append(',');
                    } else {
                        pattern.append(character);
                    }
                } else if (character != '\"' && character != '\\') {
                    if (pattern.length() == 0) {
                        contentBefore.append(character);
                    } else {
                        contentAfter.append(character);
                    }
                }
                ++i;
            }
            if (pattern.toString().length() != 0) {
                try {
                    javaNumberFormatter.setDecimalFormat(new DecimalFormat(pattern.toString()));
                    javaNumberFormatter.setContentBefore(contentBefore.toString());
                    javaNumberFormatter.setContentAfter(contentAfter.toString());
                    if (counter == 2 && javaNumberFormatter.getJavaNumberFormatCondition() == null) {
                        javaNumberFormatter.setJavaNumberFormatCondition(new JavaNumberFormatCondition("<", 0.0));
                        javaNumberFormatter.setIsNegativePattern(true);
                    }
                    this.javaNumberFormatterRegistry.addJavaNumberFormatter(javaNumberFormatter);
                }
                catch (Exception exception) {}
            }
            ++counter;
        }
        if (this.javaNumberFormatterRegistry.size() == 0) {
            throw new UtilException("No suitable pattern available.");
        }
    }

    @Override
    public IJavaFormattedNumber formatNumber(double value) throws UtilException {
        try {
            JavaNumberFormatter javaNumberFormatter = this.javaNumberFormatterRegistry.getJavaNumberFormatter(value);
            if (javaNumberFormatter != null) {
                return new JavaFormattedNumber(javaNumberFormatter.format(value), javaNumberFormatter.getTextColor());
            }
            return null;
        }
        catch (Exception exception) {
            UtilException utilException = new UtilException(exception.getMessage());
            utilException.initCause(exception);
            throw utilException;
        }
    }

    @Override
    public IJavaFormattedNumber formatNumber(String value) throws UtilException {
        double doubleValue = -1.0;
        try {
            doubleValue = Double.parseDouble(value.replace(',', '.'));
        }
        catch (Exception exception) {
            return null;
        }
        try {
            JavaNumberFormatter javaNumberFormatter = this.javaNumberFormatterRegistry.getJavaNumberFormatter(doubleValue);
            if (javaNumberFormatter != null) {
                return new JavaFormattedNumber(javaNumberFormatter.format(doubleValue), javaNumberFormatter.getTextColor());
            }
            return null;
        }
        catch (Exception exception) {
            UtilException utilException = new UtilException(exception.getMessage());
            utilException.initCause(exception);
            throw utilException;
        }
    }

    private void analyzeBracketContent(String bracketContent, JavaNumberFormatter javaNumberFormatter) {
        Color color = this.isColor(bracketContent);
        if (color != null) {
            javaNumberFormatter.setTextColor(color);
            return;
        }
        JavaNumberFormatCondition javaNumberFormatCondition = this.isJavaNumberFormatCondition(bracketContent);
        if (javaNumberFormatCondition != null) {
            javaNumberFormatter.setJavaNumberFormatCondition(javaNumberFormatCondition);
            return;
        }
    }

    private Color isColor(String bracketContent) {
        if (bracketContent.equalsIgnoreCase(COLOR_BLACK_EN) || bracketContent.equalsIgnoreCase(COLOR_BLACK_DE)) {
            return Color.BLACK;
        }
        if (bracketContent.equalsIgnoreCase(COLOR_BLUE_EN) || bracketContent.equalsIgnoreCase(COLOR_BLUE_DE)) {
            return Color.BLUE;
        }
        if (bracketContent.equalsIgnoreCase(COLOR_CYAN)) {
            return Color.CYAN;
        }
        if (bracketContent.equalsIgnoreCase(COLOR_GREEN_EN) || bracketContent.equalsIgnoreCase(COLOR_GREEN_DE)) {
            return Color.GREEN;
        }
        if (bracketContent.equalsIgnoreCase(COLOR_MAGENTA)) {
            return Color.MAGENTA;
        }
        if (bracketContent.equalsIgnoreCase(COLOR_RED_EN) || bracketContent.equalsIgnoreCase(COLOR_RED_DE)) {
            return Color.RED;
        }
        if (bracketContent.equalsIgnoreCase(COLOR_WHITE_EN) || bracketContent.equalsIgnoreCase(COLOR_WHITE_DE)) {
            return Color.WHITE;
        }
        if (bracketContent.equalsIgnoreCase(COLOR_YELLOW_EN) || bracketContent.equalsIgnoreCase(COLOR_YELLOW_DE)) {
            return Color.YELLOW;
        }
        return null;
    }

    private JavaNumberFormatCondition isJavaNumberFormatCondition(String bracketContent) {
        String operator = "";
        StringBuffer compareValue = new StringBuffer();
        int i = 0;
        while (i < bracketContent.length()) {
            char character = bracketContent.charAt(i);
            if (Character.isDigit(character)) {
                compareValue.append(character);
            } else {
                operator = String.valueOf(operator) + character;
            }
            ++i;
        }
        try {
            double value = Double.parseDouble(compareValue.toString().replace(',', '.'));
            return new JavaNumberFormatCondition(operator, value);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class JavaNumberFormatterRegistry {
        private ArrayList arrayList = new ArrayList();

        private JavaNumberFormatterRegistry() {
        }

        public void addJavaNumberFormatter(JavaNumberFormatter javaNumberFormatter) {
            this.arrayList.add(javaNumberFormatter);
        }

        public JavaNumberFormatter getJavaNumberFormatter(double value) {
            JavaNumberFormatter defaultJavaNumberFormatter = null;
            int i = 0;
            while (i < this.arrayList.size()) {
                JavaNumberFormatter javaNumberFormatter = (JavaNumberFormatter)this.arrayList.get(i);
                JavaNumberFormatCondition javaNumberFormatCondition = javaNumberFormatter.getJavaNumberFormatCondition();
                if (javaNumberFormatCondition != null) {
                    if (javaNumberFormatCondition.checkCondition(value)) {
                        return javaNumberFormatter;
                    }
                } else if (defaultJavaNumberFormatter == null) {
                    defaultJavaNumberFormatter = javaNumberFormatter;
                }
                ++i;
            }
            return defaultJavaNumberFormatter;
        }

        public int size() {
            return this.arrayList.size();
        }
    }
}

