/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.test;

import ag.ion.bion.officelayer.internal.text.table.TextTableFormula;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import ag.ion.bion.officelayer.text.table.IArgument;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TextTableFormulaTest
extends TestCase {
    public void testFormulaService1() {
        String formula = "((<A1>*(<A2>+<A3>)+<A4>)*<A3>+sum<A4:A7>)/(<A1|A3>)";
        double realResult = 8.6111111;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A1>", new Double(1.5));
        argumentMap.put("<A2>", new Double(2.5));
        argumentMap.put("<A3>", new Double(3.0));
        argumentMap.put("<A4>", new Double(1.0));
        argumentMap.put("<A5>", new Double(5.0));
        argumentMap.put("<A6>", new Double(3.0));
        argumentMap.put("<A7>", new Double(2.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaService2() {
        String formula = "<A1:B7>";
        double realResult = 36.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A1>", new Double(1.5));
        argumentMap.put("<A2>", new Double(2.5));
        argumentMap.put("<A3>", new Double(3.0));
        argumentMap.put("<A4>", new Double(1.0));
        argumentMap.put("<A5>", new Double(5.0));
        argumentMap.put("<A6>", new Double(3.0));
        argumentMap.put("<A7>", new Double(2.0));
        argumentMap.put("<B1>", new Double(1.5));
        argumentMap.put("<B2>", new Double(2.5));
        argumentMap.put("<B3>", new Double(3.0));
        argumentMap.put("<B4>", new Double(1.0));
        argumentMap.put("<B5>", new Double(5.0));
        argumentMap.put("<B6>", new Double(3.0));
        argumentMap.put("<B7>", new Double(2.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaService3() {
        String formula = "((<A1>*(<A2>+<A3>)+<A4>)*<A3>+sum<A4:A7>/(<A1|A3>)+20+ <A2>*<A1|A3|A7>)/2+2+ 2,5";
        double realResult = 37.722222;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A1>", new Double(1.5));
        argumentMap.put("<A2>", new Double(2.5));
        argumentMap.put("<A3>", new Double(3.0));
        argumentMap.put("<A4>", new Double(1.0));
        argumentMap.put("<A5>", new Double(5.0));
        argumentMap.put("<A6>", new Double(3.0));
        argumentMap.put("<A7>", new Double(2.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaService4() {
        String formula = "<A1|A7|A4> + sum(<A1:A7>) + <A3>*7,223";
        double realResult = 44.169;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A1>", new Double(1.5));
        argumentMap.put("<A2>", new Double(2.5));
        argumentMap.put("<A3>", new Double(3.0));
        argumentMap.put("<A4>", new Double(1.0));
        argumentMap.put("<A5>", new Double(5.0));
        argumentMap.put("<A6>", new Double(3.0));
        argumentMap.put("<A7>", new Double(2.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceRound() {
        String formula = "<A2> + <B2> RoUND <C2> + <C3> ";
        double realResult = 8.123;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.123));
        argumentMap.put("<C2>", new Double(4.0));
        argumentMap.put("<C3>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceRound2() {
        String formula = "(<A2> + <B2>) RoUND (<C2> + <C3>) ";
        double realResult = 5.123;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.123));
        argumentMap.put("<C2>", new Double(4.0));
        argumentMap.put("<C3>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceRound3() {
        String formula = "(<A2> + <B2>) RoUND 2 + <C3> ";
        double realResult = 8.12;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.123));
        argumentMap.put("<C2>", new Double(4.0));
        argumentMap.put("<C3>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceRound4() {
        String formula = "(<A2> + <B2>) RoUND <C3> round <C2> ";
        double realResult = 5.123;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.123));
        argumentMap.put("<C2>", new Double(4.0));
        argumentMap.put("<C3>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceRound5() {
        String formula = "(<A2> + <B2>) RoUND (1.234 round 2)> ";
        double realResult = 5.1;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.123));
        argumentMap.put("<C2>", new Double(4.0));
        argumentMap.put("<C3>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceRound6() {
        String formula = "<A2> * <B2> RoUND (1.234 round 2) ";
        double realResult = 6.2;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.123));
        argumentMap.put("<C2>", new Double(4.0));
        argumentMap.put("<C3>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceRound7() {
        String formula = "<A2> + <B2> RoUND <C3> round <C2> ";
        double realResult = 5.123;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.123));
        argumentMap.put("<C2>", new Double(4.0));
        argumentMap.put("<C3>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServicePercent() {
        String formula = "15 phd + <A2>";
        double realResult = 2.15;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.0));
        argumentMap.put("<C2>", new Double(4.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServicePercent2() {
        String formula = " <A2> + <B2> phd + <A2>";
        double realResult = 4.03;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(2.0));
        argumentMap.put("<B2>", new Double(3.0));
        argumentMap.put("<C2>", new Double(4.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceSqrt() {
        String formula = " sqrt<A2>";
        double realResult = 5.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(25.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceSqrt1() {
        String formula = " sqrt<A2> + <B2>";
        double realResult = 8.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(25.0));
        argumentMap.put("<B2>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceSqrt2() {
        String formula = "<C2> + sqrt<A2> * <B2>";
        double realResult = 17.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(25.0));
        argumentMap.put("<B2>", new Double(3.0));
        argumentMap.put("<C2>", new Double(2.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceSqrt3() {
        String formula = "sqrt <A2:B2>";
        double realResult = 6.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(25.0));
        argumentMap.put("<B2>", new Double(11.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServicePow() {
        String formula = "2*<C2>pow <D2>";
        double realResult = 16.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<C2>", new Double(2.0));
        argumentMap.put("<D2>", new Double(3.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMean() {
        String formula = "mean <A2>|<B2>|<C2>|<D2>|<E2>+<F2>";
        double realResult = 3.5;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMean2() {
        String formula = "mean <A2>|<B2>|<C2>|<D2>|<E2>*<F2>";
        double realResult = 8.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMean3() {
        String formula = "mean <A2>+<B2>+<C2>+<D2>+<E2>+<F2>";
        double realResult = 3.5;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMean4() {
        String formula = "mean<A2:F2>";
        double realResult = 3.5;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMean5() {
        String formula = "2 + (mean<A2:F2>) + 3";
        double realResult = 8.5;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMean6() {
        String formula = "mean (<A2>|<B2>)|<C2>|<D2>|<E2>|<F2>";
        double realResult = 3.5;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMean7() {
        String formula = "mean (<A2>|<B2>)|<C2>|<D2>|<E2>|<F2>|20";
        double realResult = 5.857143;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin() {
        String formula = "max <A2>|<B2>|<C2>|<D2>|<E2>|<F2>|<G2>";
        double realResult = 7.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin2() {
        String formula = "max(<A2>+<B2>+<C2>+<D2>+<E2>+<F2>+<G2>)";
        double realResult = 28.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin3() {
        String formula = "max<A2:G2>";
        double realResult = 7.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin4() {
        String formula = "max<A2>|<B2>|<C2>|<D2>|<E2>|<F2>+<G2>";
        double realResult = 13.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin5() {
        String formula = "max(<A2>|<B2>|<C2>|<D2>|<E2>|<F2>)+<G2>";
        double realResult = 13.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin6() {
        String formula = "max<A2>|<B2>|<C2>|<D2>|<F2>|<E2>*<G2>";
        double realResult = 42.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin7() {
        String formula = "max<A2>|<B2>|<C2>|<D2>|<E2>+<G2>+<F2>";
        double realResult = 18.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin8() {
        String formula = "max<A2:F2>|<G2>";
        double realResult = 7.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin9() {
        String formula = "min<A2:F2>|<G2>";
        double realResult = 1.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin10() {
        String formula = "min<A2:F2>|<G2> + max<A2:F2>|<G2>";
        double realResult = 8.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin11() {
        String formula = "min<A2:F2>|0";
        double realResult = 0.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin12() {
        String formula = "min<A2:F2>|9";
        double realResult = 1.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin13() {
        String formula = "max<A2:F2>|0";
        double realResult = 6.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    public void testFormulaServiceMaxMin14() {
        String formula = "max<A2:F2> | 9";
        double realResult = 9.0;
        HashMap<String, Double> argumentMap = new HashMap<String, Double>();
        argumentMap.put("<A2>", new Double(1.0));
        argumentMap.put("<B2>", new Double(2.0));
        argumentMap.put("<C2>", new Double(3.0));
        argumentMap.put("<D2>", new Double(4.0));
        argumentMap.put("<E2>", new Double(5.0));
        argumentMap.put("<F2>", new Double(6.0));
        argumentMap.put("<G2>", new Double(7.0));
        this.formula(formula, realResult, argumentMap);
    }

    private void formula(String formulaValue, double realResult, HashMap argumentMap) {
        try {
            TextTableFormula formula = new TextTableFormula(new TextTableFormulaExpression(formulaValue));
            IArgument[] arguments = formula.getArguments();
            int i = 0;
            while (i < arguments.length) {
                arguments[i].setValue(argumentMap.get(arguments[i].getName()));
                ++i;
            }
            double result = formula.calcFormula();
            Assert.assertEquals((double)result, (double)realResult, (double)0.001);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

