/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.table.ITextTableCellRangeName;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;

public class ETextTableCellRangeName
implements ITextTableCellRangeName {
    private ITextTableCellRange[] textTableCellRanges = null;
    private String rangeName = null;
    private int startColumnIndex = -1;
    private int endColumnIndex = -1;
    private int startRowIndex = -1;
    private int endRowIndex = -1;

    public ETextTableCellRangeName(ITextTableCellRange[] textTableCellRanges, int lastTable, int firstTable, int columnCount) throws IllegalArgumentException {
        if (textTableCellRanges == null) {
            throw new IllegalArgumentException("The submitted range is not valid");
        }
        if (textTableCellRanges.length == 0) {
            throw new IllegalArgumentException("The submitted range ist not valid.");
        }
        this.textTableCellRanges = textTableCellRanges;
        this.startColumnIndex = textTableCellRanges[0].getRangeName().getRangeStartColumnIndex();
        if (firstTable != 0) {
            this.startRowIndex = textTableCellRanges[0].getRangeName().getRangeStartRowIndex() + firstTable * (16384 / columnCount) - 1;
        }
        this.endColumnIndex = textTableCellRanges[textTableCellRanges.length - 1].getRangeName().getRangeEndColumnIndex();
        this.endRowIndex = lastTable != 0 ? textTableCellRanges[textTableCellRanges.length - 1].getRangeName().getRangeEndRowIndex() + lastTable * (16384 / columnCount) - 1 : textTableCellRanges[textTableCellRanges.length - 1].getRangeName().getRangeEndRowIndex();
        this.rangeName = TextTableCellNameHelper.getRangeName(this.startColumnIndex, this.startRowIndex, this.endColumnIndex, this.endRowIndex);
    }

    @Override
    public String getRangeName() {
        return this.rangeName;
    }

    @Override
    public int getRangeStartColumnIndex() {
        return this.startColumnIndex;
    }

    @Override
    public int getRangeStartRowIndex() {
        return this.startRowIndex;
    }

    @Override
    public int getRangeEndColumnIndex() {
        return this.endColumnIndex;
    }

    @Override
    public int getRangeEndRowIndex() {
        return this.endRowIndex;
    }
}

