/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.internal.text.TextTableCellName;
import ag.ion.bion.officelayer.internal.text.table.TextTableFormulaExpression;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTable;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCellReferencesService;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.extended.IETextTable;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCell;

public class ETextTableCell
implements IETextTableCell {
    private ITextTableCell tableCell = null;
    private TextTableCellName textTableCellName = null;
    private ETextTable textTable = null;
    private String cellFormula = null;

    public ETextTableCell(ITextTableCell tableCell, String cellName, IETextTable textTable) throws IllegalArgumentException {
        if (tableCell == null) {
            throw new IllegalArgumentException("The submitted cell is not valid.");
        }
        if (cellName == null) {
            throw new IllegalArgumentException("The submitted cell name is not valid.");
        }
        if (textTable == null) {
            throw new IllegalArgumentException("The submitted table management is not valid.");
        }
        if (!(textTable instanceof ETextTable)) {
            throw new IllegalArgumentException("The submitted table is not valid.");
        }
        this.tableCell = tableCell;
        this.textTable = (ETextTable)textTable;
        this.textTableCellName = new TextTableCellName(cellName);
    }

    @Override
    public TextTableCellName getName() {
        return this.textTableCellName;
    }

    @Override
    public ITextTableCell getTableCell() {
        return this.tableCell;
    }

    @Override
    public void setCellFormula(String cellFormula) throws TextException {
        this.cellFormula = cellFormula;
        TextTableFormulaExpression textTableFormulaExpression = new TextTableFormulaExpression(cellFormula);
        ETextTableCellReferencesService textTableCellReferencesService = new ETextTableCellReferencesService(textTableFormulaExpression, this.textTable);
        textTableCellReferencesService.applyModifications();
        this.tableCell.setFormula(textTableFormulaExpression.getExpression());
    }

    @Override
    public String getCellFormula() {
        return this.cellFormula;
    }
}

