/*
 * Decompiled with CFR 0.152.
 */
package ag.ion.bion.officelayer.internal.text.table.extended;

import ag.ion.bion.officelayer.clone.CloneException;
import ag.ion.bion.officelayer.clone.DestinationPosition;
import ag.ion.bion.officelayer.clone.ICloneService;
import ag.ion.bion.officelayer.internal.text.table.TextTableCellRangeName;
import ag.ion.bion.officelayer.internal.text.table.TextTablePropertyStore;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCell;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCellRange;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableCloneService;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableColumn;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableManagement;
import ag.ion.bion.officelayer.internal.text.table.extended.ETextTableRow;
import ag.ion.bion.officelayer.text.ITextDocument;
import ag.ion.bion.officelayer.text.ITextTable;
import ag.ion.bion.officelayer.text.ITextTableCell;
import ag.ion.bion.officelayer.text.ITextTableCellRange;
import ag.ion.bion.officelayer.text.ITextTableProperties;
import ag.ion.bion.officelayer.text.ITextTableRow;
import ag.ion.bion.officelayer.text.TextException;
import ag.ion.bion.officelayer.text.table.TextTableCellNameHelper;
import ag.ion.bion.officelayer.text.table.extended.IETextTable;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCell;
import ag.ion.bion.officelayer.text.table.extended.IETextTableCellRange;
import ag.ion.bion.officelayer.text.table.extended.IETextTableColumn;
import ag.ion.bion.officelayer.text.table.extended.IETextTableRow;
import ag.ion.bion.officelayer.util.ArrayUtils;
import java.util.ArrayList;

public class ETextTable
implements IETextTable {
    private ETextTableManagement textTableManagement = null;
    private ITextDocument textDocument = null;
    private int columnCount = 0;
    private int maxRowsInTable = 0;

    public ETextTable(ITextDocument textDocument, ITextTable textTable) throws IllegalArgumentException {
        if (textDocument == null) {
            throw new IllegalArgumentException("Submitted textDocument is not valid.");
        }
        if (textTable == null) {
            throw new IllegalArgumentException("Submitted table is not valid.");
        }
        this.textTableManagement = new ETextTableManagement();
        this.textDocument = textDocument;
        this.columnCount = textTable.getColumnCount();
        this.textTableManagement.addTextTable(textTable);
        this.maxRowsInTable = 16384 / this.columnCount;
    }

    @Override
    public void addRows(int count) throws TextException {
        ITextTableCellRange textTableCellRangeClone = this.textTableManagement.getLastTextTable().getCellRange(0, this.textTableManagement.getLastTextTable().getRowCount() - 1, this.columnCount - 1, this.textTableManagement.getLastTextTable().getRowCount() - 1);
        this.addRowsProperty(count, textTableCellRangeClone);
    }

    private void addRowsProperty(int count, ITextTableCellRange textTableCellRangeClone) throws TextException {
        try {
            ITextTable textTableLast = this.textTableManagement.getLastTextTable();
            int singleTableRowCount = textTableLast.getRowCount();
            if ((singleTableRowCount + count) * this.columnCount <= 16384) {
                textTableLast.addRow(count);
            } else {
                ITextTableCellRange textTableCellRangeHeaderClone = textTableLast.getCellRange(0, 0, this.columnCount - 1, 0);
                int helpRows = this.maxRowsInTable - singleTableRowCount;
                if (helpRows > 0) {
                    textTableLast.addRow(helpRows);
                }
                int helpCount = count - helpRows;
                while (helpCount > 0) {
                    int insert = helpCount;
                    TextTablePropertyStore tablePropertyStore = new TextTablePropertyStore(this.textTableManagement.getFirstTextTable());
                    if (tablePropertyStore.repeatHeadline()) {
                        ++insert;
                    }
                    if (helpCount * this.columnCount > 16384) {
                        insert = this.maxRowsInTable;
                    }
                    ITextTable textTable = this.textDocument.getTextTableService().constructTextTable(1, this.columnCount);
                    ITextTableProperties properties = textTable.getProperties();
                    properties.setRepeatHeadline(tablePropertyStore.repeatHeadline());
                    this.textDocument.getTextService().getTextContentService().insertTextContentAfter(textTable, textTableLast);
                    properties.setTableColumnSeparators(tablePropertyStore.getTableColumnSeparators());
                    DestinationPosition destinationPosition = new DestinationPosition(textTable.getCell("A1"));
                    if (tablePropertyStore.repeatHeadline()) {
                        textTableCellRangeHeaderClone.getCloneService().cloneToPositionNoReturn(destinationPosition, null);
                        destinationPosition = new DestinationPosition(textTable.getCell("A2"));
                        textTableCellRangeClone.getCloneService().cloneToPositionNoReturn(destinationPosition, false, null);
                    } else {
                        textTableCellRangeClone.getCloneService().cloneToPositionNoReturn(destinationPosition, false, null);
                    }
                    textTable.addRow(insert - 1);
                    this.textTableManagement.addTextTable(textTable);
                    helpCount -= insert;
                }
            }
        }
        catch (Exception exception) {
            TextException textException = new TextException("The row(s) could not be added.");
            textException.initCause(exception);
            throw textException;
        }
    }

    @Override
    public void addRows(int index, int count) throws TextException {
        if (this.textTableManagement.getTextTables().length == 1 && this.textTableManagement.getFirstTextTable().getRowCount() + count < this.maxRowsInTable) {
            this.textTableManagement.getFirstTextTable().addRow(index, count);
            return;
        }
        IETextTableCellRange textTableCellRange = this.getCellRange(0, index, this.columnCount - 1, this.getRowCount() - 1);
        ITextTable textTable = this.textTableManagement.getLastTextTable();
        DestinationPosition destinationPosition = new DestinationPosition(textTable);
        try {
            IETextTableCellRange cellRange;
            ITextTableCellRange cellRange2;
            ETextTableCellRange tableCellRange = (ETextTableCellRange)textTableCellRange.getCloneService().cloneToPosition(destinationPosition, null).getClonedObject();
            ITextTableCellRange[] textTableCellRanges = tableCellRange.getRanges();
            int tableNumber = this.getTableNumber(index);
            ITextTable table = this.textTableManagement.getTextTable(tableNumber);
            int rowCount = table.getRowCount() - 1;
            int rowIndex = this.getRowIndexInTable(tableNumber, index);
            this.removeTables(tableNumber + 1, this.textTableManagement.getTextTables().length - tableNumber - 1);
            ITextTableCellRange textTableCellRangeClone = table.getCellRange(0, rowIndex, this.columnCount - 1, rowIndex);
            int help = rowIndex + count - (rowCount + 1);
            if (help < 0) {
                int i = rowIndex;
                while (i <= count) {
                    cellRange2 = table.getCellRange(0, i, this.columnCount - 1, i);
                    destinationPosition = new DestinationPosition(cellRange2);
                    textTableCellRangeClone.getCloneService().cloneToPosition(destinationPosition, null);
                    ++i;
                }
                cellRange = this.getCellRange(0, index, this.columnCount - 1, index + count - 1);
                this.clearTableRange(cellRange);
                table.removeRows(rowIndex + count, rowCount - (rowIndex + count) + 1);
            } else {
                int i = rowIndex;
                while (i <= rowCount) {
                    cellRange2 = table.getCellRange(0, i, this.columnCount - 1, i);
                    destinationPosition = new DestinationPosition(cellRange2);
                    textTableCellRangeClone.getCloneService().cloneToPosition(destinationPosition, null);
                    ++i;
                }
                cellRange = this.getCellRange(0, index, this.columnCount - 1, index + (rowCount - rowIndex));
                this.clearTableRange(cellRange);
                this.addRowsProperty(help, textTableCellRangeClone);
            }
            int i = 0;
            while (i < textTableCellRanges.length) {
                this.textTableManagement.addTextTable(textTableCellRanges[i].getCell(0, 0).getTextTable());
                ++i;
            }
        }
        catch (CloneException cloneException) {
            TextException textException = new TextException("Error while cloning range");
            textException.initCause(cloneException);
            throw textException;
        }
    }

    @Override
    public void addRows(int index, int count, boolean after) throws TextException {
        this.addRows(index - 1, count);
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        int i = 0;
        while (i < textTables.length) {
            rowCount += textTables[i].getRowCount();
            ++i;
        }
        return rowCount;
    }

    @Override
    public IETextTableCell getCell(int rowIndex, int columnIndex) throws TextException {
        String cellName = String.valueOf(TextTableCellNameHelper.getColumnCharacter(columnIndex)) + TextTableCellNameHelper.getRowCounterValue(rowIndex);
        return this.getCell(cellName);
    }

    @Override
    public IETextTableCell getCell(String cellName) throws TextException {
        int rowNumber = TextTableCellNameHelper.getRowIndex(cellName);
        int tableNumber = this.getTableNumber(rowNumber);
        int help = 0;
        int i = 0;
        while (i < tableNumber) {
            help += this.textTableManagement.getTextTable(i).getRowCount();
            ++i;
        }
        rowNumber = rowNumber - help + 1;
        ITextTableCell textTableCell = this.textTableManagement.getTextTable(tableNumber).getCell(String.valueOf(TextTableCellNameHelper.getColumnCharacter(cellName)) + rowNumber);
        ETextTableCell tableCell = new ETextTableCell(textTableCell, cellName, this);
        return tableCell;
    }

    @Override
    public IETextTableCellRange getCellRange(int firstColumnIndex, int firstRowIndex, int lastColumnIndex, int lastRowIndex) throws TextException {
        int firstTableNumber = this.getTableNumber(firstRowIndex);
        int lastTableNumber = this.getTableNumber(lastRowIndex);
        ArrayList<ITextTableCellRange> textTableCellRanges = new ArrayList<ITextTableCellRange>();
        if (firstTableNumber == lastTableNumber) {
            textTableCellRanges.add(this.textTableManagement.getTextTable(firstTableNumber).getCellRange(firstColumnIndex, this.getRowIndexInTable(firstTableNumber, firstRowIndex), lastColumnIndex, this.getRowIndexInTable(firstTableNumber, lastRowIndex)));
        } else {
            ITextTable textTable = this.textTableManagement.getTextTable(firstTableNumber);
            textTableCellRanges.add(textTable.getCellRange(firstColumnIndex, this.getRowIndexInTable(firstTableNumber, firstRowIndex), lastColumnIndex, textTable.getRowCount() - 1));
            int i = firstTableNumber + 1;
            while (i < lastTableNumber) {
                textTable = this.textTableManagement.getTextTable(i);
                textTableCellRanges.add(textTable.getCellRange(firstColumnIndex, 0, lastColumnIndex, textTable.getRowCount() - 1));
                ++i;
            }
            textTable = this.textTableManagement.getTextTable(lastTableNumber);
            textTableCellRanges.add(textTable.getCellRange(firstColumnIndex, 0, lastColumnIndex, this.getRowIndexInTable(lastTableNumber, lastRowIndex)));
        }
        ITextTableCellRange[] tableCellRanges = new ITextTableCellRange[textTableCellRanges.size()];
        tableCellRanges = textTableCellRanges.toArray(tableCellRanges);
        TextTableCellRangeName tableCellRangeName = new TextTableCellRangeName(firstColumnIndex, firstRowIndex, lastColumnIndex, lastRowIndex);
        ETextTableCellRange tableCellRange = new ETextTableCellRange(tableCellRanges, tableCellRangeName, this);
        return tableCellRange;
    }

    @Override
    public IETextTableCellRange getCellRange(String rangeName) throws TextException {
        int firstColumnIndex = TextTableCellNameHelper.getCellRangeStartColumnIndex(rangeName);
        int firstRowIndex = TextTableCellNameHelper.getCellRangeStartRowIndex(rangeName);
        int lastColumnIndex = TextTableCellNameHelper.getCellRangeEndColumnIndex(rangeName);
        int lastRowIndex = TextTableCellNameHelper.getCellRangeEndRowIndex(rangeName);
        return this.getCellRange(firstColumnIndex, firstRowIndex, lastColumnIndex, lastRowIndex);
    }

    @Override
    public IETextTableColumn getColumn(int columnIndex) throws TextException {
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        if (textTables.length > 0) {
            ETextTableColumn textTableColumn = new ETextTableColumn(this);
            int j = 0;
            while (j < textTables.length) {
                ITextTable textTable = textTables[j];
                if (textTableColumn == null) {
                    textTableColumn = new ETextTableColumn(this);
                }
                textTableColumn.addTextTableColum(textTable.getColumn(columnIndex));
                ++j;
            }
            return textTableColumn;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        if (this.textTableManagement.getFirstTextTable() == null) {
            return 0;
        }
        return this.textTableManagement.getFirstTextTable().getColumnCount();
    }

    @Override
    public IETextTableColumn[] getColumns() throws TextException {
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        if (textTables.length > 0) {
            IETextTableColumn[] textTableColumns = new ETextTableColumn[textTables[0].getColumnCount()];
            int j = 0;
            while (j < textTables.length) {
                ITextTable textTable = textTables[j];
                int i = 0;
                while (i < textTable.getColumnCount()) {
                    if (textTableColumns[i] == null) {
                        textTableColumns[i] = new ETextTableColumn(this);
                    }
                    ((ETextTableColumn)textTableColumns[i]).addTextTableColum(textTable.getColumn(i));
                    ++i;
                }
                ++j;
            }
            return textTableColumns;
        }
        return null;
    }

    @Override
    public ITextTableProperties[] getProperties() {
        ITextTableProperties[] textTableProperties = new ITextTableProperties[this.getRowCount()];
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        int i = 0;
        while (i < textTables.length) {
            textTableProperties[i] = textTables[i].getProperties();
            ++i;
        }
        return textTableProperties;
    }

    @Override
    public void spreadColumnsEvenly() throws TextException {
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        int i = 0;
        while (i < textTables.length) {
            textTables[i].spreadColumnsEvenly();
            ++i;
        }
    }

    @Override
    public void spreadColumnsEvenly(int startIndex, int endIndex) throws TextException {
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        int i = 0;
        while (i < textTables.length) {
            textTables[i].spreadColumnsEvenly(startIndex, endIndex);
            ++i;
        }
    }

    @Override
    public IETextTableRow[] getRows() throws TextException {
        Object[] textTableRows = new IETextTableRow[]{};
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        int i = 0;
        while (i < textTables.length) {
            ITextTableRow[] textTableRow = textTables[i].getRows();
            Object[] rows = new IETextTableRow[textTableRow.length];
            int j = 0;
            while (j < textTableRow.length - 1) {
                IETextTableCellRange textTableCellRange = this.getCellRange(0, j, this.columnCount - 1, j);
                rows[j] = new ETextTableRow(textTableCellRange, textTableRows.length + 2, this);
                ++j;
            }
            try {
                textTableRows = (IETextTableRow[])ArrayUtils.appendArray(textTableRows, rows, IETextTableRow.class);
            }
            catch (Exception exception) {
                TextException textException = new TextException("The submitted type is not valid");
                textException.initCause(exception);
                throw textException;
            }
            ++i;
        }
        return textTableRows;
    }

    @Override
    public IETextTableRow getRow(int index) throws TextException {
        IETextTableCellRange textTableCellRange = this.getCellRange(0, index, this.columnCount - 1, index);
        ETextTableRow textTableRow = new ETextTableRow(textTableCellRange, index, this);
        return textTableRow;
    }

    private void cloneRange(ITextTable textTable, ITextTableCellRange textTableCellRange, int count, boolean adoptContent) throws CloneException, TextException {
        ITextTableCell textTableCell = textTable.getCell(0, count);
        DestinationPosition position = new DestinationPosition(textTableCell);
        textTableCellRange.getCloneService().cloneToPosition(position, adoptContent, null);
    }

    public int getTextTableIndex(ITextTable textTable) {
        return this.textTableManagement.getTextTableIndex(textTable);
    }

    public ITextTable getTextTable(int index) {
        return this.textTableManagement.getTextTable(index);
    }

    public ETextTableManagement getTextTableManagement() {
        return this.textTableManagement;
    }

    private void clearTableRange(IETextTableCellRange textTableCellRange) throws TextException {
        Object[][] clearData = textTableCellRange.getData();
        int i = 0;
        while (i < clearData.length) {
            int j = 0;
            while (j < clearData[i].length) {
                clearData[i][j] = "";
                ++j;
            }
            ++i;
        }
        textTableCellRange.setData(clearData);
    }

    @Override
    public void removeRow(int index) throws TextException {
        int tableNumber = this.getTableNumber(index);
        this.textTableManagement.getTextTable(tableNumber).removeRow(this.getRowIndexInTable(tableNumber, index));
    }

    @Override
    public void removeRows(int index, int count) throws TextException {
        int tableNumber = this.getTableNumber(index);
        int help = count / this.maxRowsInTable;
        if (help == 0) {
            this.textTableManagement.getTextTable(tableNumber).removeRows(this.getRowIndexInTable(tableNumber, index), count);
        } else {
            int removed = this.textTableManagement.getTextTable(tableNumber).getRowCount() - 1;
            this.textTableManagement.getTextTable(tableNumber).removeRows(this.getRowIndexInTable(tableNumber, index), this.textTableManagement.getTextTable(tableNumber).getRowCount() - 1);
            int i = 1;
            while (i < help) {
                removed += this.textTableManagement.getTextTable(tableNumber + 1).getRowCount();
                this.textTableManagement.getTextTable(tableNumber + 1).removeRows(0, this.textTableManagement.getTextTable(tableNumber).getRowCount() - 1);
                this.textTableManagement.removeTextTable(tableNumber + 1, this.textDocument);
                ++i;
            }
            this.textTableManagement.getTextTable(tableNumber).removeRows(this.getRowIndexInTable(tableNumber, index), count - removed);
        }
    }

    @Override
    public void removeRows(int index) throws TextException {
        int tableNumber = this.getTableNumber(index);
        int help = this.textTableManagement.getTextTables().length - tableNumber;
        this.textTableManagement.getTextTable(tableNumber).removeRows(this.getRowIndexInTable(tableNumber, index), this.textTableManagement.getTextTable(tableNumber).getRowCount() - 1);
        int i = 1;
        while (i < help) {
            this.textTableManagement.removeTextTable(tableNumber + 1, this.textDocument);
            ++i;
        }
    }

    public void removeTables(int index, int count) throws TextException {
        int i = index;
        while (i < index + count) {
            this.textTableManagement.removeTextTable(index, this.textDocument);
            ++i;
        }
    }

    @Override
    public void remove() throws TextException {
        try {
            ITextTable[] textTables = this.textTableManagement.getTextTables();
            int i = 0;
            while (i < textTables.length) {
                textTables[i].remove();
                ++i;
            }
            this.textTableManagement.removeTextTables();
        }
        catch (Exception exception) {
            TextException textException = new TextException("The specified table could not be removed");
            textException.initCause(exception);
        }
    }

    @Override
    public ICloneService getCloneService() throws CloneException {
        return new ETextTableCloneService(this, this.textDocument);
    }

    public void addTable(ITextTable textTable) throws TextException {
        if (textTable.getColumnCount() != this.columnCount) {
            throw new TextException("The subimitted table is not valid");
        }
        this.textTableManagement.addTextTable(textTable);
    }

    private int getTableNumber(int index) {
        int tableNumber = 0;
        int helpCount = 0;
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        int i = 0;
        while (i < textTables.length) {
            if ((helpCount += textTables[i].getRowCount()) > index) {
                tableNumber = i;
                break;
            }
            ++i;
        }
        return tableNumber;
    }

    private int getRowIndexInTable(int tableNumber, int rowIndex) {
        int rowInTableIndex = rowIndex;
        ITextTable[] textTables = this.textTableManagement.getTextTables();
        int i = 0;
        while (i < tableNumber) {
            rowInTableIndex -= textTables[i].getRowCount();
            ++i;
        }
        return rowInTableIndex;
    }
}

